/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * A folder. Only available in buckets with hierarchical namespace enabled.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Folder extends com.google.api.client.json.GenericJson {

  /**
   * The name of the bucket containing this folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucket;

  /**
   * The creation time of the folder in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createTime;

  /**
   * The ID of the folder, including the bucket name, folder name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The kind of item this is. For folders, this is always storage#folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The version of the metadata for this folder. Used for preconditions and for detecting changes
   * in metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long metageneration;

  /**
   * The name of the folder. Required if not specified by URL parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Only present if the folder is part of an ongoing rename folder operation. Contains information
   * which can be used to query the operation status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PendingRenameInfo pendingRenameInfo;

  /**
   * The link to this folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The modification time of the folder metadata in RFC 3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updateTime;

  /**
   * The name of the bucket containing this folder.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucket() {
    return bucket;
  }

  /**
   * The name of the bucket containing this folder.
   * @param bucket bucket or {@code null} for none
   */
  public Folder setBucket(java.lang.String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * The creation time of the folder in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreateTime() {
    return createTime;
  }

  /**
   * The creation time of the folder in RFC 3339 format.
   * @param createTime createTime or {@code null} for none
   */
  public Folder setCreateTime(com.google.api.client.util.DateTime createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The ID of the folder, including the bucket name, folder name.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the folder, including the bucket name, folder name.
   * @param id id or {@code null} for none
   */
  public Folder setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For folders, this is always storage#folder.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For folders, this is always storage#folder.
   * @param kind kind or {@code null} for none
   */
  public Folder setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The version of the metadata for this folder. Used for preconditions and for detecting changes
   * in metadata.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMetageneration() {
    return metageneration;
  }

  /**
   * The version of the metadata for this folder. Used for preconditions and for detecting changes
   * in metadata.
   * @param metageneration metageneration or {@code null} for none
   */
  public Folder setMetageneration(java.lang.Long metageneration) {
    this.metageneration = metageneration;
    return this;
  }

  /**
   * The name of the folder. Required if not specified by URL parameter.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the folder. Required if not specified by URL parameter.
   * @param name name or {@code null} for none
   */
  public Folder setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Only present if the folder is part of an ongoing rename folder operation. Contains information
   * which can be used to query the operation status.
   * @return value or {@code null} for none
   */
  public PendingRenameInfo getPendingRenameInfo() {
    return pendingRenameInfo;
  }

  /**
   * Only present if the folder is part of an ongoing rename folder operation. Contains information
   * which can be used to query the operation status.
   * @param pendingRenameInfo pendingRenameInfo or {@code null} for none
   */
  public Folder setPendingRenameInfo(PendingRenameInfo pendingRenameInfo) {
    this.pendingRenameInfo = pendingRenameInfo;
    return this;
  }

  /**
   * The link to this folder.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * The link to this folder.
   * @param selfLink selfLink or {@code null} for none
   */
  public Folder setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The modification time of the folder metadata in RFC 3339 format.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdateTime() {
    return updateTime;
  }

  /**
   * The modification time of the folder metadata in RFC 3339 format.
   * @param updateTime updateTime or {@code null} for none
   */
  public Folder setUpdateTime(com.google.api.client.util.DateTime updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public Folder set(String fieldName, Object value) {
    return (Folder) super.set(fieldName, value);
  }

  @Override
  public Folder clone() {
    return (Folder) super.clone();
  }

  /**
   * Only present if the folder is part of an ongoing rename folder operation. Contains information
   * which can be used to query the operation status.
   */
  public static final class PendingRenameInfo extends com.google.api.client.json.GenericJson {

    /**
     * The ID of the rename folder operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String operationId;

    /**
     * The ID of the rename folder operation.
     * @return value or {@code null} for none
     */
    public java.lang.String getOperationId() {
      return operationId;
    }

    /**
     * The ID of the rename folder operation.
     * @param operationId operationId or {@code null} for none
     */
    public PendingRenameInfo setOperationId(java.lang.String operationId) {
      this.operationId = operationId;
      return this;
    }

    @Override
    public PendingRenameInfo set(String fieldName, Object value) {
      return (PendingRenameInfo) super.set(fieldName, value);
    }

    @Override
    public PendingRenameInfo clone() {
      return (PendingRenameInfo) super.clone();
    }

  }

}
