/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * User level password validation policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserPasswordValidationPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Number of failed login attempts allowed before user get locked.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer allowedFailedAttempts;

  /**
   * If true, failed login attempts check will be enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableFailedAttemptsCheck;

  /**
   * If true, the user must specify the current password before changing the password. This flag is
   * supported only for MySQL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enablePasswordVerification;

  /**
   * Expiration duration after password is updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String passwordExpirationDuration;

  /**
   * Output only. Read-only password status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PasswordStatus status;

  /**
   * Number of failed login attempts allowed before user get locked.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAllowedFailedAttempts() {
    return allowedFailedAttempts;
  }

  /**
   * Number of failed login attempts allowed before user get locked.
   * @param allowedFailedAttempts allowedFailedAttempts or {@code null} for none
   */
  public UserPasswordValidationPolicy setAllowedFailedAttempts(java.lang.Integer allowedFailedAttempts) {
    this.allowedFailedAttempts = allowedFailedAttempts;
    return this;
  }

  /**
   * If true, failed login attempts check will be enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableFailedAttemptsCheck() {
    return enableFailedAttemptsCheck;
  }

  /**
   * If true, failed login attempts check will be enabled.
   * @param enableFailedAttemptsCheck enableFailedAttemptsCheck or {@code null} for none
   */
  public UserPasswordValidationPolicy setEnableFailedAttemptsCheck(java.lang.Boolean enableFailedAttemptsCheck) {
    this.enableFailedAttemptsCheck = enableFailedAttemptsCheck;
    return this;
  }

  /**
   * If true, the user must specify the current password before changing the password. This flag is
   * supported only for MySQL.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnablePasswordVerification() {
    return enablePasswordVerification;
  }

  /**
   * If true, the user must specify the current password before changing the password. This flag is
   * supported only for MySQL.
   * @param enablePasswordVerification enablePasswordVerification or {@code null} for none
   */
  public UserPasswordValidationPolicy setEnablePasswordVerification(java.lang.Boolean enablePasswordVerification) {
    this.enablePasswordVerification = enablePasswordVerification;
    return this;
  }

  /**
   * Expiration duration after password is updated.
   * @return value or {@code null} for none
   */
  public String getPasswordExpirationDuration() {
    return passwordExpirationDuration;
  }

  /**
   * Expiration duration after password is updated.
   * @param passwordExpirationDuration passwordExpirationDuration or {@code null} for none
   */
  public UserPasswordValidationPolicy setPasswordExpirationDuration(String passwordExpirationDuration) {
    this.passwordExpirationDuration = passwordExpirationDuration;
    return this;
  }

  /**
   * Output only. Read-only password status.
   * @return value or {@code null} for none
   */
  public PasswordStatus getStatus() {
    return status;
  }

  /**
   * Output only. Read-only password status.
   * @param status status or {@code null} for none
   */
  public UserPasswordValidationPolicy setStatus(PasswordStatus status) {
    this.status = status;
    return this;
  }

  @Override
  public UserPasswordValidationPolicy set(String fieldName, Object value) {
    return (UserPasswordValidationPolicy) super.set(fieldName, value);
  }

  @Override
  public UserPasswordValidationPolicy clone() {
    return (UserPasswordValidationPolicy) super.clone();
  }

}
