/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * This message wraps up the information written by out-of-disk detection job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SqlOutOfDiskReport extends com.google.api.client.json.GenericJson {

  /**
   * The minimum recommended increase size in GigaBytes This field is consumed by the frontend *
   * Writers: * the proactive database wellness job for OOD. * Readers:
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sqlMinRecommendedIncreaseSizeGb;

  /**
   * This field represents the state generated by the proactive database wellness job for OutOfDisk
   * issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive
   * database wellness job
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sqlOutOfDiskState;

  /**
   * The minimum recommended increase size in GigaBytes This field is consumed by the frontend *
   * Writers: * the proactive database wellness job for OOD. * Readers:
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSqlMinRecommendedIncreaseSizeGb() {
    return sqlMinRecommendedIncreaseSizeGb;
  }

  /**
   * The minimum recommended increase size in GigaBytes This field is consumed by the frontend *
   * Writers: * the proactive database wellness job for OOD. * Readers:
   * @param sqlMinRecommendedIncreaseSizeGb sqlMinRecommendedIncreaseSizeGb or {@code null} for none
   */
  public SqlOutOfDiskReport setSqlMinRecommendedIncreaseSizeGb(java.lang.Integer sqlMinRecommendedIncreaseSizeGb) {
    this.sqlMinRecommendedIncreaseSizeGb = sqlMinRecommendedIncreaseSizeGb;
    return this;
  }

  /**
   * This field represents the state generated by the proactive database wellness job for OutOfDisk
   * issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive
   * database wellness job
   * @return value or {@code null} for none
   */
  public java.lang.String getSqlOutOfDiskState() {
    return sqlOutOfDiskState;
  }

  /**
   * This field represents the state generated by the proactive database wellness job for OutOfDisk
   * issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive
   * database wellness job
   * @param sqlOutOfDiskState sqlOutOfDiskState or {@code null} for none
   */
  public SqlOutOfDiskReport setSqlOutOfDiskState(java.lang.String sqlOutOfDiskState) {
    this.sqlOutOfDiskState = sqlOutOfDiskState;
    return this;
  }

  @Override
  public SqlOutOfDiskReport set(String fieldName, Object value) {
    return (SqlOutOfDiskReport) super.set(fieldName, value);
  }

  @Override
  public SqlOutOfDiskReport clone() {
    return (SqlOutOfDiskReport) super.clone();
  }

}
