/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sqladmin.model;

/**
 * Deny Maintenance Periods. This specifies a date range during when all CSA rollout will be denied.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud SQL Admin API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DenyMaintenancePeriod extends com.google.api.client.json.GenericJson {

  /**
   * "deny maintenance period" end date. If the year of the end date is empty, the year of the start
   * date also must be empty. In this case, it means the deny maintenance period recurs every year.
   * The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endDate;

  /**
   * "deny maintenance period" start date. If the year of the start date is empty, the year of the
   * end date also must be empty. In this case, it means the deny maintenance period recurs every
   * year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startDate;

  /**
   * Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The
   * time is in format: HH:mm:SS, i.e., 00:00:00
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String time;

  /**
   * "deny maintenance period" end date. If the year of the end date is empty, the year of the start
   * date also must be empty. In this case, it means the deny maintenance period recurs every year.
   * The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
   * @return value or {@code null} for none
   */
  public java.lang.String getEndDate() {
    return endDate;
  }

  /**
   * "deny maintenance period" end date. If the year of the end date is empty, the year of the start
   * date also must be empty. In this case, it means the deny maintenance period recurs every year.
   * The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
   * @param endDate endDate or {@code null} for none
   */
  public DenyMaintenancePeriod setEndDate(java.lang.String endDate) {
    this.endDate = endDate;
    return this;
  }

  /**
   * "deny maintenance period" start date. If the year of the start date is empty, the year of the
   * end date also must be empty. In this case, it means the deny maintenance period recurs every
   * year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
   * @return value or {@code null} for none
   */
  public java.lang.String getStartDate() {
    return startDate;
  }

  /**
   * "deny maintenance period" start date. If the year of the start date is empty, the year of the
   * end date also must be empty. In this case, it means the deny maintenance period recurs every
   * year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
   * @param startDate startDate or {@code null} for none
   */
  public DenyMaintenancePeriod setStartDate(java.lang.String startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The
   * time is in format: HH:mm:SS, i.e., 00:00:00
   * @return value or {@code null} for none
   */
  public java.lang.String getTime() {
    return time;
  }

  /**
   * Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The
   * time is in format: HH:mm:SS, i.e., 00:00:00
   * @param time time or {@code null} for none
   */
  public DenyMaintenancePeriod setTime(java.lang.String time) {
    this.time = time;
    return this;
  }

  @Override
  public DenyMaintenancePeriod set(String fieldName, Object value) {
    return (DenyMaintenancePeriod) super.set(fieldName, value);
  }

  @Override
  public DenyMaintenancePeriod clone() {
    return (DenyMaintenancePeriod) super.clone();
  }

}
