/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-24 at 08:10:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A range of values whose location is specified by a DataFilter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataFilterValueRange extends com.google.api.client.json.GenericJson {

  /**
   * The data filter describing the location of the values in the spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataFilter dataFilter;

  /**
   * The major dimension of the values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String majorDimension;

  /**
   * The data to be written.  If the provided values exceed any of the ranges matched by the data
   * filter then the request fails.  If the provided values are less than the matched ranges only
   * the specified values are written, existing values in the matched ranges remain unaffected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.util.List<java.lang.Object>> values;

  /**
   * The data filter describing the location of the values in the spreadsheet.
   * @return value or {@code null} for none
   */
  public DataFilter getDataFilter() {
    return dataFilter;
  }

  /**
   * The data filter describing the location of the values in the spreadsheet.
   * @param dataFilter dataFilter or {@code null} for none
   */
  public DataFilterValueRange setDataFilter(DataFilter dataFilter) {
    this.dataFilter = dataFilter;
    return this;
  }

  /**
   * The major dimension of the values.
   * @return value or {@code null} for none
   */
  public java.lang.String getMajorDimension() {
    return majorDimension;
  }

  /**
   * The major dimension of the values.
   * @param majorDimension majorDimension or {@code null} for none
   */
  public DataFilterValueRange setMajorDimension(java.lang.String majorDimension) {
    this.majorDimension = majorDimension;
    return this;
  }

  /**
   * The data to be written.  If the provided values exceed any of the ranges matched by the data
   * filter then the request fails.  If the provided values are less than the matched ranges only
   * the specified values are written, existing values in the matched ranges remain unaffected.
   * @return value or {@code null} for none
   */
  public java.util.List<java.util.List<java.lang.Object>> getValues() {
    return values;
  }

  /**
   * The data to be written.  If the provided values exceed any of the ranges matched by the data
   * filter then the request fails.  If the provided values are less than the matched ranges only
   * the specified values are written, existing values in the matched ranges remain unaffected.
   * @param values values or {@code null} for none
   */
  public DataFilterValueRange setValues(java.util.List<java.util.List<java.lang.Object>> values) {
    this.values = values;
    return this;
  }

  @Override
  public DataFilterValueRange set(String fieldName, Object value) {
    return (DataFilterValueRange) super.set(fieldName, value);
  }

  @Override
  public DataFilterValueRange clone() {
    return (DataFilterValueRange) super.clone();
  }

}
