/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-04 at 23:20:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A histogram series containing the series color and data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HistogramSeries extends com.google.api.client.json.GenericJson {

  /**
   * The color of the column representing this series in each bucket. This field is optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color barColor;

  /**
   * The data for this histogram series.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChartData data;

  /**
   * The color of the column representing this series in each bucket. This field is optional.
   * @return value or {@code null} for none
   */
  public Color getBarColor() {
    return barColor;
  }

  /**
   * The color of the column representing this series in each bucket. This field is optional.
   * @param barColor barColor or {@code null} for none
   */
  public HistogramSeries setBarColor(Color barColor) {
    this.barColor = barColor;
    return this;
  }

  /**
   * The data for this histogram series.
   * @return value or {@code null} for none
   */
  public ChartData getData() {
    return data;
  }

  /**
   * The data for this histogram series.
   * @param data data or {@code null} for none
   */
  public HistogramSeries setData(ChartData data) {
    this.data = data;
    return this;
  }

  @Override
  public HistogramSeries set(String fieldName, Object value) {
    return (HistogramSeries) super.set(fieldName, value);
  }

  @Override
  public HistogramSeries clone() {
    return (HistogramSeries) super.clone();
  }

}
