/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-02-26 17:53:51 UTC)
 * on 2018-04-09 at 19:43:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Information about which values in a pivot group should be used for sorting.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PivotGroupSortValueBucket extends com.google.api.client.json.GenericJson {

  /**
   * Determines the bucket from which values are chosen to sort.
   *
   * For example, in a pivot table with one row group & two column groups, the row group can list up
   * to two values. The first value corresponds to a value within the first column group, and the
   * second value corresponds to a value in the second column group.  If no values are listed, this
   * would indicate that the row should be sorted according to the "Grand Total" over the column
   * groups. If a single value is listed, this would correspond to using the "Total" of that bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ExtendedValue> buckets;

  /**
   * The offset in the PivotTable.values list which the values in this grouping should be sorted by.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer valuesIndex;

  /**
   * Determines the bucket from which values are chosen to sort.
   *
   * For example, in a pivot table with one row group & two column groups, the row group can list up
   * to two values. The first value corresponds to a value within the first column group, and the
   * second value corresponds to a value in the second column group.  If no values are listed, this
   * would indicate that the row should be sorted according to the "Grand Total" over the column
   * groups. If a single value is listed, this would correspond to using the "Total" of that bucket.
   * @return value or {@code null} for none
   */
  public java.util.List<ExtendedValue> getBuckets() {
    return buckets;
  }

  /**
   * Determines the bucket from which values are chosen to sort.
   *
   * For example, in a pivot table with one row group & two column groups, the row group can list up
   * to two values. The first value corresponds to a value within the first column group, and the
   * second value corresponds to a value in the second column group.  If no values are listed, this
   * would indicate that the row should be sorted according to the "Grand Total" over the column
   * groups. If a single value is listed, this would correspond to using the "Total" of that bucket.
   * @param buckets buckets or {@code null} for none
   */
  public PivotGroupSortValueBucket setBuckets(java.util.List<ExtendedValue> buckets) {
    this.buckets = buckets;
    return this;
  }

  /**
   * The offset in the PivotTable.values list which the values in this grouping should be sorted by.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getValuesIndex() {
    return valuesIndex;
  }

  /**
   * The offset in the PivotTable.values list which the values in this grouping should be sorted by.
   * @param valuesIndex valuesIndex or {@code null} for none
   */
  public PivotGroupSortValueBucket setValuesIndex(java.lang.Integer valuesIndex) {
    this.valuesIndex = valuesIndex;
    return this;
  }

  @Override
  public PivotGroupSortValueBucket set(String fieldName, Object value) {
    return (PivotGroupSortValueBucket) super.set(fieldName, value);
  }

  @Override
  public PivotGroupSortValueBucket clone() {
    return (PivotGroupSortValueBucket) super.clone();
  }

}
