/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.sheets.v4;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.sheets.v4.SheetsRequest;
import com.google.api.services.sheets.v4.SheetsRequestInitializer;
import com.google.api.services.sheets.v4.model.AppendValuesResponse;
import com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterRequest;
import com.google.api.services.sheets.v4.model.BatchClearValuesByDataFilterResponse;
import com.google.api.services.sheets.v4.model.BatchClearValuesRequest;
import com.google.api.services.sheets.v4.model.BatchClearValuesResponse;
import com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterRequest;
import com.google.api.services.sheets.v4.model.BatchGetValuesByDataFilterResponse;
import com.google.api.services.sheets.v4.model.BatchGetValuesResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesByDataFilterResponse;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest;
import com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse;
import com.google.api.services.sheets.v4.model.ClearValuesRequest;
import com.google.api.services.sheets.v4.model.ClearValuesResponse;
import com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.DeveloperMetadata;
import com.google.api.services.sheets.v4.model.GetSpreadsheetByDataFilterRequest;
import com.google.api.services.sheets.v4.model.SearchDeveloperMetadataRequest;
import com.google.api.services.sheets.v4.model.SearchDeveloperMetadataResponse;
import com.google.api.services.sheets.v4.model.SheetProperties;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.UpdateValuesResponse;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.io.IOException;
import java.util.List;

public class Sheets
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://sheets.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://sheets.googleapis.com/";

    public Sheets(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Sheets(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Spreadsheets spreadsheets() {
        return new Spreadsheets();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.26.0 of the Google Sheets API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://sheets.googleapis.com/", Sheets.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Sheets.DEFAULT_BATCH_PATH);
        }

        public Sheets build() {
            return new Sheets(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setSheetsRequestInitializer(SheetsRequestInitializer sheetsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)sheetsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Spreadsheets {
        public BatchUpdate batchUpdate(String spreadsheetId, BatchUpdateSpreadsheetRequest content) throws IOException {
            BatchUpdate result = new BatchUpdate(spreadsheetId, content);
            Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Create create(Spreadsheet content) throws IOException {
            Create result = new Create(content);
            Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String spreadsheetId) throws IOException {
            Get result = new Get(spreadsheetId);
            Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetByDataFilter getByDataFilter(String spreadsheetId, GetSpreadsheetByDataFilterRequest content) throws IOException {
            GetByDataFilter result = new GetByDataFilter(spreadsheetId, content);
            Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public DeveloperMetadata developerMetadata() {
            return new DeveloperMetadata();
        }

        public SheetsOperations sheets() {
            return new SheetsOperations();
        }

        public Values values() {
            return new Values();
        }

        public class Values {
            public Append append(String spreadsheetId, String range, ValueRange content) throws IOException {
                Append result = new Append(spreadsheetId, range, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchClear batchClear(String spreadsheetId, BatchClearValuesRequest content) throws IOException {
                BatchClear result = new BatchClear(spreadsheetId, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchClearByDataFilter batchClearByDataFilter(String spreadsheetId, BatchClearValuesByDataFilterRequest content) throws IOException {
                BatchClearByDataFilter result = new BatchClearByDataFilter(spreadsheetId, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchGet batchGet(String spreadsheetId) throws IOException {
                BatchGet result = new BatchGet(spreadsheetId);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchGetByDataFilter batchGetByDataFilter(String spreadsheetId, BatchGetValuesByDataFilterRequest content) throws IOException {
                BatchGetByDataFilter result = new BatchGetByDataFilter(spreadsheetId, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchUpdate batchUpdate(String spreadsheetId, BatchUpdateValuesRequest content) throws IOException {
                BatchUpdate result = new BatchUpdate(spreadsheetId, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchUpdateByDataFilter batchUpdateByDataFilter(String spreadsheetId, BatchUpdateValuesByDataFilterRequest content) throws IOException {
                BatchUpdateByDataFilter result = new BatchUpdateByDataFilter(spreadsheetId, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Clear clear(String spreadsheetId, String range, ClearValuesRequest content) throws IOException {
                Clear result = new Clear(spreadsheetId, range, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String spreadsheetId, String range) throws IOException {
                Get result = new Get(spreadsheetId, range);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String spreadsheetId, String range, ValueRange content) throws IOException {
                Update result = new Update(spreadsheetId, range, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends SheetsRequest<UpdateValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}";
                @Key
                private String spreadsheetId;
                @Key
                private String range;
                @Key
                private Boolean includeValuesInResponse;
                @Key
                private String responseDateTimeRenderOption;
                @Key
                private String responseValueRenderOption;
                @Key
                private String valueInputOption;

                protected Update(String spreadsheetId, String range, ValueRange content) {
                    super(Sheets.this, "PUT", REST_PATH, (Object)content, UpdateValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                    this.range = (String)Preconditions.checkNotNull((Object)range, (Object)"Required parameter range must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Update setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                public String getRange() {
                    return this.range;
                }

                public Update setRange(String range) {
                    this.range = range;
                    return this;
                }

                public Boolean getIncludeValuesInResponse() {
                    return this.includeValuesInResponse;
                }

                public Update setIncludeValuesInResponse(Boolean includeValuesInResponse) {
                    this.includeValuesInResponse = includeValuesInResponse;
                    return this;
                }

                public String getResponseDateTimeRenderOption() {
                    return this.responseDateTimeRenderOption;
                }

                public Update setResponseDateTimeRenderOption(String responseDateTimeRenderOption) {
                    this.responseDateTimeRenderOption = responseDateTimeRenderOption;
                    return this;
                }

                public String getResponseValueRenderOption() {
                    return this.responseValueRenderOption;
                }

                public Update setResponseValueRenderOption(String responseValueRenderOption) {
                    this.responseValueRenderOption = responseValueRenderOption;
                    return this;
                }

                public String getValueInputOption() {
                    return this.valueInputOption;
                }

                public Update setValueInputOption(String valueInputOption) {
                    this.valueInputOption = valueInputOption;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Get
            extends SheetsRequest<ValueRange> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}";
                @Key
                private String spreadsheetId;
                @Key
                private String range;
                @Key
                private String dateTimeRenderOption;
                @Key
                private String majorDimension;
                @Key
                private String valueRenderOption;

                protected Get(String spreadsheetId, String range) {
                    super(Sheets.this, "GET", REST_PATH, null, ValueRange.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                    this.range = (String)Preconditions.checkNotNull((Object)range, (Object)"Required parameter range must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Get setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                public String getRange() {
                    return this.range;
                }

                public Get setRange(String range) {
                    this.range = range;
                    return this;
                }

                public String getDateTimeRenderOption() {
                    return this.dateTimeRenderOption;
                }

                public Get setDateTimeRenderOption(String dateTimeRenderOption) {
                    this.dateTimeRenderOption = dateTimeRenderOption;
                    return this;
                }

                public String getMajorDimension() {
                    return this.majorDimension;
                }

                public Get setMajorDimension(String majorDimension) {
                    this.majorDimension = majorDimension;
                    return this;
                }

                public String getValueRenderOption() {
                    return this.valueRenderOption;
                }

                public Get setValueRenderOption(String valueRenderOption) {
                    this.valueRenderOption = valueRenderOption;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Clear
            extends SheetsRequest<ClearValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}:clear";
                @Key
                private String spreadsheetId;
                @Key
                private String range;

                protected Clear(String spreadsheetId, String range, ClearValuesRequest content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, ClearValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                    this.range = (String)Preconditions.checkNotNull((Object)range, (Object)"Required parameter range must be specified.");
                }

                public Clear set$Xgafv(String $Xgafv) {
                    return (Clear)super.set$Xgafv($Xgafv);
                }

                public Clear setAccessToken(String accessToken) {
                    return (Clear)super.setAccessToken(accessToken);
                }

                public Clear setAlt(String alt) {
                    return (Clear)super.setAlt(alt);
                }

                public Clear setCallback(String callback) {
                    return (Clear)super.setCallback(callback);
                }

                public Clear setFields(String fields) {
                    return (Clear)super.setFields(fields);
                }

                public Clear setKey(String key) {
                    return (Clear)super.setKey(key);
                }

                public Clear setOauthToken(String oauthToken) {
                    return (Clear)super.setOauthToken(oauthToken);
                }

                public Clear setPrettyPrint(Boolean prettyPrint) {
                    return (Clear)super.setPrettyPrint(prettyPrint);
                }

                public Clear setQuotaUser(String quotaUser) {
                    return (Clear)super.setQuotaUser(quotaUser);
                }

                public Clear setUploadType(String uploadType) {
                    return (Clear)super.setUploadType(uploadType);
                }

                public Clear setUploadProtocol(String uploadProtocol) {
                    return (Clear)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Clear setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                public String getRange() {
                    return this.range;
                }

                public Clear setRange(String range) {
                    this.range = range;
                    return this;
                }

                @Override
                public Clear set(String parameterName, Object value) {
                    return (Clear)super.set(parameterName, value);
                }
            }

            public class BatchUpdateByDataFilter
            extends SheetsRequest<BatchUpdateValuesByDataFilterResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchUpdateByDataFilter";
                @Key
                private String spreadsheetId;

                protected BatchUpdateByDataFilter(String spreadsheetId, BatchUpdateValuesByDataFilterRequest content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, BatchUpdateValuesByDataFilterResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchUpdateByDataFilter set$Xgafv(String $Xgafv) {
                    return (BatchUpdateByDataFilter)super.set$Xgafv($Xgafv);
                }

                public BatchUpdateByDataFilter setAccessToken(String accessToken) {
                    return (BatchUpdateByDataFilter)super.setAccessToken(accessToken);
                }

                public BatchUpdateByDataFilter setAlt(String alt) {
                    return (BatchUpdateByDataFilter)super.setAlt(alt);
                }

                public BatchUpdateByDataFilter setCallback(String callback) {
                    return (BatchUpdateByDataFilter)super.setCallback(callback);
                }

                public BatchUpdateByDataFilter setFields(String fields) {
                    return (BatchUpdateByDataFilter)super.setFields(fields);
                }

                public BatchUpdateByDataFilter setKey(String key) {
                    return (BatchUpdateByDataFilter)super.setKey(key);
                }

                public BatchUpdateByDataFilter setOauthToken(String oauthToken) {
                    return (BatchUpdateByDataFilter)super.setOauthToken(oauthToken);
                }

                public BatchUpdateByDataFilter setPrettyPrint(Boolean prettyPrint) {
                    return (BatchUpdateByDataFilter)super.setPrettyPrint(prettyPrint);
                }

                public BatchUpdateByDataFilter setQuotaUser(String quotaUser) {
                    return (BatchUpdateByDataFilter)super.setQuotaUser(quotaUser);
                }

                public BatchUpdateByDataFilter setUploadType(String uploadType) {
                    return (BatchUpdateByDataFilter)super.setUploadType(uploadType);
                }

                public BatchUpdateByDataFilter setUploadProtocol(String uploadProtocol) {
                    return (BatchUpdateByDataFilter)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchUpdateByDataFilter setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                @Override
                public BatchUpdateByDataFilter set(String parameterName, Object value) {
                    return (BatchUpdateByDataFilter)super.set(parameterName, value);
                }
            }

            public class BatchUpdate
            extends SheetsRequest<BatchUpdateValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchUpdate";
                @Key
                private String spreadsheetId;

                protected BatchUpdate(String spreadsheetId, BatchUpdateValuesRequest content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, BatchUpdateValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchUpdate set$Xgafv(String $Xgafv) {
                    return (BatchUpdate)super.set$Xgafv($Xgafv);
                }

                public BatchUpdate setAccessToken(String accessToken) {
                    return (BatchUpdate)super.setAccessToken(accessToken);
                }

                public BatchUpdate setAlt(String alt) {
                    return (BatchUpdate)super.setAlt(alt);
                }

                public BatchUpdate setCallback(String callback) {
                    return (BatchUpdate)super.setCallback(callback);
                }

                public BatchUpdate setFields(String fields) {
                    return (BatchUpdate)super.setFields(fields);
                }

                public BatchUpdate setKey(String key) {
                    return (BatchUpdate)super.setKey(key);
                }

                public BatchUpdate setOauthToken(String oauthToken) {
                    return (BatchUpdate)super.setOauthToken(oauthToken);
                }

                public BatchUpdate setPrettyPrint(Boolean prettyPrint) {
                    return (BatchUpdate)super.setPrettyPrint(prettyPrint);
                }

                public BatchUpdate setQuotaUser(String quotaUser) {
                    return (BatchUpdate)super.setQuotaUser(quotaUser);
                }

                public BatchUpdate setUploadType(String uploadType) {
                    return (BatchUpdate)super.setUploadType(uploadType);
                }

                public BatchUpdate setUploadProtocol(String uploadProtocol) {
                    return (BatchUpdate)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchUpdate setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                @Override
                public BatchUpdate set(String parameterName, Object value) {
                    return (BatchUpdate)super.set(parameterName, value);
                }
            }

            public class BatchGetByDataFilter
            extends SheetsRequest<BatchGetValuesByDataFilterResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchGetByDataFilter";
                @Key
                private String spreadsheetId;

                protected BatchGetByDataFilter(String spreadsheetId, BatchGetValuesByDataFilterRequest content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, BatchGetValuesByDataFilterResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchGetByDataFilter set$Xgafv(String $Xgafv) {
                    return (BatchGetByDataFilter)super.set$Xgafv($Xgafv);
                }

                public BatchGetByDataFilter setAccessToken(String accessToken) {
                    return (BatchGetByDataFilter)super.setAccessToken(accessToken);
                }

                public BatchGetByDataFilter setAlt(String alt) {
                    return (BatchGetByDataFilter)super.setAlt(alt);
                }

                public BatchGetByDataFilter setCallback(String callback) {
                    return (BatchGetByDataFilter)super.setCallback(callback);
                }

                public BatchGetByDataFilter setFields(String fields) {
                    return (BatchGetByDataFilter)super.setFields(fields);
                }

                public BatchGetByDataFilter setKey(String key) {
                    return (BatchGetByDataFilter)super.setKey(key);
                }

                public BatchGetByDataFilter setOauthToken(String oauthToken) {
                    return (BatchGetByDataFilter)super.setOauthToken(oauthToken);
                }

                public BatchGetByDataFilter setPrettyPrint(Boolean prettyPrint) {
                    return (BatchGetByDataFilter)super.setPrettyPrint(prettyPrint);
                }

                public BatchGetByDataFilter setQuotaUser(String quotaUser) {
                    return (BatchGetByDataFilter)super.setQuotaUser(quotaUser);
                }

                public BatchGetByDataFilter setUploadType(String uploadType) {
                    return (BatchGetByDataFilter)super.setUploadType(uploadType);
                }

                public BatchGetByDataFilter setUploadProtocol(String uploadProtocol) {
                    return (BatchGetByDataFilter)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchGetByDataFilter setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                @Override
                public BatchGetByDataFilter set(String parameterName, Object value) {
                    return (BatchGetByDataFilter)super.set(parameterName, value);
                }
            }

            public class BatchGet
            extends SheetsRequest<BatchGetValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchGet";
                @Key
                private String spreadsheetId;
                @Key
                private String dateTimeRenderOption;
                @Key
                private String majorDimension;
                @Key
                private List<String> ranges;
                @Key
                private String valueRenderOption;

                protected BatchGet(String spreadsheetId) {
                    super(Sheets.this, "GET", REST_PATH, null, BatchGetValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public BatchGet set$Xgafv(String $Xgafv) {
                    return (BatchGet)super.set$Xgafv($Xgafv);
                }

                public BatchGet setAccessToken(String accessToken) {
                    return (BatchGet)super.setAccessToken(accessToken);
                }

                public BatchGet setAlt(String alt) {
                    return (BatchGet)super.setAlt(alt);
                }

                public BatchGet setCallback(String callback) {
                    return (BatchGet)super.setCallback(callback);
                }

                public BatchGet setFields(String fields) {
                    return (BatchGet)super.setFields(fields);
                }

                public BatchGet setKey(String key) {
                    return (BatchGet)super.setKey(key);
                }

                public BatchGet setOauthToken(String oauthToken) {
                    return (BatchGet)super.setOauthToken(oauthToken);
                }

                public BatchGet setPrettyPrint(Boolean prettyPrint) {
                    return (BatchGet)super.setPrettyPrint(prettyPrint);
                }

                public BatchGet setQuotaUser(String quotaUser) {
                    return (BatchGet)super.setQuotaUser(quotaUser);
                }

                public BatchGet setUploadType(String uploadType) {
                    return (BatchGet)super.setUploadType(uploadType);
                }

                public BatchGet setUploadProtocol(String uploadProtocol) {
                    return (BatchGet)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchGet setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                public String getDateTimeRenderOption() {
                    return this.dateTimeRenderOption;
                }

                public BatchGet setDateTimeRenderOption(String dateTimeRenderOption) {
                    this.dateTimeRenderOption = dateTimeRenderOption;
                    return this;
                }

                public String getMajorDimension() {
                    return this.majorDimension;
                }

                public BatchGet setMajorDimension(String majorDimension) {
                    this.majorDimension = majorDimension;
                    return this;
                }

                public List<String> getRanges() {
                    return this.ranges;
                }

                public BatchGet setRanges(List<String> ranges) {
                    this.ranges = ranges;
                    return this;
                }

                public String getValueRenderOption() {
                    return this.valueRenderOption;
                }

                public BatchGet setValueRenderOption(String valueRenderOption) {
                    this.valueRenderOption = valueRenderOption;
                    return this;
                }

                @Override
                public BatchGet set(String parameterName, Object value) {
                    return (BatchGet)super.set(parameterName, value);
                }
            }

            public class BatchClearByDataFilter
            extends SheetsRequest<BatchClearValuesByDataFilterResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchClearByDataFilter";
                @Key
                private String spreadsheetId;

                protected BatchClearByDataFilter(String spreadsheetId, BatchClearValuesByDataFilterRequest content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, BatchClearValuesByDataFilterResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchClearByDataFilter set$Xgafv(String $Xgafv) {
                    return (BatchClearByDataFilter)super.set$Xgafv($Xgafv);
                }

                public BatchClearByDataFilter setAccessToken(String accessToken) {
                    return (BatchClearByDataFilter)super.setAccessToken(accessToken);
                }

                public BatchClearByDataFilter setAlt(String alt) {
                    return (BatchClearByDataFilter)super.setAlt(alt);
                }

                public BatchClearByDataFilter setCallback(String callback) {
                    return (BatchClearByDataFilter)super.setCallback(callback);
                }

                public BatchClearByDataFilter setFields(String fields) {
                    return (BatchClearByDataFilter)super.setFields(fields);
                }

                public BatchClearByDataFilter setKey(String key) {
                    return (BatchClearByDataFilter)super.setKey(key);
                }

                public BatchClearByDataFilter setOauthToken(String oauthToken) {
                    return (BatchClearByDataFilter)super.setOauthToken(oauthToken);
                }

                public BatchClearByDataFilter setPrettyPrint(Boolean prettyPrint) {
                    return (BatchClearByDataFilter)super.setPrettyPrint(prettyPrint);
                }

                public BatchClearByDataFilter setQuotaUser(String quotaUser) {
                    return (BatchClearByDataFilter)super.setQuotaUser(quotaUser);
                }

                public BatchClearByDataFilter setUploadType(String uploadType) {
                    return (BatchClearByDataFilter)super.setUploadType(uploadType);
                }

                public BatchClearByDataFilter setUploadProtocol(String uploadProtocol) {
                    return (BatchClearByDataFilter)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchClearByDataFilter setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                @Override
                public BatchClearByDataFilter set(String parameterName, Object value) {
                    return (BatchClearByDataFilter)super.set(parameterName, value);
                }
            }

            public class BatchClear
            extends SheetsRequest<BatchClearValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchClear";
                @Key
                private String spreadsheetId;

                protected BatchClear(String spreadsheetId, BatchClearValuesRequest content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, BatchClearValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public BatchClear set$Xgafv(String $Xgafv) {
                    return (BatchClear)super.set$Xgafv($Xgafv);
                }

                public BatchClear setAccessToken(String accessToken) {
                    return (BatchClear)super.setAccessToken(accessToken);
                }

                public BatchClear setAlt(String alt) {
                    return (BatchClear)super.setAlt(alt);
                }

                public BatchClear setCallback(String callback) {
                    return (BatchClear)super.setCallback(callback);
                }

                public BatchClear setFields(String fields) {
                    return (BatchClear)super.setFields(fields);
                }

                public BatchClear setKey(String key) {
                    return (BatchClear)super.setKey(key);
                }

                public BatchClear setOauthToken(String oauthToken) {
                    return (BatchClear)super.setOauthToken(oauthToken);
                }

                public BatchClear setPrettyPrint(Boolean prettyPrint) {
                    return (BatchClear)super.setPrettyPrint(prettyPrint);
                }

                public BatchClear setQuotaUser(String quotaUser) {
                    return (BatchClear)super.setQuotaUser(quotaUser);
                }

                public BatchClear setUploadType(String uploadType) {
                    return (BatchClear)super.setUploadType(uploadType);
                }

                public BatchClear setUploadProtocol(String uploadProtocol) {
                    return (BatchClear)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public BatchClear setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                @Override
                public BatchClear set(String parameterName, Object value) {
                    return (BatchClear)super.set(parameterName, value);
                }
            }

            public class Append
            extends SheetsRequest<AppendValuesResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}:append";
                @Key
                private String spreadsheetId;
                @Key
                private String range;
                @Key
                private Boolean includeValuesInResponse;
                @Key
                private String insertDataOption;
                @Key
                private String responseDateTimeRenderOption;
                @Key
                private String responseValueRenderOption;
                @Key
                private String valueInputOption;

                protected Append(String spreadsheetId, String range, ValueRange content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, AppendValuesResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                    this.range = (String)Preconditions.checkNotNull((Object)range, (Object)"Required parameter range must be specified.");
                }

                public Append set$Xgafv(String $Xgafv) {
                    return (Append)super.set$Xgafv($Xgafv);
                }

                public Append setAccessToken(String accessToken) {
                    return (Append)super.setAccessToken(accessToken);
                }

                public Append setAlt(String alt) {
                    return (Append)super.setAlt(alt);
                }

                public Append setCallback(String callback) {
                    return (Append)super.setCallback(callback);
                }

                public Append setFields(String fields) {
                    return (Append)super.setFields(fields);
                }

                public Append setKey(String key) {
                    return (Append)super.setKey(key);
                }

                public Append setOauthToken(String oauthToken) {
                    return (Append)super.setOauthToken(oauthToken);
                }

                public Append setPrettyPrint(Boolean prettyPrint) {
                    return (Append)super.setPrettyPrint(prettyPrint);
                }

                public Append setQuotaUser(String quotaUser) {
                    return (Append)super.setQuotaUser(quotaUser);
                }

                public Append setUploadType(String uploadType) {
                    return (Append)super.setUploadType(uploadType);
                }

                public Append setUploadProtocol(String uploadProtocol) {
                    return (Append)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Append setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                public String getRange() {
                    return this.range;
                }

                public Append setRange(String range) {
                    this.range = range;
                    return this;
                }

                public Boolean getIncludeValuesInResponse() {
                    return this.includeValuesInResponse;
                }

                public Append setIncludeValuesInResponse(Boolean includeValuesInResponse) {
                    this.includeValuesInResponse = includeValuesInResponse;
                    return this;
                }

                public String getInsertDataOption() {
                    return this.insertDataOption;
                }

                public Append setInsertDataOption(String insertDataOption) {
                    this.insertDataOption = insertDataOption;
                    return this;
                }

                public String getResponseDateTimeRenderOption() {
                    return this.responseDateTimeRenderOption;
                }

                public Append setResponseDateTimeRenderOption(String responseDateTimeRenderOption) {
                    this.responseDateTimeRenderOption = responseDateTimeRenderOption;
                    return this;
                }

                public String getResponseValueRenderOption() {
                    return this.responseValueRenderOption;
                }

                public Append setResponseValueRenderOption(String responseValueRenderOption) {
                    this.responseValueRenderOption = responseValueRenderOption;
                    return this;
                }

                public String getValueInputOption() {
                    return this.valueInputOption;
                }

                public Append setValueInputOption(String valueInputOption) {
                    this.valueInputOption = valueInputOption;
                    return this;
                }

                @Override
                public Append set(String parameterName, Object value) {
                    return (Append)super.set(parameterName, value);
                }
            }
        }

        public class SheetsOperations {
            public CopyTo copyTo(String spreadsheetId, Integer sheetId, CopySheetToAnotherSpreadsheetRequest content) throws IOException {
                CopyTo result = new CopyTo(spreadsheetId, sheetId, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class CopyTo
            extends SheetsRequest<SheetProperties> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/sheets/{sheetId}:copyTo";
                @Key
                private String spreadsheetId;
                @Key
                private Integer sheetId;

                protected CopyTo(String spreadsheetId, Integer sheetId, CopySheetToAnotherSpreadsheetRequest content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, SheetProperties.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                    this.sheetId = (Integer)Preconditions.checkNotNull((Object)sheetId, (Object)"Required parameter sheetId must be specified.");
                }

                public CopyTo set$Xgafv(String $Xgafv) {
                    return (CopyTo)super.set$Xgafv($Xgafv);
                }

                public CopyTo setAccessToken(String accessToken) {
                    return (CopyTo)super.setAccessToken(accessToken);
                }

                public CopyTo setAlt(String alt) {
                    return (CopyTo)super.setAlt(alt);
                }

                public CopyTo setCallback(String callback) {
                    return (CopyTo)super.setCallback(callback);
                }

                public CopyTo setFields(String fields) {
                    return (CopyTo)super.setFields(fields);
                }

                public CopyTo setKey(String key) {
                    return (CopyTo)super.setKey(key);
                }

                public CopyTo setOauthToken(String oauthToken) {
                    return (CopyTo)super.setOauthToken(oauthToken);
                }

                public CopyTo setPrettyPrint(Boolean prettyPrint) {
                    return (CopyTo)super.setPrettyPrint(prettyPrint);
                }

                public CopyTo setQuotaUser(String quotaUser) {
                    return (CopyTo)super.setQuotaUser(quotaUser);
                }

                public CopyTo setUploadType(String uploadType) {
                    return (CopyTo)super.setUploadType(uploadType);
                }

                public CopyTo setUploadProtocol(String uploadProtocol) {
                    return (CopyTo)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public CopyTo setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                public Integer getSheetId() {
                    return this.sheetId;
                }

                public CopyTo setSheetId(Integer sheetId) {
                    this.sheetId = sheetId;
                    return this;
                }

                @Override
                public CopyTo set(String parameterName, Object value) {
                    return (CopyTo)super.set(parameterName, value);
                }
            }
        }

        public class DeveloperMetadata {
            public Get get(String spreadsheetId, Integer metadataId) throws IOException {
                Get result = new Get(spreadsheetId, metadataId);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Search search(String spreadsheetId, SearchDeveloperMetadataRequest content) throws IOException {
                Search result = new Search(spreadsheetId, content);
                Sheets.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Search
            extends SheetsRequest<SearchDeveloperMetadataResponse> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/developerMetadata:search";
                @Key
                private String spreadsheetId;

                protected Search(String spreadsheetId, SearchDeveloperMetadataRequest content) {
                    super(Sheets.this, "POST", REST_PATH, (Object)content, SearchDeveloperMetadataResponse.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                }

                public Search set$Xgafv(String $Xgafv) {
                    return (Search)super.set$Xgafv($Xgafv);
                }

                public Search setAccessToken(String accessToken) {
                    return (Search)super.setAccessToken(accessToken);
                }

                public Search setAlt(String alt) {
                    return (Search)super.setAlt(alt);
                }

                public Search setCallback(String callback) {
                    return (Search)super.setCallback(callback);
                }

                public Search setFields(String fields) {
                    return (Search)super.setFields(fields);
                }

                public Search setKey(String key) {
                    return (Search)super.setKey(key);
                }

                public Search setOauthToken(String oauthToken) {
                    return (Search)super.setOauthToken(oauthToken);
                }

                public Search setPrettyPrint(Boolean prettyPrint) {
                    return (Search)super.setPrettyPrint(prettyPrint);
                }

                public Search setQuotaUser(String quotaUser) {
                    return (Search)super.setQuotaUser(quotaUser);
                }

                public Search setUploadType(String uploadType) {
                    return (Search)super.setUploadType(uploadType);
                }

                public Search setUploadProtocol(String uploadProtocol) {
                    return (Search)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Search setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                @Override
                public Search set(String parameterName, Object value) {
                    return (Search)super.set(parameterName, value);
                }
            }

            public class Get
            extends SheetsRequest<com.google.api.services.sheets.v4.model.DeveloperMetadata> {
                private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/developerMetadata/{metadataId}";
                @Key
                private String spreadsheetId;
                @Key
                private Integer metadataId;

                protected Get(String spreadsheetId, Integer metadataId) {
                    super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.DeveloperMetadata.class);
                    this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
                    this.metadataId = (Integer)Preconditions.checkNotNull((Object)metadataId, (Object)"Required parameter metadataId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getSpreadsheetId() {
                    return this.spreadsheetId;
                }

                public Get setSpreadsheetId(String spreadsheetId) {
                    this.spreadsheetId = spreadsheetId;
                    return this;
                }

                public Integer getMetadataId() {
                    return this.metadataId;
                }

                public Get setMetadataId(Integer metadataId) {
                    this.metadataId = metadataId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class GetByDataFilter
        extends SheetsRequest<Spreadsheet> {
            private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}:getByDataFilter";
            @Key
            private String spreadsheetId;

            protected GetByDataFilter(String spreadsheetId, GetSpreadsheetByDataFilterRequest content) {
                super(Sheets.this, "POST", REST_PATH, (Object)content, Spreadsheet.class);
                this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
            }

            public GetByDataFilter set$Xgafv(String $Xgafv) {
                return (GetByDataFilter)super.set$Xgafv($Xgafv);
            }

            public GetByDataFilter setAccessToken(String accessToken) {
                return (GetByDataFilter)super.setAccessToken(accessToken);
            }

            public GetByDataFilter setAlt(String alt) {
                return (GetByDataFilter)super.setAlt(alt);
            }

            public GetByDataFilter setCallback(String callback) {
                return (GetByDataFilter)super.setCallback(callback);
            }

            public GetByDataFilter setFields(String fields) {
                return (GetByDataFilter)super.setFields(fields);
            }

            public GetByDataFilter setKey(String key) {
                return (GetByDataFilter)super.setKey(key);
            }

            public GetByDataFilter setOauthToken(String oauthToken) {
                return (GetByDataFilter)super.setOauthToken(oauthToken);
            }

            public GetByDataFilter setPrettyPrint(Boolean prettyPrint) {
                return (GetByDataFilter)super.setPrettyPrint(prettyPrint);
            }

            public GetByDataFilter setQuotaUser(String quotaUser) {
                return (GetByDataFilter)super.setQuotaUser(quotaUser);
            }

            public GetByDataFilter setUploadType(String uploadType) {
                return (GetByDataFilter)super.setUploadType(uploadType);
            }

            public GetByDataFilter setUploadProtocol(String uploadProtocol) {
                return (GetByDataFilter)super.setUploadProtocol(uploadProtocol);
            }

            public String getSpreadsheetId() {
                return this.spreadsheetId;
            }

            public GetByDataFilter setSpreadsheetId(String spreadsheetId) {
                this.spreadsheetId = spreadsheetId;
                return this;
            }

            @Override
            public GetByDataFilter set(String parameterName, Object value) {
                return (GetByDataFilter)super.set(parameterName, value);
            }
        }

        public class Get
        extends SheetsRequest<Spreadsheet> {
            private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}";
            @Key
            private String spreadsheetId;
            @Key
            private Boolean includeGridData;
            @Key
            private List<String> ranges;

            protected Get(String spreadsheetId) {
                super(Sheets.this, "GET", REST_PATH, null, Spreadsheet.class);
                this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getSpreadsheetId() {
                return this.spreadsheetId;
            }

            public Get setSpreadsheetId(String spreadsheetId) {
                this.spreadsheetId = spreadsheetId;
                return this;
            }

            public Boolean getIncludeGridData() {
                return this.includeGridData;
            }

            public Get setIncludeGridData(Boolean includeGridData) {
                this.includeGridData = includeGridData;
                return this;
            }

            public List<String> getRanges() {
                return this.ranges;
            }

            public Get setRanges(List<String> ranges) {
                this.ranges = ranges;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends SheetsRequest<Spreadsheet> {
            private static final String REST_PATH = "v4/spreadsheets";

            protected Create(Spreadsheet content) {
                super(Sheets.this, "POST", REST_PATH, (Object)content, Spreadsheet.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }

        public class BatchUpdate
        extends SheetsRequest<BatchUpdateSpreadsheetResponse> {
            private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}:batchUpdate";
            @Key
            private String spreadsheetId;

            protected BatchUpdate(String spreadsheetId, BatchUpdateSpreadsheetRequest content) {
                super(Sheets.this, "POST", REST_PATH, (Object)content, BatchUpdateSpreadsheetResponse.class);
                this.spreadsheetId = (String)Preconditions.checkNotNull((Object)spreadsheetId, (Object)"Required parameter spreadsheetId must be specified.");
            }

            public BatchUpdate set$Xgafv(String $Xgafv) {
                return (BatchUpdate)super.set$Xgafv($Xgafv);
            }

            public BatchUpdate setAccessToken(String accessToken) {
                return (BatchUpdate)super.setAccessToken(accessToken);
            }

            public BatchUpdate setAlt(String alt) {
                return (BatchUpdate)super.setAlt(alt);
            }

            public BatchUpdate setCallback(String callback) {
                return (BatchUpdate)super.setCallback(callback);
            }

            public BatchUpdate setFields(String fields) {
                return (BatchUpdate)super.setFields(fields);
            }

            public BatchUpdate setKey(String key) {
                return (BatchUpdate)super.setKey(key);
            }

            public BatchUpdate setOauthToken(String oauthToken) {
                return (BatchUpdate)super.setOauthToken(oauthToken);
            }

            public BatchUpdate setPrettyPrint(Boolean prettyPrint) {
                return (BatchUpdate)super.setPrettyPrint(prettyPrint);
            }

            public BatchUpdate setQuotaUser(String quotaUser) {
                return (BatchUpdate)super.setQuotaUser(quotaUser);
            }

            public BatchUpdate setUploadType(String uploadType) {
                return (BatchUpdate)super.setUploadType(uploadType);
            }

            public BatchUpdate setUploadProtocol(String uploadProtocol) {
                return (BatchUpdate)super.setUploadProtocol(uploadProtocol);
            }

            public String getSpreadsheetId() {
                return this.spreadsheetId;
            }

            public BatchUpdate setSpreadsheetId(String spreadsheetId) {
                this.spreadsheetId = spreadsheetId;
                return this;
            }

            @Override
            public BatchUpdate set(String parameterName, Object value) {
                return (BatchUpdate)super.set(parameterName, value);
            }
        }
    }
}

