/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Settings for validating messages published against a schema.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SchemaSettings extends com.google.api.client.json.GenericJson {

  /**
   * The encoding of messages validated against `schema`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String encoding;

  /**
   * Required. The name of the schema that messages published should be validated against. Format is
   * `projects/{project}/schemas/{schema}`. The value of this field will be `_deleted-schema_` if
   * the schema has been deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String schema;

  /**
   * The encoding of messages validated against `schema`.
   * @return value or {@code null} for none
   */
  public java.lang.String getEncoding() {
    return encoding;
  }

  /**
   * The encoding of messages validated against `schema`.
   * @param encoding encoding or {@code null} for none
   */
  public SchemaSettings setEncoding(java.lang.String encoding) {
    this.encoding = encoding;
    return this;
  }

  /**
   * Required. The name of the schema that messages published should be validated against. Format is
   * `projects/{project}/schemas/{schema}`. The value of this field will be `_deleted-schema_` if
   * the schema has been deleted.
   * @return value or {@code null} for none
   */
  public java.lang.String getSchema() {
    return schema;
  }

  /**
   * Required. The name of the schema that messages published should be validated against. Format is
   * `projects/{project}/schemas/{schema}`. The value of this field will be `_deleted-schema_` if
   * the schema has been deleted.
   * @param schema schema or {@code null} for none
   */
  public SchemaSettings setSchema(java.lang.String schema) {
    this.schema = schema;
    return this;
  }

  @Override
  public SchemaSettings set(String fieldName, Object value) {
    return (SchemaSettings) super.set(fieldName, value);
  }

  @Override
  public SchemaSettings clone() {
    return (SchemaSettings) super.clone();
  }

}
