/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Configuration for a push delivery endpoint.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PushConfig extends com.google.api.client.json.GenericJson {

  /**
   * Endpoint configuration attributes that can be used to control different aspects of the message
   * delivery. The only currently supported attribute is `x-goog-version`, which you can use to
   * change the format of the pushed message. This attribute indicates the version of the data
   * expected by the endpoint. This controls the shape of the pushed message (i.e., its fields and
   * metadata). If not present during the `CreateSubscription` call, it will default to the version
   * of the Pub/Sub API used to make such call. If not present in a `ModifyPushConfig` call, its
   * value will not be changed. `GetSubscription` calls will always return a valid version, even if
   * the subscription was created without this attribute. The only supported values for the `x-goog-
   * version` attribute are: * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API. *
   * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API. For example: attributes
   * { "x-goog-version": "v1" }
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> attributes;

  /**
   * If specified, Pub/Sub will generate and attach an OIDC JWT token as an `Authorization` header
   * in the HTTP request for every pushed message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OidcToken oidcToken;

  /**
   * A URL locating the endpoint to which messages should be pushed. For example, a Webhook endpoint
   * might use `https://example.com/push`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pushEndpoint;

  /**
   * Endpoint configuration attributes that can be used to control different aspects of the message
   * delivery. The only currently supported attribute is `x-goog-version`, which you can use to
   * change the format of the pushed message. This attribute indicates the version of the data
   * expected by the endpoint. This controls the shape of the pushed message (i.e., its fields and
   * metadata). If not present during the `CreateSubscription` call, it will default to the version
   * of the Pub/Sub API used to make such call. If not present in a `ModifyPushConfig` call, its
   * value will not be changed. `GetSubscription` calls will always return a valid version, even if
   * the subscription was created without this attribute. The only supported values for the `x-goog-
   * version` attribute are: * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API. *
   * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API. For example: attributes
   * { "x-goog-version": "v1" }
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getAttributes() {
    return attributes;
  }

  /**
   * Endpoint configuration attributes that can be used to control different aspects of the message
   * delivery. The only currently supported attribute is `x-goog-version`, which you can use to
   * change the format of the pushed message. This attribute indicates the version of the data
   * expected by the endpoint. This controls the shape of the pushed message (i.e., its fields and
   * metadata). If not present during the `CreateSubscription` call, it will default to the version
   * of the Pub/Sub API used to make such call. If not present in a `ModifyPushConfig` call, its
   * value will not be changed. `GetSubscription` calls will always return a valid version, even if
   * the subscription was created without this attribute. The only supported values for the `x-goog-
   * version` attribute are: * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API. *
   * `v1` or `v1beta2`: uses the push format defined in the v1 Pub/Sub API. For example: attributes
   * { "x-goog-version": "v1" }
   * @param attributes attributes or {@code null} for none
   */
  public PushConfig setAttributes(java.util.Map<String, java.lang.String> attributes) {
    this.attributes = attributes;
    return this;
  }

  /**
   * If specified, Pub/Sub will generate and attach an OIDC JWT token as an `Authorization` header
   * in the HTTP request for every pushed message.
   * @return value or {@code null} for none
   */
  public OidcToken getOidcToken() {
    return oidcToken;
  }

  /**
   * If specified, Pub/Sub will generate and attach an OIDC JWT token as an `Authorization` header
   * in the HTTP request for every pushed message.
   * @param oidcToken oidcToken or {@code null} for none
   */
  public PushConfig setOidcToken(OidcToken oidcToken) {
    this.oidcToken = oidcToken;
    return this;
  }

  /**
   * A URL locating the endpoint to which messages should be pushed. For example, a Webhook endpoint
   * might use `https://example.com/push`.
   * @return value or {@code null} for none
   */
  public java.lang.String getPushEndpoint() {
    return pushEndpoint;
  }

  /**
   * A URL locating the endpoint to which messages should be pushed. For example, a Webhook endpoint
   * might use `https://example.com/push`.
   * @param pushEndpoint pushEndpoint or {@code null} for none
   */
  public PushConfig setPushEndpoint(java.lang.String pushEndpoint) {
    this.pushEndpoint = pushEndpoint;
    return this;
  }

  @Override
  public PushConfig set(String fieldName, Object value) {
    return (PushConfig) super.set(fieldName, value);
  }

  @Override
  public PushConfig clone() {
    return (PushConfig) super.clone();
  }

}
