/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * Response for the `ListTopicSnapshots` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListTopicSnapshotsResponse extends com.google.api.client.json.GenericJson {

  /**
   * If not empty, indicates that there may be more snapshots that match the request; this value
   * should be passed in a new `ListTopicSnapshotsRequest` to get more snapshots.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The names of the snapshots that match the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> snapshots;

  /**
   * If not empty, indicates that there may be more snapshots that match the request; this value
   * should be passed in a new `ListTopicSnapshotsRequest` to get more snapshots.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If not empty, indicates that there may be more snapshots that match the request; this value
   * should be passed in a new `ListTopicSnapshotsRequest` to get more snapshots.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListTopicSnapshotsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The names of the snapshots that match the request.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSnapshots() {
    return snapshots;
  }

  /**
   * The names of the snapshots that match the request.
   * @param snapshots snapshots or {@code null} for none
   */
  public ListTopicSnapshotsResponse setSnapshots(java.util.List<java.lang.String> snapshots) {
    this.snapshots = snapshots;
    return this;
  }

  @Override
  public ListTopicSnapshotsResponse set(String fieldName, Object value) {
    return (ListTopicSnapshotsResponse) super.set(fieldName, value);
  }

  @Override
  public ListTopicSnapshotsResponse clone() {
    return (ListTopicSnapshotsResponse) super.clone();
  }

}
