/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.pubsub.model;

/**
 * A policy that specifies the conditions for resource expiration (i.e., automatic resource
 * deletion).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Pub/Sub API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExpirationPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the "time-to-live" duration for an associated resource. The resource expires if it is
   * not active for a period of `ttl`. The definition of "activity" depends on the type of the
   * associated resource. The minimum and maximum allowed values for `ttl` depend on the type of the
   * associated resource, as well. If `ttl` is not set, the associated resource never expires.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String ttl;

  /**
   * Specifies the "time-to-live" duration for an associated resource. The resource expires if it is
   * not active for a period of `ttl`. The definition of "activity" depends on the type of the
   * associated resource. The minimum and maximum allowed values for `ttl` depend on the type of the
   * associated resource, as well. If `ttl` is not set, the associated resource never expires.
   * @return value or {@code null} for none
   */
  public String getTtl() {
    return ttl;
  }

  /**
   * Specifies the "time-to-live" duration for an associated resource. The resource expires if it is
   * not active for a period of `ttl`. The definition of "activity" depends on the type of the
   * associated resource. The minimum and maximum allowed values for `ttl` depend on the type of the
   * associated resource, as well. If `ttl` is not set, the associated resource never expires.
   * @param ttl ttl or {@code null} for none
   */
  public ExpirationPolicy setTtl(String ttl) {
    this.ttl = ttl;
    return this;
  }

  @Override
  public ExpirationPolicy set(String fieldName, Object value) {
    return (ExpirationPolicy) super.set(fieldName, value);
  }

  @Override
  public ExpirationPolicy clone() {
    return (ExpirationPolicy) super.clone();
  }

}
