/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;

/**
 * Model definition for Person.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Person extends GenericJson {

  /**
   * A short biography for this person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String aboutMe;

  /**
   * The age range of the person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AgeRange ageRange;

  /**
   * The person's date of birth, represented as YYYY-MM-DD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String birthday;

  /**
   * The "bragging rights" line of this person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String braggingRights;

  /**
   * If a Google+ Page and for followers who are visible, the number of people who have added this
   * page to a circle.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer circledByCount;

  /**
   * The cover photo content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Cover cover;

  /**
   * The current location for this person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String currentLocation;

  /**
   * The name of this person, suitable for display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String displayName;

  /**
   * A list of email addresses that this person has set to public on their Google+ profile. You can
   * also use the userinfo.email scope to retrieve an authenticated user's email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Emails> emails;

  static {
    // hack to force ProGuard to consider Emails used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Emails.class);
  }

  /**
   * ETag of this response for caching purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;

  /**
   * The person's gender. Possible values are: - "male" - Male gender.  - "female" - Female gender.
   * - "other" - Other.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String gender;

  /**
   * If "true", indicates that the person has installed the app that is making the request and has
   * chosen to expose this install state to the caller. A value of "false" indicates that the
   * install state cannot be determined (it is either not installed or the person has chosen to keep
   * this information private).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean hasApp;

  /**
   * The ID of this person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * The representation of the person's profile photo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image image;

  /**
   * Whether this user has signed up for Google+.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean isPlusUser;

  /**
   * Identifies this resource as a person. Value: "plus#person".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The user's preferred language for rendering.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String language;

  /**
   * An object representation of the individual components of a person's name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Name name;

  /**
   * The nickname of this person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nickname;

  /**
   * Type of person within Google+. Possible values are: - "person" - represents an actual person.
   * - "page" - represents a page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String objectType;

  /**
   * A list of current or past organizations with which this person is associated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Organizations> organizations;

  static {
    // hack to force ProGuard to consider Organizations used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Organizations.class);
  }

  /**
   * A list of places where this person has lived.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PlacesLived> placesLived;

  static {
    // hack to force ProGuard to consider PlacesLived used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(PlacesLived.class);
  }

  /**
   * If a Google+ Page, the number of people who have +1'ed this page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer plusOneCount;

  /**
   * The person's relationship status. Possible values are: - "single" - Person is single.  -
   * "in_a_relationship" - Person is in a relationship.  - "engaged" - Person is engaged.  -
   * "married" - Person is married.  - "its_complicated" - The relationship is complicated.  -
   * "open_relationship" - Person is in an open relationship.  - "widowed" - Person is widowed.  -
   * "in_domestic_partnership" - Person is in a domestic partnership.  - "in_civil_union" - Person
   * is in a civil union.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String relationshipStatus;

  /**
   * The brief description (tagline) of this person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String tagline;

  /**
   * The URL of this person's profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String url;

  /**
   * A list of URLs for this person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Urls> urls;

  static {
    // hack to force ProGuard to consider Urls used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Urls.class);
  }

  /**
   * Whether the person or Google+ Page has been verified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean verified;

  /**
   * A short biography for this person.
   * The value returned may be {@code null}.
   */
  public String getAboutMe() {
    return aboutMe;
  }

  /**
   * A short biography for this person.
   * The value set may be {@code null}.
   */
  public Person setAboutMe(String aboutMe) {
    this.aboutMe = aboutMe;
    return this;
  }

  /**
   * The age range of the person.
   * The value returned may be {@code null}.
   */
  public AgeRange getAgeRange() {
    return ageRange;
  }

  /**
   * The age range of the person.
   * The value set may be {@code null}.
   */
  public Person setAgeRange(AgeRange ageRange) {
    this.ageRange = ageRange;
    return this;
  }

  /**
   * The person's date of birth, represented as YYYY-MM-DD.
   * The value returned may be {@code null}.
   */
  public String getBirthday() {
    return birthday;
  }

  /**
   * The person's date of birth, represented as YYYY-MM-DD.
   * The value set may be {@code null}.
   */
  public Person setBirthday(String birthday) {
    this.birthday = birthday;
    return this;
  }

  /**
   * The "bragging rights" line of this person.
   * The value returned may be {@code null}.
   */
  public String getBraggingRights() {
    return braggingRights;
  }

  /**
   * The "bragging rights" line of this person.
   * The value set may be {@code null}.
   */
  public Person setBraggingRights(String braggingRights) {
    this.braggingRights = braggingRights;
    return this;
  }

  /**
   * If a Google+ Page and for followers who are visible, the number of people who have added this
   * page to a circle.
   * The value returned may be {@code null}.
   */
  public Integer getCircledByCount() {
    return circledByCount;
  }

  /**
   * If a Google+ Page and for followers who are visible, the number of people who have added this
   * page to a circle.
   * The value set may be {@code null}.
   */
  public Person setCircledByCount(Integer circledByCount) {
    this.circledByCount = circledByCount;
    return this;
  }

  /**
   * The cover photo content.
   * The value returned may be {@code null}.
   */
  public Cover getCover() {
    return cover;
  }

  /**
   * The cover photo content.
   * The value set may be {@code null}.
   */
  public Person setCover(Cover cover) {
    this.cover = cover;
    return this;
  }

  /**
   * The current location for this person.
   * The value returned may be {@code null}.
   */
  public String getCurrentLocation() {
    return currentLocation;
  }

  /**
   * The current location for this person.
   * The value set may be {@code null}.
   */
  public Person setCurrentLocation(String currentLocation) {
    this.currentLocation = currentLocation;
    return this;
  }

  /**
   * The name of this person, suitable for display.
   * The value returned may be {@code null}.
   */
  public String getDisplayName() {
    return displayName;
  }

  /**
   * The name of this person, suitable for display.
   * The value set may be {@code null}.
   */
  public Person setDisplayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * A list of email addresses that this person has set to public on their Google+ profile. You can
   * also use the userinfo.email scope to retrieve an authenticated user's email address.
   * The value returned may be {@code null}.
   */
  public java.util.List<Emails> getEmails() {
    return emails;
  }

  /**
   * A list of email addresses that this person has set to public on their Google+ profile. You can
   * also use the userinfo.email scope to retrieve an authenticated user's email address.
   * The value set may be {@code null}.
   */
  public Person setEmails(java.util.List<Emails> emails) {
    this.emails = emails;
    return this;
  }

  /**
   * ETag of this response for caching purposes.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * ETag of this response for caching purposes.
   * The value set may be {@code null}.
   */
  public Person setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The person's gender. Possible values are: - "male" - Male gender.  - "female" - Female gender.
   * - "other" - Other.
   * The value returned may be {@code null}.
   */
  public String getGender() {
    return gender;
  }

  /**
   * The person's gender. Possible values are: - "male" - Male gender.  - "female" - Female gender.
   * - "other" - Other.
   * The value set may be {@code null}.
   */
  public Person setGender(String gender) {
    this.gender = gender;
    return this;
  }

  /**
   * If "true", indicates that the person has installed the app that is making the request and has
   * chosen to expose this install state to the caller. A value of "false" indicates that the
   * install state cannot be determined (it is either not installed or the person has chosen to keep
   * this information private).
   * The value returned may be {@code null}.
   */
  public Boolean getHasApp() {
    return hasApp;
  }

  /**
   * If "true", indicates that the person has installed the app that is making the request and has
   * chosen to expose this install state to the caller. A value of "false" indicates that the
   * install state cannot be determined (it is either not installed or the person has chosen to keep
   * this information private).
   * The value set may be {@code null}.
   */
  public Person setHasApp(Boolean hasApp) {
    this.hasApp = hasApp;
    return this;
  }

  /**
   * The ID of this person.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of this person.
   * The value set may be {@code null}.
   */
  public Person setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The representation of the person's profile photo.
   * The value returned may be {@code null}.
   */
  public Image getImage() {
    return image;
  }

  /**
   * The representation of the person's profile photo.
   * The value set may be {@code null}.
   */
  public Person setImage(Image image) {
    this.image = image;
    return this;
  }

  /**
   * Whether this user has signed up for Google+.
   * The value returned may be {@code null}.
   */
  public Boolean getIsPlusUser() {
    return isPlusUser;
  }

  /**
   * Whether this user has signed up for Google+.
   * The value set may be {@code null}.
   */
  public Person setIsPlusUser(Boolean isPlusUser) {
    this.isPlusUser = isPlusUser;
    return this;
  }

  /**
   * Identifies this resource as a person. Value: "plus#person".
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as a person. Value: "plus#person".
   * The value set may be {@code null}.
   */
  public Person setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The user's preferred language for rendering.
   * The value returned may be {@code null}.
   */
  public String getLanguage() {
    return language;
  }

  /**
   * The user's preferred language for rendering.
   * The value set may be {@code null}.
   */
  public Person setLanguage(String language) {
    this.language = language;
    return this;
  }

  /**
   * An object representation of the individual components of a person's name.
   * The value returned may be {@code null}.
   */
  public Name getName() {
    return name;
  }

  /**
   * An object representation of the individual components of a person's name.
   * The value set may be {@code null}.
   */
  public Person setName(Name name) {
    this.name = name;
    return this;
  }

  /**
   * The nickname of this person.
   * The value returned may be {@code null}.
   */
  public String getNickname() {
    return nickname;
  }

  /**
   * The nickname of this person.
   * The value set may be {@code null}.
   */
  public Person setNickname(String nickname) {
    this.nickname = nickname;
    return this;
  }

  /**
   * Type of person within Google+. Possible values are: - "person" - represents an actual person.
   * - "page" - represents a page.
   * The value returned may be {@code null}.
   */
  public String getObjectType() {
    return objectType;
  }

  /**
   * Type of person within Google+. Possible values are: - "person" - represents an actual person.
   * - "page" - represents a page.
   * The value set may be {@code null}.
   */
  public Person setObjectType(String objectType) {
    this.objectType = objectType;
    return this;
  }

  /**
   * A list of current or past organizations with which this person is associated.
   * The value returned may be {@code null}.
   */
  public java.util.List<Organizations> getOrganizations() {
    return organizations;
  }

  /**
   * A list of current or past organizations with which this person is associated.
   * The value set may be {@code null}.
   */
  public Person setOrganizations(java.util.List<Organizations> organizations) {
    this.organizations = organizations;
    return this;
  }

  /**
   * A list of places where this person has lived.
   * The value returned may be {@code null}.
   */
  public java.util.List<PlacesLived> getPlacesLived() {
    return placesLived;
  }

  /**
   * A list of places where this person has lived.
   * The value set may be {@code null}.
   */
  public Person setPlacesLived(java.util.List<PlacesLived> placesLived) {
    this.placesLived = placesLived;
    return this;
  }

  /**
   * If a Google+ Page, the number of people who have +1'ed this page.
   * The value returned may be {@code null}.
   */
  public Integer getPlusOneCount() {
    return plusOneCount;
  }

  /**
   * If a Google+ Page, the number of people who have +1'ed this page.
   * The value set may be {@code null}.
   */
  public Person setPlusOneCount(Integer plusOneCount) {
    this.plusOneCount = plusOneCount;
    return this;
  }

  /**
   * The person's relationship status. Possible values are: - "single" - Person is single.  -
   * "in_a_relationship" - Person is in a relationship.  - "engaged" - Person is engaged.  -
   * "married" - Person is married.  - "its_complicated" - The relationship is complicated.  -
   * "open_relationship" - Person is in an open relationship.  - "widowed" - Person is widowed.  -
   * "in_domestic_partnership" - Person is in a domestic partnership.  - "in_civil_union" - Person
   * is in a civil union.
   * The value returned may be {@code null}.
   */
  public String getRelationshipStatus() {
    return relationshipStatus;
  }

  /**
   * The person's relationship status. Possible values are: - "single" - Person is single.  -
   * "in_a_relationship" - Person is in a relationship.  - "engaged" - Person is engaged.  -
   * "married" - Person is married.  - "its_complicated" - The relationship is complicated.  -
   * "open_relationship" - Person is in an open relationship.  - "widowed" - Person is widowed.  -
   * "in_domestic_partnership" - Person is in a domestic partnership.  - "in_civil_union" - Person
   * is in a civil union.
   * The value set may be {@code null}.
   */
  public Person setRelationshipStatus(String relationshipStatus) {
    this.relationshipStatus = relationshipStatus;
    return this;
  }

  /**
   * The brief description (tagline) of this person.
   * The value returned may be {@code null}.
   */
  public String getTagline() {
    return tagline;
  }

  /**
   * The brief description (tagline) of this person.
   * The value set may be {@code null}.
   */
  public Person setTagline(String tagline) {
    this.tagline = tagline;
    return this;
  }

  /**
   * The URL of this person's profile.
   * The value returned may be {@code null}.
   */
  public String getUrl() {
    return url;
  }

  /**
   * The URL of this person's profile.
   * The value set may be {@code null}.
   */
  public Person setUrl(String url) {
    this.url = url;
    return this;
  }

  /**
   * A list of URLs for this person.
   * The value returned may be {@code null}.
   */
  public java.util.List<Urls> getUrls() {
    return urls;
  }

  /**
   * A list of URLs for this person.
   * The value set may be {@code null}.
   */
  public Person setUrls(java.util.List<Urls> urls) {
    this.urls = urls;
    return this;
  }

  /**
   * Whether the person or Google+ Page has been verified.
   * The value returned may be {@code null}.
   */
  public Boolean getVerified() {
    return verified;
  }

  /**
   * Whether the person or Google+ Page has been verified.
   * The value set may be {@code null}.
   */
  public Person setVerified(Boolean verified) {
    this.verified = verified;
    return this;
  }

  /**
   * The age range of the person.
   */
  public static final class AgeRange extends GenericJson {

    /**
     * The age range's upper bound, if any.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Integer max;

    /**
     * The age range's lower bound, if any.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Integer min;

    /**
     * The age range's upper bound, if any.
     * The value returned may be {@code null}.
     */
    public Integer getMax() {
      return max;
    }

    /**
     * The age range's upper bound, if any.
     * The value set may be {@code null}.
     */
    public AgeRange setMax(Integer max) {
      this.max = max;
      return this;
    }

    /**
     * The age range's lower bound, if any.
     * The value returned may be {@code null}.
     */
    public Integer getMin() {
      return min;
    }

    /**
     * The age range's lower bound, if any.
     * The value set may be {@code null}.
     */
    public AgeRange setMin(Integer min) {
      this.min = min;
      return this;
    }

  }

  /**
   * The cover photo content.
   */
  public static final class Cover extends GenericJson {

    /**
     * Extra information about the cover photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private CoverInfo coverInfo;

    /**
     * The person's primary cover image.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private CoverPhoto coverPhoto;

    /**
     * The layout of the cover art. Possible values are: - "banner" - One large image banner.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String layout;

    /**
     * Extra information about the cover photo.
     * The value returned may be {@code null}.
     */
    public CoverInfo getCoverInfo() {
      return coverInfo;
    }

    /**
     * Extra information about the cover photo.
     * The value set may be {@code null}.
     */
    public Cover setCoverInfo(CoverInfo coverInfo) {
      this.coverInfo = coverInfo;
      return this;
    }

    /**
     * The person's primary cover image.
     * The value returned may be {@code null}.
     */
    public CoverPhoto getCoverPhoto() {
      return coverPhoto;
    }

    /**
     * The person's primary cover image.
     * The value set may be {@code null}.
     */
    public Cover setCoverPhoto(CoverPhoto coverPhoto) {
      this.coverPhoto = coverPhoto;
      return this;
    }

    /**
     * The layout of the cover art. Possible values are: - "banner" - One large image banner.
     * The value returned may be {@code null}.
     */
    public String getLayout() {
      return layout;
    }

    /**
     * The layout of the cover art. Possible values are: - "banner" - One large image banner.
     * The value set may be {@code null}.
     */
    public Cover setLayout(String layout) {
      this.layout = layout;
      return this;
    }

    /**
     * Extra information about the cover photo.
     */
    public static final class CoverInfo extends GenericJson {

      /**
       * The difference between the left position of the image cover and the actual displayed cover
       * image. Only valid for BANNER layout.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Integer leftImageOffset;

      /**
       * The difference between the top position of the image cover and the actual displayed cover
       * image. Only valid for BANNER layout.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Integer topImageOffset;

      /**
       * The difference between the left position of the image cover and the actual displayed cover
       * image. Only valid for BANNER layout.
       * The value returned may be {@code null}.
       */
      public Integer getLeftImageOffset() {
        return leftImageOffset;
      }

      /**
       * The difference between the left position of the image cover and the actual displayed cover
       * image. Only valid for BANNER layout.
       * The value set may be {@code null}.
       */
      public CoverInfo setLeftImageOffset(Integer leftImageOffset) {
        this.leftImageOffset = leftImageOffset;
        return this;
      }

      /**
       * The difference between the top position of the image cover and the actual displayed cover
       * image. Only valid for BANNER layout.
       * The value returned may be {@code null}.
       */
      public Integer getTopImageOffset() {
        return topImageOffset;
      }

      /**
       * The difference between the top position of the image cover and the actual displayed cover
       * image. Only valid for BANNER layout.
       * The value set may be {@code null}.
       */
      public CoverInfo setTopImageOffset(Integer topImageOffset) {
        this.topImageOffset = topImageOffset;
        return this;
      }

    }
    /**
     * The person's primary cover image.
     */
    public static final class CoverPhoto extends GenericJson {

      /**
       * The height to the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Integer height;

      /**
       * The url to the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String url;

      /**
       * The width to the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Integer width;

      /**
       * The height to the image.
       * The value returned may be {@code null}.
       */
      public Integer getHeight() {
        return height;
      }

      /**
       * The height to the image.
       * The value set may be {@code null}.
       */
      public CoverPhoto setHeight(Integer height) {
        this.height = height;
        return this;
      }

      /**
       * The url to the image.
       * The value returned may be {@code null}.
       */
      public String getUrl() {
        return url;
      }

      /**
       * The url to the image.
       * The value set may be {@code null}.
       */
      public CoverPhoto setUrl(String url) {
        this.url = url;
        return this;
      }

      /**
       * The width to the image.
       * The value returned may be {@code null}.
       */
      public Integer getWidth() {
        return width;
      }

      /**
       * The width to the image.
       * The value set may be {@code null}.
       */
      public CoverPhoto setWidth(Integer width) {
        this.width = width;
        return this;
      }

    }
  }

  /**
   * Model definition for PersonEmails.
   */
  public static final class Emails extends GenericJson {

    /**
     * If "true", indicates this email address is the person's primary one.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean primary;

    /**
     * The type of address. Possible values are: - "home" - Home email address.  - "work" - Work email
     * address.  - "other" - Other.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * The email address.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String value;

    /**
     * If "true", indicates this email address is the person's primary one.
     * The value returned may be {@code null}.
     */
    public Boolean getPrimary() {
      return primary;
    }

    /**
     * If "true", indicates this email address is the person's primary one.
     * The value set may be {@code null}.
     */
    public Emails setPrimary(Boolean primary) {
      this.primary = primary;
      return this;
    }

    /**
     * The type of address. Possible values are: - "home" - Home email address.  - "work" - Work email
     * address.  - "other" - Other.
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * The type of address. Possible values are: - "home" - Home email address.  - "work" - Work email
     * address.  - "other" - Other.
     * The value set may be {@code null}.
     */
    public Emails setType(String type) {
      this.type = type;
      return this;
    }

    /**
     * The email address.
     * The value returned may be {@code null}.
     */
    public String getValue() {
      return value;
    }

    /**
     * The email address.
     * The value set may be {@code null}.
     */
    public Emails setValue(String value) {
      this.value = value;
      return this;
    }

  }

  /**
   * The representation of the person's profile photo.
   */
  public static final class Image extends GenericJson {

    /**
     * The URL of the person's profile photo. To re-size the image and crop it to a square, append the
     * query string ?sz=x, where x is the dimension in pixels of each side.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String url;

    /**
     * The URL of the person's profile photo. To re-size the image and crop it to a square, append the
     * query string ?sz=x, where x is the dimension in pixels of each side.
     * The value returned may be {@code null}.
     */
    public String getUrl() {
      return url;
    }

    /**
     * The URL of the person's profile photo. To re-size the image and crop it to a square, append the
     * query string ?sz=x, where x is the dimension in pixels of each side.
     * The value set may be {@code null}.
     */
    public Image setUrl(String url) {
      this.url = url;
      return this;
    }

  }

  /**
   * An object representation of the individual components of a person's name.
   */
  public static final class Name extends GenericJson {

    /**
     * The family name (last name) of this person.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String familyName;

    /**
     * The full name of this person, including middle names, suffixes, etc.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String formatted;

    /**
     * The given name (first name) of this person.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String givenName;

    /**
     * The honorific prefixes (such as "Dr." or "Mrs.") for this person.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String honorificPrefix;

    /**
     * The honorific suffixes (such as "Jr.") for this person.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String honorificSuffix;

    /**
     * The middle name of this person.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String middleName;

    /**
     * The family name (last name) of this person.
     * The value returned may be {@code null}.
     */
    public String getFamilyName() {
      return familyName;
    }

    /**
     * The family name (last name) of this person.
     * The value set may be {@code null}.
     */
    public Name setFamilyName(String familyName) {
      this.familyName = familyName;
      return this;
    }

    /**
     * The full name of this person, including middle names, suffixes, etc.
     * The value returned may be {@code null}.
     */
    public String getFormatted() {
      return formatted;
    }

    /**
     * The full name of this person, including middle names, suffixes, etc.
     * The value set may be {@code null}.
     */
    public Name setFormatted(String formatted) {
      this.formatted = formatted;
      return this;
    }

    /**
     * The given name (first name) of this person.
     * The value returned may be {@code null}.
     */
    public String getGivenName() {
      return givenName;
    }

    /**
     * The given name (first name) of this person.
     * The value set may be {@code null}.
     */
    public Name setGivenName(String givenName) {
      this.givenName = givenName;
      return this;
    }

    /**
     * The honorific prefixes (such as "Dr." or "Mrs.") for this person.
     * The value returned may be {@code null}.
     */
    public String getHonorificPrefix() {
      return honorificPrefix;
    }

    /**
     * The honorific prefixes (such as "Dr." or "Mrs.") for this person.
     * The value set may be {@code null}.
     */
    public Name setHonorificPrefix(String honorificPrefix) {
      this.honorificPrefix = honorificPrefix;
      return this;
    }

    /**
     * The honorific suffixes (such as "Jr.") for this person.
     * The value returned may be {@code null}.
     */
    public String getHonorificSuffix() {
      return honorificSuffix;
    }

    /**
     * The honorific suffixes (such as "Jr.") for this person.
     * The value set may be {@code null}.
     */
    public Name setHonorificSuffix(String honorificSuffix) {
      this.honorificSuffix = honorificSuffix;
      return this;
    }

    /**
     * The middle name of this person.
     * The value returned may be {@code null}.
     */
    public String getMiddleName() {
      return middleName;
    }

    /**
     * The middle name of this person.
     * The value set may be {@code null}.
     */
    public Name setMiddleName(String middleName) {
      this.middleName = middleName;
      return this;
    }

  }

  /**
   * Model definition for PersonOrganizations.
   */
  public static final class Organizations extends GenericJson {

    /**
     * The department within the organization. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String department;

    /**
     * A short description of the person's role in this organization. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String description;

    /**
     * The date the person left this organization.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String endDate;

    /**
     * The location of this organization. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String location;

    /**
     * The name of the organization.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String name;

    /**
     * If "true", indicates this organization is the person's primary one (typically interpreted as
     * current one).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean primary;

    /**
     * The date the person joined this organization.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String startDate;

    /**
     * The person's job title or role within the organization.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String title;

    /**
     * The type of organization. Possible values are: - "work" - Work.  - "school" - School.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * The department within the organization. Deprecated.
     * The value returned may be {@code null}.
     */
    public String getDepartment() {
      return department;
    }

    /**
     * The department within the organization. Deprecated.
     * The value set may be {@code null}.
     */
    public Organizations setDepartment(String department) {
      this.department = department;
      return this;
    }

    /**
     * A short description of the person's role in this organization. Deprecated.
     * The value returned may be {@code null}.
     */
    public String getDescription() {
      return description;
    }

    /**
     * A short description of the person's role in this organization. Deprecated.
     * The value set may be {@code null}.
     */
    public Organizations setDescription(String description) {
      this.description = description;
      return this;
    }

    /**
     * The date the person left this organization.
     * The value returned may be {@code null}.
     */
    public String getEndDate() {
      return endDate;
    }

    /**
     * The date the person left this organization.
     * The value set may be {@code null}.
     */
    public Organizations setEndDate(String endDate) {
      this.endDate = endDate;
      return this;
    }

    /**
     * The location of this organization. Deprecated.
     * The value returned may be {@code null}.
     */
    public String getLocation() {
      return location;
    }

    /**
     * The location of this organization. Deprecated.
     * The value set may be {@code null}.
     */
    public Organizations setLocation(String location) {
      this.location = location;
      return this;
    }

    /**
     * The name of the organization.
     * The value returned may be {@code null}.
     */
    public String getName() {
      return name;
    }

    /**
     * The name of the organization.
     * The value set may be {@code null}.
     */
    public Organizations setName(String name) {
      this.name = name;
      return this;
    }

    /**
     * If "true", indicates this organization is the person's primary one (typically interpreted as
     * current one).
     * The value returned may be {@code null}.
     */
    public Boolean getPrimary() {
      return primary;
    }

    /**
     * If "true", indicates this organization is the person's primary one (typically interpreted as
     * current one).
     * The value set may be {@code null}.
     */
    public Organizations setPrimary(Boolean primary) {
      this.primary = primary;
      return this;
    }

    /**
     * The date the person joined this organization.
     * The value returned may be {@code null}.
     */
    public String getStartDate() {
      return startDate;
    }

    /**
     * The date the person joined this organization.
     * The value set may be {@code null}.
     */
    public Organizations setStartDate(String startDate) {
      this.startDate = startDate;
      return this;
    }

    /**
     * The person's job title or role within the organization.
     * The value returned may be {@code null}.
     */
    public String getTitle() {
      return title;
    }

    /**
     * The person's job title or role within the organization.
     * The value set may be {@code null}.
     */
    public Organizations setTitle(String title) {
      this.title = title;
      return this;
    }

    /**
     * The type of organization. Possible values are: - "work" - Work.  - "school" - School.
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * The type of organization. Possible values are: - "work" - Work.  - "school" - School.
     * The value set may be {@code null}.
     */
    public Organizations setType(String type) {
      this.type = type;
      return this;
    }

  }

  /**
   * Model definition for PersonPlacesLived.
   */
  public static final class PlacesLived extends GenericJson {

    /**
     * If "true", this place of residence is this person's primary residence.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean primary;

    /**
     * A place where this person has lived. For example: "Seattle, WA", "Near Toronto".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String value;

    /**
     * If "true", this place of residence is this person's primary residence.
     * The value returned may be {@code null}.
     */
    public Boolean getPrimary() {
      return primary;
    }

    /**
     * If "true", this place of residence is this person's primary residence.
     * The value set may be {@code null}.
     */
    public PlacesLived setPrimary(Boolean primary) {
      this.primary = primary;
      return this;
    }

    /**
     * A place where this person has lived. For example: "Seattle, WA", "Near Toronto".
     * The value returned may be {@code null}.
     */
    public String getValue() {
      return value;
    }

    /**
     * A place where this person has lived. For example: "Seattle, WA", "Near Toronto".
     * The value set may be {@code null}.
     */
    public PlacesLived setValue(String value) {
      this.value = value;
      return this;
    }

  }

  /**
   * Model definition for PersonUrls.
   */
  public static final class Urls extends GenericJson {

    /**
     * If "true", this URL is the person's primary URL.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean primary;

    /**
     * The type of URL. Possible values are: - "home" - URL for home.  - "work" - URL for work.  -
     * "blog" - URL for blog.  - "profile" - URL for profile.  - "other" - Other.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * The URL value.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String value;

    /**
     * If "true", this URL is the person's primary URL.
     * The value returned may be {@code null}.
     */
    public Boolean getPrimary() {
      return primary;
    }

    /**
     * If "true", this URL is the person's primary URL.
     * The value set may be {@code null}.
     */
    public Urls setPrimary(Boolean primary) {
      this.primary = primary;
      return this;
    }

    /**
     * The type of URL. Possible values are: - "home" - URL for home.  - "work" - URL for work.  -
     * "blog" - URL for blog.  - "profile" - URL for profile.  - "other" - Other.
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * The type of URL. Possible values are: - "home" - URL for home.  - "work" - URL for work.  -
     * "blog" - URL for blog.  - "profile" - URL for profile.  - "other" - Other.
     * The value set may be {@code null}.
     */
    public Urls setType(String type) {
      this.type = type;
      return this;
    }

    /**
     * The URL value.
     * The value returned may be {@code null}.
     */
    public String getValue() {
      return value;
    }

    /**
     * The URL value.
     * The value set may be {@code null}.
     */
    public Urls setValue(String value) {
      this.value = value;
      return this;
    }

  }

}
