/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * Model definition for Moment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Moment extends GenericJson {

  /**
   * The moment ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Identifies this resource as a moment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The object generated by performing the action on the target. For example, a user writes a
   * review of a restaurant, the target is the restaurant and the result is the review.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope result;

  /**
   * Time stamp of when the action occurred in RFC3339 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime startDate;

  /**
   * The object on which the action was performed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ItemScope target;

  /**
   * The Google schema for the type of moment to write. For example,
   * http://schemas.google.com/AddActivity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * The moment ID.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The moment ID.
   * The value set may be {@code null}.
   */
  public Moment setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies this resource as a moment.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as a moment.
   * The value set may be {@code null}.
   */
  public Moment setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The object generated by performing the action on the target. For example, a user writes a
   * review of a restaurant, the target is the restaurant and the result is the review.
   * The value returned may be {@code null}.
   */
  public ItemScope getResult() {
    return result;
  }

  /**
   * The object generated by performing the action on the target. For example, a user writes a
   * review of a restaurant, the target is the restaurant and the result is the review.
   * The value set may be {@code null}.
   */
  public Moment setResult(ItemScope result) {
    this.result = result;
    return this;
  }

  /**
   * Time stamp of when the action occurred in RFC3339 format.
   * The value returned may be {@code null}.
   */
  public DateTime getStartDate() {
    return startDate;
  }

  /**
   * Time stamp of when the action occurred in RFC3339 format.
   * The value set may be {@code null}.
   */
  public Moment setStartDate(DateTime startDate) {
    this.startDate = startDate;
    return this;
  }

  /**
   * The object on which the action was performed.
   * The value returned may be {@code null}.
   */
  public ItemScope getTarget() {
    return target;
  }

  /**
   * The object on which the action was performed.
   * The value set may be {@code null}.
   */
  public Moment setTarget(ItemScope target) {
    this.target = target;
    return this;
  }

  /**
   * The Google schema for the type of moment to write. For example,
   * http://schemas.google.com/AddActivity.
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * The Google schema for the type of moment to write. For example,
   * http://schemas.google.com/AddActivity.
   * The value set may be {@code null}.
   */
  public Moment setType(String type) {
    this.type = type;
    return this;
  }

}
