/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * Model definition for Comment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Comment extends GenericJson {

  /**
   * The person who posted this comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Actor actor;

  /**
   * ETag of this response for caching purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;

  /**
   * The ID of this comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * The activity this comment replied to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InReplyTo> inReplyTo;

  static {
    // hack to force ProGuard to consider InReplyTo used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(InReplyTo.class);
  }

  /**
   * Identifies this resource as a comment. Value: "plus#comment".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The object of this comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("object")
  private PlusObject plusObject;

  /**
   * People who +1'd this comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Plusoners plusoners;

  /**
   * The time at which this comment was initially published. Formatted as an RFC 3339 timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime published;

  /**
   * Link to this comment resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The time at which this comment was last updated. Formatted as an RFC 3339 timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * This comment's verb, indicating what action was performed. Possible values are: - "post" -
   * Publish content to the stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String verb;

  /**
   * The person who posted this comment.
   * The value returned may be {@code null}.
   */
  public Actor getActor() {
    return actor;
  }

  /**
   * The person who posted this comment.
   * The value set may be {@code null}.
   */
  public Comment setActor(Actor actor) {
    this.actor = actor;
    return this;
  }

  /**
   * ETag of this response for caching purposes.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * ETag of this response for caching purposes.
   * The value set may be {@code null}.
   */
  public Comment setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID of this comment.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of this comment.
   * The value set may be {@code null}.
   */
  public Comment setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The activity this comment replied to.
   * The value returned may be {@code null}.
   */
  public java.util.List<InReplyTo> getInReplyTo() {
    return inReplyTo;
  }

  /**
   * The activity this comment replied to.
   * The value set may be {@code null}.
   */
  public Comment setInReplyTo(java.util.List<InReplyTo> inReplyTo) {
    this.inReplyTo = inReplyTo;
    return this;
  }

  /**
   * Identifies this resource as a comment. Value: "plus#comment".
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as a comment. Value: "plus#comment".
   * The value set may be {@code null}.
   */
  public Comment setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The object of this comment.
   * The value returned may be {@code null}.
   */
  public PlusObject getObject() {
    return plusObject;
  }

  /**
   * The object of this comment.
   * The value set may be {@code null}.
   */
  public Comment setObject(PlusObject plusObject) {
    this.plusObject = plusObject;
    return this;
  }

  /**
   * People who +1'd this comment.
   * The value returned may be {@code null}.
   */
  public Plusoners getPlusoners() {
    return plusoners;
  }

  /**
   * People who +1'd this comment.
   * The value set may be {@code null}.
   */
  public Comment setPlusoners(Plusoners plusoners) {
    this.plusoners = plusoners;
    return this;
  }

  /**
   * The time at which this comment was initially published. Formatted as an RFC 3339 timestamp.
   * The value returned may be {@code null}.
   */
  public DateTime getPublished() {
    return published;
  }

  /**
   * The time at which this comment was initially published. Formatted as an RFC 3339 timestamp.
   * The value set may be {@code null}.
   */
  public Comment setPublished(DateTime published) {
    this.published = published;
    return this;
  }

  /**
   * Link to this comment resource.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link to this comment resource.
   * The value set may be {@code null}.
   */
  public Comment setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The time at which this comment was last updated. Formatted as an RFC 3339 timestamp.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * The time at which this comment was last updated. Formatted as an RFC 3339 timestamp.
   * The value set may be {@code null}.
   */
  public Comment setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * This comment's verb, indicating what action was performed. Possible values are: - "post" -
   * Publish content to the stream.
   * The value returned may be {@code null}.
   */
  public String getVerb() {
    return verb;
  }

  /**
   * This comment's verb, indicating what action was performed. Possible values are: - "post" -
   * Publish content to the stream.
   * The value set may be {@code null}.
   */
  public Comment setVerb(String verb) {
    this.verb = verb;
    return this;
  }

  /**
   * The person who posted this comment.
   */
  public static final class Actor extends GenericJson {

    /**
     * The name of this actor, suitable for display.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String displayName;

    /**
     * The ID of the actor.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String id;

    /**
     * The image representation of this actor.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Image image;

    /**
     * A link to the person resource for this actor.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String url;

    /**
     * The name of this actor, suitable for display.
     * The value returned may be {@code null}.
     */
    public String getDisplayName() {
      return displayName;
    }

    /**
     * The name of this actor, suitable for display.
     * The value set may be {@code null}.
     */
    public Actor setDisplayName(String displayName) {
      this.displayName = displayName;
      return this;
    }

    /**
     * The ID of the actor.
     * The value returned may be {@code null}.
     */
    public String getId() {
      return id;
    }

    /**
     * The ID of the actor.
     * The value set may be {@code null}.
     */
    public Actor setId(String id) {
      this.id = id;
      return this;
    }

    /**
     * The image representation of this actor.
     * The value returned may be {@code null}.
     */
    public Image getImage() {
      return image;
    }

    /**
     * The image representation of this actor.
     * The value set may be {@code null}.
     */
    public Actor setImage(Image image) {
      this.image = image;
      return this;
    }

    /**
     * A link to the person resource for this actor.
     * The value returned may be {@code null}.
     */
    public String getUrl() {
      return url;
    }

    /**
     * A link to the person resource for this actor.
     * The value set may be {@code null}.
     */
    public Actor setUrl(String url) {
      this.url = url;
      return this;
    }

    /**
     * The image representation of this actor.
     */
    public static final class Image extends GenericJson {

      /**
       * The URL of the actor's profile photo. To re-size the image and crop it to a square, append the
       * query string ?sz=x, where x is the dimension in pixels of each side.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String url;

      /**
       * The URL of the actor's profile photo. To re-size the image and crop it to a square, append the
       * query string ?sz=x, where x is the dimension in pixels of each side.
       * The value returned may be {@code null}.
       */
      public String getUrl() {
        return url;
      }

      /**
       * The URL of the actor's profile photo. To re-size the image and crop it to a square, append the
       * query string ?sz=x, where x is the dimension in pixels of each side.
       * The value set may be {@code null}.
       */
      public Image setUrl(String url) {
        this.url = url;
        return this;
      }

    }
  }

  /**
   * Model definition for CommentInReplyTo.
   */
  public static final class InReplyTo extends GenericJson {

    /**
     * The ID of the activity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String id;

    /**
     * The URL of the activity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String url;

    /**
     * The ID of the activity.
     * The value returned may be {@code null}.
     */
    public String getId() {
      return id;
    }

    /**
     * The ID of the activity.
     * The value set may be {@code null}.
     */
    public InReplyTo setId(String id) {
      this.id = id;
      return this;
    }

    /**
     * The URL of the activity.
     * The value returned may be {@code null}.
     */
    public String getUrl() {
      return url;
    }

    /**
     * The URL of the activity.
     * The value set may be {@code null}.
     */
    public InReplyTo setUrl(String url) {
      this.url = url;
      return this;
    }

  }

  /**
   * The object of this comment.
   */
  public static final class PlusObject extends GenericJson {

    /**
     * The HTML-formatted content, suitable for display.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String content;

    /**
     * The object type of this comment. Possible values are: - "comment" - A comment in reply to an
     * activity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String objectType;

    /**
     * The content (text) as provided by the author, stored without any HTML formatting. When creating
     * or updating a comment, this value must be supplied as plain text in the request.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String originalContent;

    /**
     * The HTML-formatted content, suitable for display.
     * The value returned may be {@code null}.
     */
    public String getContent() {
      return content;
    }

    /**
     * The HTML-formatted content, suitable for display.
     * The value set may be {@code null}.
     */
    public PlusObject setContent(String content) {
      this.content = content;
      return this;
    }

    /**
     * The object type of this comment. Possible values are: - "comment" - A comment in reply to an
     * activity.
     * The value returned may be {@code null}.
     */
    public String getObjectType() {
      return objectType;
    }

    /**
     * The object type of this comment. Possible values are: - "comment" - A comment in reply to an
     * activity.
     * The value set may be {@code null}.
     */
    public PlusObject setObjectType(String objectType) {
      this.objectType = objectType;
      return this;
    }

    /**
     * The content (text) as provided by the author, stored without any HTML formatting. When creating
     * or updating a comment, this value must be supplied as plain text in the request.
     * The value returned may be {@code null}.
     */
    public String getOriginalContent() {
      return originalContent;
    }

    /**
     * The content (text) as provided by the author, stored without any HTML formatting. When creating
     * or updating a comment, this value must be supplied as plain text in the request.
     * The value set may be {@code null}.
     */
    public PlusObject setOriginalContent(String originalContent) {
      this.originalContent = originalContent;
      return this;
    }

  }

  /**
   * People who +1'd this comment.
   */
  public static final class Plusoners extends GenericJson {

    /**
     * Total number of people who +1'd this comment.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Long totalItems;

    /**
     * Total number of people who +1'd this comment.
     * The value returned may be {@code null}.
     */
    public Long getTotalItems() {
      return totalItems;
    }

    /**
     * Total number of people who +1'd this comment.
     * The value set may be {@code null}.
     */
    public Plusoners setTotalItems(Long totalItems) {
      this.totalItems = totalItems;
      return this;
    }

  }

}
