/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * Model definition for Activity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Activity extends GenericJson {

  /**
   * Identifies who has access to see this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Acl access;

  /**
   * The person who performed this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Actor actor;

  /**
   * Street address where this activity occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String address;

  /**
   * Additional content added by the person who shared this activity, applicable only when resharing
   * an activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String annotation;

  /**
   * If this activity is a crosspost from another system, this property specifies the ID of the
   * original activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String crosspostSource;

  /**
   * ETag of this response for caching purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;

  /**
   * Latitude and longitude where this activity occurred. Format is latitude followed by longitude,
   * space separated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String geocode;

  /**
   * The ID of this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Identifies this resource as an activity. Value: "plus#activity".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The location where this activity occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Place location;

  /**
   * The object of this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("object")
  private PlusObject plusObject;

  /**
   * ID of the place where this activity occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String placeId;

  /**
   * Name of the place where this activity occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String placeName;

  /**
   * The service provider that initially published this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Provider provider;

  /**
   * The time at which this activity was initially published. Formatted as an RFC 3339 timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime published;

  /**
   * Radius, in meters, of the region where this activity occurred, centered at the latitude and
   * longitude identified in geocode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String radius;

  /**
   * Title of this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String title;

  /**
   * The time at which this activity was last updated. Formatted as an RFC 3339 timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * The link to this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String url;

  /**
   * This activity's verb, indicating what action was performed. Possible values are: - "post" -
   * Publish content to the stream.  - "share" - Reshare an activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String verb;

  /**
   * Identifies who has access to see this activity.
   * The value returned may be {@code null}.
   */
  public Acl getAccess() {
    return access;
  }

  /**
   * Identifies who has access to see this activity.
   * The value set may be {@code null}.
   */
  public Activity setAccess(Acl access) {
    this.access = access;
    return this;
  }

  /**
   * The person who performed this activity.
   * The value returned may be {@code null}.
   */
  public Actor getActor() {
    return actor;
  }

  /**
   * The person who performed this activity.
   * The value set may be {@code null}.
   */
  public Activity setActor(Actor actor) {
    this.actor = actor;
    return this;
  }

  /**
   * Street address where this activity occurred.
   * The value returned may be {@code null}.
   */
  public String getAddress() {
    return address;
  }

  /**
   * Street address where this activity occurred.
   * The value set may be {@code null}.
   */
  public Activity setAddress(String address) {
    this.address = address;
    return this;
  }

  /**
   * Additional content added by the person who shared this activity, applicable only when resharing
   * an activity.
   * The value returned may be {@code null}.
   */
  public String getAnnotation() {
    return annotation;
  }

  /**
   * Additional content added by the person who shared this activity, applicable only when resharing
   * an activity.
   * The value set may be {@code null}.
   */
  public Activity setAnnotation(String annotation) {
    this.annotation = annotation;
    return this;
  }

  /**
   * If this activity is a crosspost from another system, this property specifies the ID of the
   * original activity.
   * The value returned may be {@code null}.
   */
  public String getCrosspostSource() {
    return crosspostSource;
  }

  /**
   * If this activity is a crosspost from another system, this property specifies the ID of the
   * original activity.
   * The value set may be {@code null}.
   */
  public Activity setCrosspostSource(String crosspostSource) {
    this.crosspostSource = crosspostSource;
    return this;
  }

  /**
   * ETag of this response for caching purposes.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * ETag of this response for caching purposes.
   * The value set may be {@code null}.
   */
  public Activity setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Latitude and longitude where this activity occurred. Format is latitude followed by longitude,
   * space separated.
   * The value returned may be {@code null}.
   */
  public String getGeocode() {
    return geocode;
  }

  /**
   * Latitude and longitude where this activity occurred. Format is latitude followed by longitude,
   * space separated.
   * The value set may be {@code null}.
   */
  public Activity setGeocode(String geocode) {
    this.geocode = geocode;
    return this;
  }

  /**
   * The ID of this activity.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of this activity.
   * The value set may be {@code null}.
   */
  public Activity setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies this resource as an activity. Value: "plus#activity".
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as an activity. Value: "plus#activity".
   * The value set may be {@code null}.
   */
  public Activity setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The location where this activity occurred.
   * The value returned may be {@code null}.
   */
  public Place getLocation() {
    return location;
  }

  /**
   * The location where this activity occurred.
   * The value set may be {@code null}.
   */
  public Activity setLocation(Place location) {
    this.location = location;
    return this;
  }

  /**
   * The object of this activity.
   * The value returned may be {@code null}.
   */
  public PlusObject getObject() {
    return plusObject;
  }

  /**
   * The object of this activity.
   * The value set may be {@code null}.
   */
  public Activity setObject(PlusObject plusObject) {
    this.plusObject = plusObject;
    return this;
  }

  /**
   * ID of the place where this activity occurred.
   * The value returned may be {@code null}.
   */
  public String getPlaceId() {
    return placeId;
  }

  /**
   * ID of the place where this activity occurred.
   * The value set may be {@code null}.
   */
  public Activity setPlaceId(String placeId) {
    this.placeId = placeId;
    return this;
  }

  /**
   * Name of the place where this activity occurred.
   * The value returned may be {@code null}.
   */
  public String getPlaceName() {
    return placeName;
  }

  /**
   * Name of the place where this activity occurred.
   * The value set may be {@code null}.
   */
  public Activity setPlaceName(String placeName) {
    this.placeName = placeName;
    return this;
  }

  /**
   * The service provider that initially published this activity.
   * The value returned may be {@code null}.
   */
  public Provider getProvider() {
    return provider;
  }

  /**
   * The service provider that initially published this activity.
   * The value set may be {@code null}.
   */
  public Activity setProvider(Provider provider) {
    this.provider = provider;
    return this;
  }

  /**
   * The time at which this activity was initially published. Formatted as an RFC 3339 timestamp.
   * The value returned may be {@code null}.
   */
  public DateTime getPublished() {
    return published;
  }

  /**
   * The time at which this activity was initially published. Formatted as an RFC 3339 timestamp.
   * The value set may be {@code null}.
   */
  public Activity setPublished(DateTime published) {
    this.published = published;
    return this;
  }

  /**
   * Radius, in meters, of the region where this activity occurred, centered at the latitude and
   * longitude identified in geocode.
   * The value returned may be {@code null}.
   */
  public String getRadius() {
    return radius;
  }

  /**
   * Radius, in meters, of the region where this activity occurred, centered at the latitude and
   * longitude identified in geocode.
   * The value set may be {@code null}.
   */
  public Activity setRadius(String radius) {
    this.radius = radius;
    return this;
  }

  /**
   * Title of this activity.
   * The value returned may be {@code null}.
   */
  public String getTitle() {
    return title;
  }

  /**
   * Title of this activity.
   * The value set may be {@code null}.
   */
  public Activity setTitle(String title) {
    this.title = title;
    return this;
  }

  /**
   * The time at which this activity was last updated. Formatted as an RFC 3339 timestamp.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * The time at which this activity was last updated. Formatted as an RFC 3339 timestamp.
   * The value set may be {@code null}.
   */
  public Activity setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * The link to this activity.
   * The value returned may be {@code null}.
   */
  public String getUrl() {
    return url;
  }

  /**
   * The link to this activity.
   * The value set may be {@code null}.
   */
  public Activity setUrl(String url) {
    this.url = url;
    return this;
  }

  /**
   * This activity's verb, indicating what action was performed. Possible values are: - "post" -
   * Publish content to the stream.  - "share" - Reshare an activity.
   * The value returned may be {@code null}.
   */
  public String getVerb() {
    return verb;
  }

  /**
   * This activity's verb, indicating what action was performed. Possible values are: - "post" -
   * Publish content to the stream.  - "share" - Reshare an activity.
   * The value set may be {@code null}.
   */
  public Activity setVerb(String verb) {
    this.verb = verb;
    return this;
  }

  /**
   * The person who performed this activity.
   */
  public static final class Actor extends GenericJson {

    /**
     * The name of the actor, suitable for display.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String displayName;

    /**
     * The ID of the actor's person resource.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String id;

    /**
     * The image representation of the actor.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Image image;

    /**
     * An object representation of the individual components of name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Name name;

    /**
     * The link to the actor's Google profile.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String url;

    /**
     * The name of the actor, suitable for display.
     * The value returned may be {@code null}.
     */
    public String getDisplayName() {
      return displayName;
    }

    /**
     * The name of the actor, suitable for display.
     * The value set may be {@code null}.
     */
    public Actor setDisplayName(String displayName) {
      this.displayName = displayName;
      return this;
    }

    /**
     * The ID of the actor's person resource.
     * The value returned may be {@code null}.
     */
    public String getId() {
      return id;
    }

    /**
     * The ID of the actor's person resource.
     * The value set may be {@code null}.
     */
    public Actor setId(String id) {
      this.id = id;
      return this;
    }

    /**
     * The image representation of the actor.
     * The value returned may be {@code null}.
     */
    public Image getImage() {
      return image;
    }

    /**
     * The image representation of the actor.
     * The value set may be {@code null}.
     */
    public Actor setImage(Image image) {
      this.image = image;
      return this;
    }

    /**
     * An object representation of the individual components of name.
     * The value returned may be {@code null}.
     */
    public Name getName() {
      return name;
    }

    /**
     * An object representation of the individual components of name.
     * The value set may be {@code null}.
     */
    public Actor setName(Name name) {
      this.name = name;
      return this;
    }

    /**
     * The link to the actor's Google profile.
     * The value returned may be {@code null}.
     */
    public String getUrl() {
      return url;
    }

    /**
     * The link to the actor's Google profile.
     * The value set may be {@code null}.
     */
    public Actor setUrl(String url) {
      this.url = url;
      return this;
    }

    /**
     * The image representation of the actor.
     */
    public static final class Image extends GenericJson {

      /**
       * The URL of the actor's profile photo. To re-size the image and crop it to a square, append the
       * query string ?sz=x, where x is the dimension in pixels of each side.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String url;

      /**
       * The URL of the actor's profile photo. To re-size the image and crop it to a square, append the
       * query string ?sz=x, where x is the dimension in pixels of each side.
       * The value returned may be {@code null}.
       */
      public String getUrl() {
        return url;
      }

      /**
       * The URL of the actor's profile photo. To re-size the image and crop it to a square, append the
       * query string ?sz=x, where x is the dimension in pixels of each side.
       * The value set may be {@code null}.
       */
      public Image setUrl(String url) {
        this.url = url;
        return this;
      }

    }
    /**
     * An object representation of the individual components of name.
     */
    public static final class Name extends GenericJson {

      /**
       * The family name (last name) of the actor.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String familyName;

      /**
       * The given name (first name) of the actor.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String givenName;

      /**
       * The family name (last name) of the actor.
       * The value returned may be {@code null}.
       */
      public String getFamilyName() {
        return familyName;
      }

      /**
       * The family name (last name) of the actor.
       * The value set may be {@code null}.
       */
      public Name setFamilyName(String familyName) {
        this.familyName = familyName;
        return this;
      }

      /**
       * The given name (first name) of the actor.
       * The value returned may be {@code null}.
       */
      public String getGivenName() {
        return givenName;
      }

      /**
       * The given name (first name) of the actor.
       * The value set may be {@code null}.
       */
      public Name setGivenName(String givenName) {
        this.givenName = givenName;
        return this;
      }

    }
  }

  /**
   * The object of this activity.
   */
  public static final class PlusObject extends GenericJson {

    /**
     * If this activity's object is itself another activity (for example, when a person reshares an
     * activity), this property specifies the original activity's actor.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Actor actor;

    /**
     * The media objects attached to this activity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Attachments> attachments;

    static {
      // hack to force ProGuard to consider Attachments used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Attachments.class);
    }

    /**
     * The HTML-formatted content, suitable for display.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String content;

    /**
     * The ID of the object. When resharing an activity, this is the ID of the activity being
     * reshared.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String id;

    /**
     * The type of the object. Possible values are: - "note" - Textual content.  - "activity" - A
     * Google+ activity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String objectType;

    /**
     * The content (text) as provided by the author, stored without any HTML formatting. When creating
     * or updating an activity, this value must be supplied as plain text in the request.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String originalContent;

    /**
     * People who +1'd this activity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Plusoners plusoners;

    /**
     * Comments in reply to this activity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Replies replies;

    /**
     * People who reshared this activity.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Resharers resharers;

    /**
     * The URL that points to the linked resource.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String url;

    /**
     * If this activity's object is itself another activity (for example, when a person reshares an
     * activity), this property specifies the original activity's actor.
     * The value returned may be {@code null}.
     */
    public Actor getActor() {
      return actor;
    }

    /**
     * If this activity's object is itself another activity (for example, when a person reshares an
     * activity), this property specifies the original activity's actor.
     * The value set may be {@code null}.
     */
    public PlusObject setActor(Actor actor) {
      this.actor = actor;
      return this;
    }

    /**
     * The media objects attached to this activity.
     * The value returned may be {@code null}.
     */
    public java.util.List<Attachments> getAttachments() {
      return attachments;
    }

    /**
     * The media objects attached to this activity.
     * The value set may be {@code null}.
     */
    public PlusObject setAttachments(java.util.List<Attachments> attachments) {
      this.attachments = attachments;
      return this;
    }

    /**
     * The HTML-formatted content, suitable for display.
     * The value returned may be {@code null}.
     */
    public String getContent() {
      return content;
    }

    /**
     * The HTML-formatted content, suitable for display.
     * The value set may be {@code null}.
     */
    public PlusObject setContent(String content) {
      this.content = content;
      return this;
    }

    /**
     * The ID of the object. When resharing an activity, this is the ID of the activity being
     * reshared.
     * The value returned may be {@code null}.
     */
    public String getId() {
      return id;
    }

    /**
     * The ID of the object. When resharing an activity, this is the ID of the activity being
     * reshared.
     * The value set may be {@code null}.
     */
    public PlusObject setId(String id) {
      this.id = id;
      return this;
    }

    /**
     * The type of the object. Possible values are: - "note" - Textual content.  - "activity" - A
     * Google+ activity.
     * The value returned may be {@code null}.
     */
    public String getObjectType() {
      return objectType;
    }

    /**
     * The type of the object. Possible values are: - "note" - Textual content.  - "activity" - A
     * Google+ activity.
     * The value set may be {@code null}.
     */
    public PlusObject setObjectType(String objectType) {
      this.objectType = objectType;
      return this;
    }

    /**
     * The content (text) as provided by the author, stored without any HTML formatting. When creating
     * or updating an activity, this value must be supplied as plain text in the request.
     * The value returned may be {@code null}.
     */
    public String getOriginalContent() {
      return originalContent;
    }

    /**
     * The content (text) as provided by the author, stored without any HTML formatting. When creating
     * or updating an activity, this value must be supplied as plain text in the request.
     * The value set may be {@code null}.
     */
    public PlusObject setOriginalContent(String originalContent) {
      this.originalContent = originalContent;
      return this;
    }

    /**
     * People who +1'd this activity.
     * The value returned may be {@code null}.
     */
    public Plusoners getPlusoners() {
      return plusoners;
    }

    /**
     * People who +1'd this activity.
     * The value set may be {@code null}.
     */
    public PlusObject setPlusoners(Plusoners plusoners) {
      this.plusoners = plusoners;
      return this;
    }

    /**
     * Comments in reply to this activity.
     * The value returned may be {@code null}.
     */
    public Replies getReplies() {
      return replies;
    }

    /**
     * Comments in reply to this activity.
     * The value set may be {@code null}.
     */
    public PlusObject setReplies(Replies replies) {
      this.replies = replies;
      return this;
    }

    /**
     * People who reshared this activity.
     * The value returned may be {@code null}.
     */
    public Resharers getResharers() {
      return resharers;
    }

    /**
     * People who reshared this activity.
     * The value set may be {@code null}.
     */
    public PlusObject setResharers(Resharers resharers) {
      this.resharers = resharers;
      return this;
    }

    /**
     * The URL that points to the linked resource.
     * The value returned may be {@code null}.
     */
    public String getUrl() {
      return url;
    }

    /**
     * The URL that points to the linked resource.
     * The value set may be {@code null}.
     */
    public PlusObject setUrl(String url) {
      this.url = url;
      return this;
    }

    /**
     * If this activity's object is itself another activity (for example, when a person reshares an
     * activity), this property specifies the original activity's actor.
     */
    public static final class Actor extends GenericJson {

      /**
       * The original actor's name, suitable for display.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String displayName;

      /**
       * ID of the original actor.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String id;

      /**
       * The image representation of the original actor.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Image image;

      /**
       * A link to the original actor's Google profile.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String url;

      /**
       * The original actor's name, suitable for display.
       * The value returned may be {@code null}.
       */
      public String getDisplayName() {
        return displayName;
      }

      /**
       * The original actor's name, suitable for display.
       * The value set may be {@code null}.
       */
      public Actor setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
      }

      /**
       * ID of the original actor.
       * The value returned may be {@code null}.
       */
      public String getId() {
        return id;
      }

      /**
       * ID of the original actor.
       * The value set may be {@code null}.
       */
      public Actor setId(String id) {
        this.id = id;
        return this;
      }

      /**
       * The image representation of the original actor.
       * The value returned may be {@code null}.
       */
      public Image getImage() {
        return image;
      }

      /**
       * The image representation of the original actor.
       * The value set may be {@code null}.
       */
      public Actor setImage(Image image) {
        this.image = image;
        return this;
      }

      /**
       * A link to the original actor's Google profile.
       * The value returned may be {@code null}.
       */
      public String getUrl() {
        return url;
      }

      /**
       * A link to the original actor's Google profile.
       * The value set may be {@code null}.
       */
      public Actor setUrl(String url) {
        this.url = url;
        return this;
      }

      /**
       * The image representation of the original actor.
       */
      public static final class Image extends GenericJson {

        /**
         * A URL that points to a thumbnail photo of the original actor.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String url;

        /**
         * A URL that points to a thumbnail photo of the original actor.
         * The value returned may be {@code null}.
         */
        public String getUrl() {
          return url;
        }

        /**
         * A URL that points to a thumbnail photo of the original actor.
         * The value set may be {@code null}.
         */
        public Image setUrl(String url) {
          this.url = url;
          return this;
        }

      }
    }
    /**
     * Model definition for ActivityObjectAttachments.
     */
    public static final class Attachments extends GenericJson {

      /**
       * If the attachment is an article, this property contains a snippet of text from the article. It
       * can also include descriptions for other types.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String content;

      /**
       * The title of the attachment (such as a photo caption or an article title).
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String displayName;

      /**
       * If the attachment is a video, the embeddable link.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Embed embed;

      /**
       * The full image URL for photo attachments.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private FullImage fullImage;

      /**
       * The ID of the attachment.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String id;

      /**
       * The preview image for photos or videos.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Image image;

      /**
       * The type of media object. Possible values are: - "photo" - A photo.  - "album" - A photo album.
       * - "video" - A video.  - "article" - An article, specified by a link.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String objectType;

      /**
       * If the attachment is an album, potential additional thumbnails from the album.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.util.List<Thumbnails> thumbnails;

      static {
        // hack to force ProGuard to consider Thumbnails used, since otherwise it would be stripped out
        // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
        com.google.api.client.util.Data.nullOf(Thumbnails.class);
      }

      /**
       * The link to the attachment, should be of type text/html.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String url;

      /**
       * If the attachment is an article, this property contains a snippet of text from the article. It
       * can also include descriptions for other types.
       * The value returned may be {@code null}.
       */
      public String getContent() {
        return content;
      }

      /**
       * If the attachment is an article, this property contains a snippet of text from the article. It
       * can also include descriptions for other types.
       * The value set may be {@code null}.
       */
      public Attachments setContent(String content) {
        this.content = content;
        return this;
      }

      /**
       * The title of the attachment (such as a photo caption or an article title).
       * The value returned may be {@code null}.
       */
      public String getDisplayName() {
        return displayName;
      }

      /**
       * The title of the attachment (such as a photo caption or an article title).
       * The value set may be {@code null}.
       */
      public Attachments setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
      }

      /**
       * If the attachment is a video, the embeddable link.
       * The value returned may be {@code null}.
       */
      public Embed getEmbed() {
        return embed;
      }

      /**
       * If the attachment is a video, the embeddable link.
       * The value set may be {@code null}.
       */
      public Attachments setEmbed(Embed embed) {
        this.embed = embed;
        return this;
      }

      /**
       * The full image URL for photo attachments.
       * The value returned may be {@code null}.
       */
      public FullImage getFullImage() {
        return fullImage;
      }

      /**
       * The full image URL for photo attachments.
       * The value set may be {@code null}.
       */
      public Attachments setFullImage(FullImage fullImage) {
        this.fullImage = fullImage;
        return this;
      }

      /**
       * The ID of the attachment.
       * The value returned may be {@code null}.
       */
      public String getId() {
        return id;
      }

      /**
       * The ID of the attachment.
       * The value set may be {@code null}.
       */
      public Attachments setId(String id) {
        this.id = id;
        return this;
      }

      /**
       * The preview image for photos or videos.
       * The value returned may be {@code null}.
       */
      public Image getImage() {
        return image;
      }

      /**
       * The preview image for photos or videos.
       * The value set may be {@code null}.
       */
      public Attachments setImage(Image image) {
        this.image = image;
        return this;
      }

      /**
       * The type of media object. Possible values are: - "photo" - A photo.  - "album" - A photo album.
       * - "video" - A video.  - "article" - An article, specified by a link.
       * The value returned may be {@code null}.
       */
      public String getObjectType() {
        return objectType;
      }

      /**
       * The type of media object. Possible values are: - "photo" - A photo.  - "album" - A photo album.
       * - "video" - A video.  - "article" - An article, specified by a link.
       * The value set may be {@code null}.
       */
      public Attachments setObjectType(String objectType) {
        this.objectType = objectType;
        return this;
      }

      /**
       * If the attachment is an album, potential additional thumbnails from the album.
       * The value returned may be {@code null}.
       */
      public java.util.List<Thumbnails> getThumbnails() {
        return thumbnails;
      }

      /**
       * If the attachment is an album, potential additional thumbnails from the album.
       * The value set may be {@code null}.
       */
      public Attachments setThumbnails(java.util.List<Thumbnails> thumbnails) {
        this.thumbnails = thumbnails;
        return this;
      }

      /**
       * The link to the attachment, should be of type text/html.
       * The value returned may be {@code null}.
       */
      public String getUrl() {
        return url;
      }

      /**
       * The link to the attachment, should be of type text/html.
       * The value set may be {@code null}.
       */
      public Attachments setUrl(String url) {
        this.url = url;
        return this;
      }

      /**
       * If the attachment is a video, the embeddable link.
       */
      public static final class Embed extends GenericJson {

        /**
         * Media type of the link.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String type;

        /**
         * URL of the link.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String url;

        /**
         * Media type of the link.
         * The value returned may be {@code null}.
         */
        public String getType() {
          return type;
        }

        /**
         * Media type of the link.
         * The value set may be {@code null}.
         */
        public Embed setType(String type) {
          this.type = type;
          return this;
        }

        /**
         * URL of the link.
         * The value returned may be {@code null}.
         */
        public String getUrl() {
          return url;
        }

        /**
         * URL of the link.
         * The value set may be {@code null}.
         */
        public Embed setUrl(String url) {
          this.url = url;
          return this;
        }

      }
      /**
       * The full image URL for photo attachments.
       */
      public static final class FullImage extends GenericJson {

        /**
         * The height, in pixels, of the linked resource.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private Long height;

        /**
         * Media type of the link.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String type;

        /**
         * URL to the image.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String url;

        /**
         * The width, in pixels, of the linked resource.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private Long width;

        /**
         * The height, in pixels, of the linked resource.
         * The value returned may be {@code null}.
         */
        public Long getHeight() {
          return height;
        }

        /**
         * The height, in pixels, of the linked resource.
         * The value set may be {@code null}.
         */
        public FullImage setHeight(Long height) {
          this.height = height;
          return this;
        }

        /**
         * Media type of the link.
         * The value returned may be {@code null}.
         */
        public String getType() {
          return type;
        }

        /**
         * Media type of the link.
         * The value set may be {@code null}.
         */
        public FullImage setType(String type) {
          this.type = type;
          return this;
        }

        /**
         * URL to the image.
         * The value returned may be {@code null}.
         */
        public String getUrl() {
          return url;
        }

        /**
         * URL to the image.
         * The value set may be {@code null}.
         */
        public FullImage setUrl(String url) {
          this.url = url;
          return this;
        }

        /**
         * The width, in pixels, of the linked resource.
         * The value returned may be {@code null}.
         */
        public Long getWidth() {
          return width;
        }

        /**
         * The width, in pixels, of the linked resource.
         * The value set may be {@code null}.
         */
        public FullImage setWidth(Long width) {
          this.width = width;
          return this;
        }

      }
      /**
       * The preview image for photos or videos.
       */
      public static final class Image extends GenericJson {

        /**
         * The height, in pixels, of the linked resource.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private Long height;

        /**
         * Media type of the link.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String type;

        /**
         * Image url.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String url;

        /**
         * The width, in pixels, of the linked resource.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private Long width;

        /**
         * The height, in pixels, of the linked resource.
         * The value returned may be {@code null}.
         */
        public Long getHeight() {
          return height;
        }

        /**
         * The height, in pixels, of the linked resource.
         * The value set may be {@code null}.
         */
        public Image setHeight(Long height) {
          this.height = height;
          return this;
        }

        /**
         * Media type of the link.
         * The value returned may be {@code null}.
         */
        public String getType() {
          return type;
        }

        /**
         * Media type of the link.
         * The value set may be {@code null}.
         */
        public Image setType(String type) {
          this.type = type;
          return this;
        }

        /**
         * Image url.
         * The value returned may be {@code null}.
         */
        public String getUrl() {
          return url;
        }

        /**
         * Image url.
         * The value set may be {@code null}.
         */
        public Image setUrl(String url) {
          this.url = url;
          return this;
        }

        /**
         * The width, in pixels, of the linked resource.
         * The value returned may be {@code null}.
         */
        public Long getWidth() {
          return width;
        }

        /**
         * The width, in pixels, of the linked resource.
         * The value set may be {@code null}.
         */
        public Image setWidth(Long width) {
          this.width = width;
          return this;
        }

      }
      /**
       * Model definition for ActivityObjectAttachmentsThumbnails.
       */
      public static final class Thumbnails extends GenericJson {

        /**
         * Potential name of the thumbnail.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String description;

        /**
         * Image resource.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private Image image;

        /**
         * URL to the webpage containing the image.
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private String url;

        /**
         * Potential name of the thumbnail.
         * The value returned may be {@code null}.
         */
        public String getDescription() {
          return description;
        }

        /**
         * Potential name of the thumbnail.
         * The value set may be {@code null}.
         */
        public Thumbnails setDescription(String description) {
          this.description = description;
          return this;
        }

        /**
         * Image resource.
         * The value returned may be {@code null}.
         */
        public Image getImage() {
          return image;
        }

        /**
         * Image resource.
         * The value set may be {@code null}.
         */
        public Thumbnails setImage(Image image) {
          this.image = image;
          return this;
        }

        /**
         * URL to the webpage containing the image.
         * The value returned may be {@code null}.
         */
        public String getUrl() {
          return url;
        }

        /**
         * URL to the webpage containing the image.
         * The value set may be {@code null}.
         */
        public Thumbnails setUrl(String url) {
          this.url = url;
          return this;
        }

        /**
         * Image resource.
         */
        public static final class Image extends GenericJson {

          /**
           * The height, in pixels, of the linked resource.
           * The value may be {@code null}.
           */
          @com.google.api.client.util.Key
          private Long height;

          /**
           * Media type of the link.
           * The value may be {@code null}.
           */
          @com.google.api.client.util.Key
          private String type;

          /**
           * Image url.
           * The value may be {@code null}.
           */
          @com.google.api.client.util.Key
          private String url;

          /**
           * The width, in pixels, of the linked resource.
           * The value may be {@code null}.
           */
          @com.google.api.client.util.Key
          private Long width;

          /**
           * The height, in pixels, of the linked resource.
           * The value returned may be {@code null}.
           */
          public Long getHeight() {
            return height;
          }

          /**
           * The height, in pixels, of the linked resource.
           * The value set may be {@code null}.
           */
          public Image setHeight(Long height) {
            this.height = height;
            return this;
          }

          /**
           * Media type of the link.
           * The value returned may be {@code null}.
           */
          public String getType() {
            return type;
          }

          /**
           * Media type of the link.
           * The value set may be {@code null}.
           */
          public Image setType(String type) {
            this.type = type;
            return this;
          }

          /**
           * Image url.
           * The value returned may be {@code null}.
           */
          public String getUrl() {
            return url;
          }

          /**
           * Image url.
           * The value set may be {@code null}.
           */
          public Image setUrl(String url) {
            this.url = url;
            return this;
          }

          /**
           * The width, in pixels, of the linked resource.
           * The value returned may be {@code null}.
           */
          public Long getWidth() {
            return width;
          }

          /**
           * The width, in pixels, of the linked resource.
           * The value set may be {@code null}.
           */
          public Image setWidth(Long width) {
            this.width = width;
            return this;
          }

        }
      }
    }
    /**
     * People who +1'd this activity.
     */
    public static final class Plusoners extends GenericJson {

      /**
       * The URL for the collection of people who +1'd this activity.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String selfLink;

      /**
       * Total number of people who +1'd this activity.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Long totalItems;

      /**
       * The URL for the collection of people who +1'd this activity.
       * The value returned may be {@code null}.
       */
      public String getSelfLink() {
        return selfLink;
      }

      /**
       * The URL for the collection of people who +1'd this activity.
       * The value set may be {@code null}.
       */
      public Plusoners setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
      }

      /**
       * Total number of people who +1'd this activity.
       * The value returned may be {@code null}.
       */
      public Long getTotalItems() {
        return totalItems;
      }

      /**
       * Total number of people who +1'd this activity.
       * The value set may be {@code null}.
       */
      public Plusoners setTotalItems(Long totalItems) {
        this.totalItems = totalItems;
        return this;
      }

    }
    /**
     * Comments in reply to this activity.
     */
    public static final class Replies extends GenericJson {

      /**
       * The URL for the collection of comments in reply to this activity.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String selfLink;

      /**
       * Total number of comments on this activity.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Long totalItems;

      /**
       * The URL for the collection of comments in reply to this activity.
       * The value returned may be {@code null}.
       */
      public String getSelfLink() {
        return selfLink;
      }

      /**
       * The URL for the collection of comments in reply to this activity.
       * The value set may be {@code null}.
       */
      public Replies setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
      }

      /**
       * Total number of comments on this activity.
       * The value returned may be {@code null}.
       */
      public Long getTotalItems() {
        return totalItems;
      }

      /**
       * Total number of comments on this activity.
       * The value set may be {@code null}.
       */
      public Replies setTotalItems(Long totalItems) {
        this.totalItems = totalItems;
        return this;
      }

    }
    /**
     * People who reshared this activity.
     */
    public static final class Resharers extends GenericJson {

      /**
       * The URL for the collection of resharers.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private String selfLink;

      /**
       * Total number of people who reshared this activity.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private Long totalItems;

      /**
       * The URL for the collection of resharers.
       * The value returned may be {@code null}.
       */
      public String getSelfLink() {
        return selfLink;
      }

      /**
       * The URL for the collection of resharers.
       * The value set may be {@code null}.
       */
      public Resharers setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
      }

      /**
       * Total number of people who reshared this activity.
       * The value returned may be {@code null}.
       */
      public Long getTotalItems() {
        return totalItems;
      }

      /**
       * Total number of people who reshared this activity.
       * The value set may be {@code null}.
       */
      public Resharers setTotalItems(Long totalItems) {
        this.totalItems = totalItems;
        return this;
      }

    }
  }

  /**
   * The service provider that initially published this activity.
   */
  public static final class Provider extends GenericJson {

    /**
     * Name of the service provider.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String title;

    /**
     * Name of the service provider.
     * The value returned may be {@code null}.
     */
    public String getTitle() {
      return title;
    }

    /**
     * Name of the service provider.
     * The value set may be {@code null}.
     */
    public Provider setTitle(String title) {
      this.title = title;
      return this;
    }

  }

}
