/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.plus.model;

import com.google.api.client.json.GenericJson;

/**
 * Model definition for Acl.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google+ API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Acl extends GenericJson {

  /**
   * Description of the access granted, suitable for display.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * The list of access entries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PlusAclentryResource> items;

  static {
    // hack to force ProGuard to consider PlusAclentryResource used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(PlusAclentryResource.class);
  }

  /**
   * Identifies this resource as a collection of access controls. Value: "plus#acl".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Description of the access granted, suitable for display.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Description of the access granted, suitable for display.
   * The value set may be {@code null}.
   */
  public Acl setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * The list of access entries.
   * The value returned may be {@code null}.
   */
  public java.util.List<PlusAclentryResource> getItems() {
    return items;
  }

  /**
   * The list of access entries.
   * The value set may be {@code null}.
   */
  public Acl setItems(java.util.List<PlusAclentryResource> items) {
    this.items = items;
    return this;
  }

  /**
   * Identifies this resource as a collection of access controls. Value: "plus#acl".
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Identifies this resource as a collection of access controls. Value: "plus#acl".
   * The value set may be {@code null}.
   */
  public Acl setKind(String kind) {
    this.kind = kind;
    return this;
  }

}
