/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This file was generated.
 *  with google-apis-code-generator 1.3.0 (build: 2013-04-09 19:13:20 UTC)
 *  on 2013-04-10 at 01:14:31 UTC 
 */

package com.google.api.services.plus;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.common.base.Preconditions;

/**
 * Service definition for Plus (v1).
 *
 * <p>
 * The Google+ API enables developers to build on top of the Google+ platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/+/api/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link PlusRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * <p>
 * Upgrade warning: this class now extends {@link AbstractGoogleJsonClient}, whereas in prior
 * version 1.8 it extended {@link com.google.api.client.googleapis.services.GoogleClient}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Plus extends AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    Preconditions.checkState(GoogleUtils.VERSION.equals("1.13.2-beta"),
        "You are currently running with version %s of google-api-client. " +
        "You need version 1.13.2-beta of google-api-client to run version " +
        "1.13.2-beta of the Google+ API library.", GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "plus/v1/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   * @deprecated (scheduled to be removed in 1.13)
   */
  @Deprecated
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport
   * @param jsonFactory JSON factory
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Plus(HttpTransport transport, JsonFactory jsonFactory,
      HttpRequestInitializer httpRequestInitializer) {
    super(transport,
        jsonFactory,
        DEFAULT_ROOT_URL,
        DEFAULT_SERVICE_PATH,
        httpRequestInitializer,
        false);
  }

  /**
   * @param transport HTTP transport
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @param rootUrl root URL of the service
   * @param servicePath service path
   * @param jsonObjectParser JSON object parser
   * @param googleClientRequestInitializer Google request initializer or {@code null} for none
   * @param applicationName application name to be sent in the User-Agent header of requests or
   *        {@code null} for none
   * @param suppressPatternChecks whether discovery pattern checks should be suppressed on required
   *        parameters
   */
  Plus(HttpTransport transport,
      HttpRequestInitializer httpRequestInitializer,
      String rootUrl,
      String servicePath,
      JsonObjectParser jsonObjectParser,
      GoogleClientRequestInitializer googleClientRequestInitializer,
      String applicationName,
      boolean suppressPatternChecks) {
    super(transport,
        httpRequestInitializer,
        rootUrl,
        servicePath,
        jsonObjectParser,
        googleClientRequestInitializer,
        applicationName,
        suppressPatternChecks);
  }

  @Override
  protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Activities collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Plus plus = new Plus(...);}
   *   {@code Plus.Activities.List request = plus.activities().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Activities activities() {
    return new Activities();
  }

  /**
   * The "activities" collection of methods.
   */
  public class Activities {

    /**
     * Get an activity.
     *
     * Create a request for the method "activities.get".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param activityId The ID of the activity to get.
     * @return the request
     */
    public Get get(String activityId) throws java.io.IOException {
      Get result = new Get(activityId);
      initialize(result);
      return result;
    }

    public class Get extends PlusRequest<com.google.api.services.plus.model.Activity> {

      private static final String REST_PATH = "activities/{activityId}";

      /**
       * Get an activity.
       *
       * Create a request for the method "activities.get".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param activityId The ID of the activity to get.
       * @since 1.13
       */
      protected Get(String activityId) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.Activity.class);
        this.activityId = Preconditions.checkNotNull(activityId, "Required parameter activityId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the activity to get. */
      @com.google.api.client.util.Key
      private String activityId;

      /** The ID of the activity to get.
       */
      public String getActivityId() {
        return activityId;
      }

      /** The ID of the activity to get. */
      public Get setActivityId(String activityId) {
        this.activityId = activityId;
        return this;
      }

    }
    /**
     * List all of the activities in the specified collection for a particular user.
     *
     * Create a request for the method "activities.list".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param userId The ID of the user to get activities for. The special value "me" can be used to indicate the
     *        authenticated user.
     * @param collection The collection of activities to list.
     * @return the request
     */
    public List list(String userId, String collection) throws java.io.IOException {
      List result = new List(userId, collection);
      initialize(result);
      return result;
    }

    public class List extends PlusRequest<com.google.api.services.plus.model.ActivityFeed> {

      private static final String REST_PATH = "people/{userId}/activities/{collection}";

      /**
       * List all of the activities in the specified collection for a particular user.
       *
       * Create a request for the method "activities.list".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param userId The ID of the user to get activities for. The special value "me" can be used to indicate the
     *        authenticated user.
       * @param collection The collection of activities to list.
       * @since 1.13
       */
      protected List(String userId, String collection) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.ActivityFeed.class);
        this.userId = Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        this.collection = Preconditions.checkNotNull(collection, "Required parameter collection must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
     * The ID of the user to get activities for. The special value "me" can be used to indicate the
     * authenticated user.
     */
      @com.google.api.client.util.Key
      private String userId;

      /** The ID of the user to get activities for. The special value "me" can be used to indicate the
     authenticated user.
       */
      public String getUserId() {
        return userId;
      }

      /**
     * The ID of the user to get activities for. The special value "me" can be used to indicate the
     * authenticated user.
     */
      public List setUserId(String userId) {
        this.userId = userId;
        return this;
      }

      /** The collection of activities to list. */
      @com.google.api.client.util.Key
      private String collection;

      /** The collection of activities to list.
       */
      public String getCollection() {
        return collection;
      }

      /** The collection of activities to list. */
      public List setCollection(String collection) {
        this.collection = collection;
        return this;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** The continuation token, which is used to page through large result sets. To get the next page of
     results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
     * The maximum number of activities to include in the response, which is used for paging. For
     * any response, the actual number returned might be less than the specified maxResults.
     */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** The maximum number of activities to include in the response, which is used for paging. For any
     response, the actual number returned might be less than the specified maxResults. [default: 20]
     [minimum: 1] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
     * The maximum number of activities to include in the response, which is used for paging. For
     * any response, the actual number returned might be less than the specified maxResults.
     */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Search public activities.
     *
     * Create a request for the method "activities.search".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link Search#execute()} method to invoke the remote operation.
     *
     * @param query Full-text search query string.
     * @return the request
     */
    public Search search(String query) throws java.io.IOException {
      Search result = new Search(query);
      initialize(result);
      return result;
    }

    public class Search extends PlusRequest<com.google.api.services.plus.model.ActivityFeed> {

      private static final String REST_PATH = "activities";

      /**
       * Search public activities.
       *
       * Create a request for the method "activities.search".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link Search#execute()} method to invoke the remote operation. <p> {@link
       * Search#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param query Full-text search query string.
       * @since 1.13
       */
      protected Search(String query) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.ActivityFeed.class);
        this.query = Preconditions.checkNotNull(query, "Required parameter query must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Search setAlt(String alt) {
        return (Search) super.setAlt(alt);
      }

      @Override
      public Search setFields(String fields) {
        return (Search) super.setFields(fields);
      }

      @Override
      public Search setKey(String key) {
        return (Search) super.setKey(key);
      }

      @Override
      public Search setOauthToken(String oauthToken) {
        return (Search) super.setOauthToken(oauthToken);
      }

      @Override
      public Search setPrettyPrint(Boolean prettyPrint) {
        return (Search) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Search setQuotaUser(String quotaUser) {
        return (Search) super.setQuotaUser(quotaUser);
      }

      @Override
      public Search setUserIp(String userIp) {
        return (Search) super.setUserIp(userIp);
      }

      /** Full-text search query string. */
      @com.google.api.client.util.Key
      private String query;

      /** Full-text search query string.
       */
      public String getQuery() {
        return query;
      }

      /** Full-text search query string. */
      public Search setQuery(String query) {
        this.query = query;
        return this;
      }

      /** Specifies how to order search results. */
      @com.google.api.client.util.Key
      private String orderBy;

      /** Specifies how to order search results. [default: recent]
       */
      public String getOrderBy() {
        return orderBy;
      }

      /** Specifies how to order search results. */
      public Search setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     * This token can be of any length.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** The continuation token, which is used to page through large result sets. To get the next page of
     results, set this parameter to the value of "nextPageToken" from the previous response. This token
     can be of any length.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     * This token can be of any length.
     */
      public Search setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
     * The maximum number of activities to include in the response, which is used for paging. For
     * any response, the actual number returned might be less than the specified maxResults.
     */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** The maximum number of activities to include in the response, which is used for paging. For any
     response, the actual number returned might be less than the specified maxResults. [default: 10]
     [minimum: 1] [maximum: 20]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
     * The maximum number of activities to include in the response, which is used for paging. For
     * any response, the actual number returned might be less than the specified maxResults.
     */
      public Search setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
     * Specify the preferred language to search with. See search language codes for available
     * values.
     */
      @com.google.api.client.util.Key
      private String language;

      /** Specify the preferred language to search with. See search language codes for available values.
     [default: en-US]
       */
      public String getLanguage() {
        return language;
      }

      /**
     * Specify the preferred language to search with. See search language codes for available
     * values.
     */
      public Search setLanguage(String language) {
        this.language = language;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Comments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Plus plus = new Plus(...);}
   *   {@code Plus.Comments.List request = plus.comments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Comments comments() {
    return new Comments();
  }

  /**
   * The "comments" collection of methods.
   */
  public class Comments {

    /**
     * Get a comment.
     *
     * Create a request for the method "comments.get".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param commentId The ID of the comment to get.
     * @return the request
     */
    public Get get(String commentId) throws java.io.IOException {
      Get result = new Get(commentId);
      initialize(result);
      return result;
    }

    public class Get extends PlusRequest<com.google.api.services.plus.model.Comment> {

      private static final String REST_PATH = "comments/{commentId}";

      /**
       * Get a comment.
       *
       * Create a request for the method "comments.get".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param commentId The ID of the comment to get.
       * @since 1.13
       */
      protected Get(String commentId) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.Comment.class);
        this.commentId = Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the comment to get. */
      @com.google.api.client.util.Key
      private String commentId;

      /** The ID of the comment to get.
       */
      public String getCommentId() {
        return commentId;
      }

      /** The ID of the comment to get. */
      public Get setCommentId(String commentId) {
        this.commentId = commentId;
        return this;
      }

    }
    /**
     * List all of the comments for an activity.
     *
     * Create a request for the method "comments.list".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param activityId The ID of the activity to get comments for.
     * @return the request
     */
    public List list(String activityId) throws java.io.IOException {
      List result = new List(activityId);
      initialize(result);
      return result;
    }

    public class List extends PlusRequest<com.google.api.services.plus.model.CommentFeed> {

      private static final String REST_PATH = "activities/{activityId}/comments";

      /**
       * List all of the comments for an activity.
       *
       * Create a request for the method "comments.list".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param activityId The ID of the activity to get comments for.
       * @since 1.13
       */
      protected List(String activityId) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.CommentFeed.class);
        this.activityId = Preconditions.checkNotNull(activityId, "Required parameter activityId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the activity to get comments for. */
      @com.google.api.client.util.Key
      private String activityId;

      /** The ID of the activity to get comments for.
       */
      public String getActivityId() {
        return activityId;
      }

      /** The ID of the activity to get comments for. */
      public List setActivityId(String activityId) {
        this.activityId = activityId;
        return this;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** The continuation token, which is used to page through large result sets. To get the next page of
     results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** The order in which to sort the list of comments. */
      @com.google.api.client.util.Key
      private String sortOrder;

      /** The order in which to sort the list of comments. [default: ascending]
       */
      public String getSortOrder() {
        return sortOrder;
      }

      /** The order in which to sort the list of comments. */
      public List setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
        return this;
      }

      /**
     * The maximum number of comments to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** The maximum number of comments to include in the response, which is used for paging. For any
     response, the actual number returned might be less than the specified maxResults. [default: 20]
     [minimum: 0] [maximum: 500]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
     * The maximum number of comments to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the Moments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Plus plus = new Plus(...);}
   *   {@code Plus.Moments.List request = plus.moments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Moments moments() {
    return new Moments();
  }

  /**
   * The "moments" collection of methods.
   */
  public class Moments {

    /**
     * Record a moment representing a user's activity such as making a purchase or commenting on a blog.
     *
     * Create a request for the method "moments.insert".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param userId The ID of the user to record activities for. The only valid values are "me" and the ID of the
     *        authenticated user.
     * @param collection The collection to which to write moments.
     * @param content the {@link com.google.api.services.plus.model.Moment}
     * @return the request
     */
    public Insert insert(String userId, String collection, com.google.api.services.plus.model.Moment content) throws java.io.IOException {
      Insert result = new Insert(userId, collection, content);
      initialize(result);
      return result;
    }

    public class Insert extends PlusRequest<com.google.api.services.plus.model.Moment> {

      private static final String REST_PATH = "people/{userId}/moments/{collection}";

      /**
       * Record a moment representing a user's activity such as making a purchase or commenting on a
       * blog.
       *
       * Create a request for the method "moments.insert".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param userId The ID of the user to record activities for. The only valid values are "me" and the ID of the
     *        authenticated user.
       * @param collection The collection to which to write moments.
       * @param content the {@link com.google.api.services.plus.model.Moment}
       * @since 1.13
       */
      protected Insert(String userId, String collection, com.google.api.services.plus.model.Moment content) {
        super(Plus.this, "POST", REST_PATH, content, com.google.api.services.plus.model.Moment.class);
        this.userId = Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        this.collection = Preconditions.checkNotNull(collection, "Required parameter collection must be specified.");
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
     * The ID of the user to record activities for. The only valid values are "me" and the ID of the
     * authenticated user.
     */
      @com.google.api.client.util.Key
      private String userId;

      /** The ID of the user to record activities for. The only valid values are "me" and the ID of the
     authenticated user.
       */
      public String getUserId() {
        return userId;
      }

      /**
     * The ID of the user to record activities for. The only valid values are "me" and the ID of the
     * authenticated user.
     */
      public Insert setUserId(String userId) {
        this.userId = userId;
        return this;
      }

      /** The collection to which to write moments. */
      @com.google.api.client.util.Key
      private String collection;

      /** The collection to which to write moments.
       */
      public String getCollection() {
        return collection;
      }

      /** The collection to which to write moments. */
      public Insert setCollection(String collection) {
        this.collection = collection;
        return this;
      }

      /** Return the moment as written. Should be used only for debugging. */
      @com.google.api.client.util.Key
      private Boolean debug;

      /** Return the moment as written. Should be used only for debugging.
       */
      public Boolean getDebug() {
        return debug;
      }

      /** Return the moment as written. Should be used only for debugging. */
      public Insert setDebug(Boolean debug) {
        this.debug = debug;
        return this;
      }

    }
    /**
     * List all of the moments for a particular user.
     *
     * Create a request for the method "moments.list".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param userId The ID of the user to get moments for. The special value "me" can be used to indicate the
     *        authenticated user.
     * @param collection The collection of moments to list.
     * @return the request
     */
    public List list(String userId, String collection) throws java.io.IOException {
      List result = new List(userId, collection);
      initialize(result);
      return result;
    }

    public class List extends PlusRequest<com.google.api.services.plus.model.MomentsFeed> {

      private static final String REST_PATH = "people/{userId}/moments/{collection}";

      /**
       * List all of the moments for a particular user.
       *
       * Create a request for the method "moments.list".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param userId The ID of the user to get moments for. The special value "me" can be used to indicate the
     *        authenticated user.
       * @param collection The collection of moments to list.
       * @since 1.13
       */
      protected List(String userId, String collection) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.MomentsFeed.class);
        this.userId = Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        this.collection = Preconditions.checkNotNull(collection, "Required parameter collection must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
     * The ID of the user to get moments for. The special value "me" can be used to indicate the
     * authenticated user.
     */
      @com.google.api.client.util.Key
      private String userId;

      /** The ID of the user to get moments for. The special value "me" can be used to indicate the
     authenticated user.
       */
      public String getUserId() {
        return userId;
      }

      /**
     * The ID of the user to get moments for. The special value "me" can be used to indicate the
     * authenticated user.
     */
      public List setUserId(String userId) {
        this.userId = userId;
        return this;
      }

      /** The collection of moments to list. */
      @com.google.api.client.util.Key
      private String collection;

      /** The collection of moments to list.
       */
      public String getCollection() {
        return collection;
      }

      /** The collection of moments to list. */
      public List setCollection(String collection) {
        this.collection = collection;
        return this;
      }

      /**
     * The maximum number of moments to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** The maximum number of moments to include in the response, which is used for paging. For any
     response, the actual number returned might be less than the specified maxResults. [default: 20]
     [minimum: 1] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
     * The maximum number of moments to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** The continuation token, which is used to page through large result sets. To get the next page of
     results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Only moments containing this targetUrl will be returned. */
      @com.google.api.client.util.Key
      private String targetUrl;

      /** Only moments containing this targetUrl will be returned.
       */
      public String getTargetUrl() {
        return targetUrl;
      }

      /** Only moments containing this targetUrl will be returned. */
      public List setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
      }

      /** Only moments of this type will be returned. */
      @com.google.api.client.util.Key
      private String type;

      /** Only moments of this type will be returned.
       */
      public String getType() {
        return type;
      }

      /** Only moments of this type will be returned. */
      public List setType(String type) {
        this.type = type;
        return this;
      }

    }
    /**
     * Delete a moment.
     *
     * Create a request for the method "moments.remove".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link Remove#execute()} method to invoke the remote operation.
     *
     * @param id The ID of the moment to delete.
     * @return the request
     */
    public Remove remove(String id) throws java.io.IOException {
      Remove result = new Remove(id);
      initialize(result);
      return result;
    }

    public class Remove extends PlusRequest<Void> {

      private static final String REST_PATH = "moments/{id}";

      /**
       * Delete a moment.
       *
       * Create a request for the method "moments.remove".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link Remove#execute()} method to invoke the remote operation. <p> {@link
       * Remove#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param id The ID of the moment to delete.
       * @since 1.13
       */
      protected Remove(String id) {
        super(Plus.this, "DELETE", REST_PATH, null, Void.class);
        this.id = Preconditions.checkNotNull(id, "Required parameter id must be specified.");
      }

      @Override
      public Remove setAlt(String alt) {
        return (Remove) super.setAlt(alt);
      }

      @Override
      public Remove setFields(String fields) {
        return (Remove) super.setFields(fields);
      }

      @Override
      public Remove setKey(String key) {
        return (Remove) super.setKey(key);
      }

      @Override
      public Remove setOauthToken(String oauthToken) {
        return (Remove) super.setOauthToken(oauthToken);
      }

      @Override
      public Remove setPrettyPrint(Boolean prettyPrint) {
        return (Remove) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Remove setQuotaUser(String quotaUser) {
        return (Remove) super.setQuotaUser(quotaUser);
      }

      @Override
      public Remove setUserIp(String userIp) {
        return (Remove) super.setUserIp(userIp);
      }

      /** The ID of the moment to delete. */
      @com.google.api.client.util.Key
      private String id;

      /** The ID of the moment to delete.
       */
      public String getId() {
        return id;
      }

      /** The ID of the moment to delete. */
      public Remove setId(String id) {
        this.id = id;
        return this;
      }

    }

  }

  /**
   * An accessor for creating requests from the People collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Plus plus = new Plus(...);}
   *   {@code Plus.People.List request = plus.people().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public People people() {
    return new People();
  }

  /**
   * The "people" collection of methods.
   */
  public class People {

    /**
     * Get a person's profile. If your app uses scope https://www.googleapis.com/auth/plus.login, this
     * method is guaranteed to return ageRange and language.
     *
     * Create a request for the method "people.get".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param userId The ID of the person to get the profile for. The special value "me" can be used to indicate the
     *        authenticated user.
     * @return the request
     */
    public Get get(String userId) throws java.io.IOException {
      Get result = new Get(userId);
      initialize(result);
      return result;
    }

    public class Get extends PlusRequest<com.google.api.services.plus.model.Person> {

      private static final String REST_PATH = "people/{userId}";

      /**
       * Get a person's profile. If your app uses scope https://www.googleapis.com/auth/plus.login, this
       * method is guaranteed to return ageRange and language.
       *
       * Create a request for the method "people.get".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param userId The ID of the person to get the profile for. The special value "me" can be used to indicate the
     *        authenticated user.
       * @since 1.13
       */
      protected Get(String userId) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.Person.class);
        this.userId = Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /**
     * The ID of the person to get the profile for. The special value "me" can be used to indicate
     * the authenticated user.
     */
      @com.google.api.client.util.Key
      private String userId;

      /** The ID of the person to get the profile for. The special value "me" can be used to indicate the
     authenticated user.
       */
      public String getUserId() {
        return userId;
      }

      /**
     * The ID of the person to get the profile for. The special value "me" can be used to indicate
     * the authenticated user.
     */
      public Get setUserId(String userId) {
        this.userId = userId;
        return this;
      }

    }
    /**
     * List all of the people in the specified collection.
     *
     * Create a request for the method "people.list".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param userId Get the collection of people for the person identified. Use "me" to indicate the authenticated user.
     * @param collection The collection of people to list.
     * @return the request
     */
    public List list(String userId, String collection) throws java.io.IOException {
      List result = new List(userId, collection);
      initialize(result);
      return result;
    }

    public class List extends PlusRequest<com.google.api.services.plus.model.PeopleFeed> {

      private static final String REST_PATH = "people/{userId}/people/{collection}";

      /**
       * List all of the people in the specified collection.
       *
       * Create a request for the method "people.list".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param userId Get the collection of people for the person identified. Use "me" to indicate the authenticated user.
       * @param collection The collection of people to list.
       * @since 1.13
       */
      protected List(String userId, String collection) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.PeopleFeed.class);
        this.userId = Preconditions.checkNotNull(userId, "Required parameter userId must be specified.");
        this.collection = Preconditions.checkNotNull(collection, "Required parameter collection must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
     * Get the collection of people for the person identified. Use "me" to indicate the
     * authenticated user.
     */
      @com.google.api.client.util.Key
      private String userId;

      /** Get the collection of people for the person identified. Use "me" to indicate the authenticated
     user.
       */
      public String getUserId() {
        return userId;
      }

      /**
     * Get the collection of people for the person identified. Use "me" to indicate the
     * authenticated user.
     */
      public List setUserId(String userId) {
        this.userId = userId;
        return this;
      }

      /** The collection of people to list. */
      @com.google.api.client.util.Key
      private String collection;

      /** The collection of people to list.
       */
      public String getCollection() {
        return collection;
      }

      /** The collection of people to list. */
      public List setCollection(String collection) {
        this.collection = collection;
        return this;
      }

      /** The order to return people in. */
      @com.google.api.client.util.Key
      private String orderBy;

      /** The order to return people in.
       */
      public String getOrderBy() {
        return orderBy;
      }

      /** The order to return people in. */
      public List setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** The continuation token, which is used to page through large result sets. To get the next page of
     results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
     * The maximum number of people to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** The maximum number of people to include in the response, which is used for paging. For any
     response, the actual number returned might be less than the specified maxResults. [default: 100]
     [minimum: 1] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
     * The maximum number of people to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * List all of the people in the specified collection for a particular activity.
     *
     * Create a request for the method "people.listByActivity".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link ListByActivity#execute()} method to invoke the remote operation.
     *
     * @param activityId The ID of the activity to get the list of people for.
     * @param collection The collection of people to list.
     * @return the request
     */
    public ListByActivity listByActivity(String activityId, String collection) throws java.io.IOException {
      ListByActivity result = new ListByActivity(activityId, collection);
      initialize(result);
      return result;
    }

    public class ListByActivity extends PlusRequest<com.google.api.services.plus.model.PeopleFeed> {

      private static final String REST_PATH = "activities/{activityId}/people/{collection}";

      /**
       * List all of the people in the specified collection for a particular activity.
       *
       * Create a request for the method "people.listByActivity".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link ListByActivity#execute()} method to invoke the remote operation.
       * <p> {@link ListByActivity#initialize(AbstractGoogleClientRequest)} must be called to initialize
       * this instance immediately after invoking the constructor. </p>
       *
       * @param activityId The ID of the activity to get the list of people for.
       * @param collection The collection of people to list.
       * @since 1.13
       */
      protected ListByActivity(String activityId, String collection) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.PeopleFeed.class);
        this.activityId = Preconditions.checkNotNull(activityId, "Required parameter activityId must be specified.");
        this.collection = Preconditions.checkNotNull(collection, "Required parameter collection must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListByActivity setAlt(String alt) {
        return (ListByActivity) super.setAlt(alt);
      }

      @Override
      public ListByActivity setFields(String fields) {
        return (ListByActivity) super.setFields(fields);
      }

      @Override
      public ListByActivity setKey(String key) {
        return (ListByActivity) super.setKey(key);
      }

      @Override
      public ListByActivity setOauthToken(String oauthToken) {
        return (ListByActivity) super.setOauthToken(oauthToken);
      }

      @Override
      public ListByActivity setPrettyPrint(Boolean prettyPrint) {
        return (ListByActivity) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListByActivity setQuotaUser(String quotaUser) {
        return (ListByActivity) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListByActivity setUserIp(String userIp) {
        return (ListByActivity) super.setUserIp(userIp);
      }

      /** The ID of the activity to get the list of people for. */
      @com.google.api.client.util.Key
      private String activityId;

      /** The ID of the activity to get the list of people for.
       */
      public String getActivityId() {
        return activityId;
      }

      /** The ID of the activity to get the list of people for. */
      public ListByActivity setActivityId(String activityId) {
        this.activityId = activityId;
        return this;
      }

      /** The collection of people to list. */
      @com.google.api.client.util.Key
      private String collection;

      /** The collection of people to list.
       */
      public String getCollection() {
        return collection;
      }

      /** The collection of people to list. */
      public ListByActivity setCollection(String collection) {
        this.collection = collection;
        return this;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** The continuation token, which is used to page through large result sets. To get the next page of
     results, set this parameter to the value of "nextPageToken" from the previous response.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     */
      public ListByActivity setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
     * The maximum number of people to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** The maximum number of people to include in the response, which is used for paging. For any
     response, the actual number returned might be less than the specified maxResults. [default: 20]
     [minimum: 1] [maximum: 100]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
     * The maximum number of people to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      public ListByActivity setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

    }
    /**
     * Search all public profiles.
     *
     * Create a request for the method "people.search".
     *
     * This request holds the parameters needed by the the plus server.  After setting any optional
     * parameters, call the {@link Search#execute()} method to invoke the remote operation.
     *
     * @param query Specify a query string for full text search of public text in all profiles.
     * @return the request
     */
    public Search search(String query) throws java.io.IOException {
      Search result = new Search(query);
      initialize(result);
      return result;
    }

    public class Search extends PlusRequest<com.google.api.services.plus.model.PeopleFeed> {

      private static final String REST_PATH = "people";

      /**
       * Search all public profiles.
       *
       * Create a request for the method "people.search".
       *
       * This request holds the parameters needed by the the plus server.  After setting any optional
       * parameters, call the {@link Search#execute()} method to invoke the remote operation. <p> {@link
       * Search#initialize(AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param query Specify a query string for full text search of public text in all profiles.
       * @since 1.13
       */
      protected Search(String query) {
        super(Plus.this, "GET", REST_PATH, null, com.google.api.services.plus.model.PeopleFeed.class);
        this.query = Preconditions.checkNotNull(query, "Required parameter query must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Search setAlt(String alt) {
        return (Search) super.setAlt(alt);
      }

      @Override
      public Search setFields(String fields) {
        return (Search) super.setFields(fields);
      }

      @Override
      public Search setKey(String key) {
        return (Search) super.setKey(key);
      }

      @Override
      public Search setOauthToken(String oauthToken) {
        return (Search) super.setOauthToken(oauthToken);
      }

      @Override
      public Search setPrettyPrint(Boolean prettyPrint) {
        return (Search) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Search setQuotaUser(String quotaUser) {
        return (Search) super.setQuotaUser(quotaUser);
      }

      @Override
      public Search setUserIp(String userIp) {
        return (Search) super.setUserIp(userIp);
      }

      /** Specify a query string for full text search of public text in all profiles. */
      @com.google.api.client.util.Key
      private String query;

      /** Specify a query string for full text search of public text in all profiles.
       */
      public String getQuery() {
        return query;
      }

      /** Specify a query string for full text search of public text in all profiles. */
      public Search setQuery(String query) {
        this.query = query;
        return this;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     * This token can be of any length.
     */
      @com.google.api.client.util.Key
      private String pageToken;

      /** The continuation token, which is used to page through large result sets. To get the next page of
     results, set this parameter to the value of "nextPageToken" from the previous response. This token
     can be of any length.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
     * The continuation token, which is used to page through large result sets. To get the next page
     * of results, set this parameter to the value of "nextPageToken" from the previous response.
     * This token can be of any length.
     */
      public Search setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
     * The maximum number of people to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      @com.google.api.client.util.Key
      private Long maxResults;

      /** The maximum number of people to include in the response, which is used for paging. For any
     response, the actual number returned might be less than the specified maxResults. [default: 10]
     [minimum: 1] [maximum: 20]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
     * The maximum number of people to include in the response, which is used for paging. For any
     * response, the actual number returned might be less than the specified maxResults.
     */
      public Search setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
     * Specify the preferred language to search with. See search language codes for available
     * values.
     */
      @com.google.api.client.util.Key
      private String language;

      /** Specify the preferred language to search with. See search language codes for available values.
     [default: en-US]
       */
      public String getLanguage() {
        return language;
      }

      /**
     * Specify the preferred language to search with. See search language codes for available
     * values.
     */
      public Search setLanguage(String language) {
        this.language = language;
        return this;
      }

    }

  }

  /**
   * Builder for {@link Plus}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport
     * @param jsonFactory JSON factory
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(HttpTransport transport, JsonFactory jsonFactory,
        HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Plus}. */
    @Override
    public Plus build() {
      return new Plus(getTransport(),
          getHttpRequestInitializer(),
          getRootUrl(),
          getServicePath(),
          getObjectParser(),
          getGoogleClientRequestInitializer(),
          getApplicationName(),
          getSuppressPatternChecks());
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    /**
     * Set the {@link PlusRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setPlusRequestInitializer(
        PlusRequestInitializer plusRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(plusRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
