/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-04-15 19:10:39 UTC)
 * on 2014-04-16 at 23:20:56 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A collection of geographic features, and associated metadata.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Table extends com.google.api.client.json.GenericJson {

  /**
   * An array of four numbers (west, south, east, north) which define the rectangular bounding box
   * which contains all of the data in this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> bbox;

  /**
   * The creation time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime creationTime;

  /**
   * The description of this table, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The name of an access list of the Map Editor type. The user on whose behalf the request is
   * being sent must be an editor on that access list. Read About access lists in the Google Maps
   * Engine help center for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String draftAccessList;

  /**
   * The files associated with this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<File> files;

  static {
    // hack to force ProGuard to consider File used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(File.class);
  }

  /**
   * A globally unique ID, used to refer to this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The last modified time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastModifiedTime;

  /**
   * The name of this table, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The processing status of this table. The supported processing status values are:   - notReady:
   * The table is not ready to be processed - some files have not been uploaded.  - ready: The table
   * is queued for processing.  - processing: The table is currently processing.  - complete:
   * Processing has completed successfully.  - failed: Processing failed to complete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingStatus;

  /**
   * The ID of the project to which the table belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * The access list to whom view permissions are granted. The value must be the name of a Maps
   * Engine access list of the Map Viewer type, and the user must be a viewer on that list. Read
   * About access lists in the Google Maps Engine help center for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publishedAccessList;

  /**
   * The schema for this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Schema schema;

  /**
   * Encoding of the uploaded files. Valid values include UTF-8, CP1251, ISO 8859-1, and Shift_JIS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceEncoding;

  /**
   * An array of text strings, with each string representing a tag. More information about tags can
   * be found in the Tagging data article of the Maps Engine help center.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * An array of four numbers (west, south, east, north) which define the rectangular bounding box
   * which contains all of the data in this table.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getBbox() {
    return bbox;
  }

  /**
   * An array of four numbers (west, south, east, north) which define the rectangular bounding box
   * which contains all of the data in this table.
   * @param bbox bbox or {@code null} for none
   */
  public Table setBbox(java.util.List<java.lang.Double> bbox) {
    this.bbox = bbox;
    return this;
  }

  /**
   * The creation time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreationTime() {
    return creationTime;
  }

  /**
   * The creation time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param creationTime creationTime or {@code null} for none
   */
  public Table setCreationTime(com.google.api.client.util.DateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The description of this table, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this table, supplied by the author.
   * @param description description or {@code null} for none
   */
  public Table setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The name of an access list of the Map Editor type. The user on whose behalf the request is
   * being sent must be an editor on that access list. Read About access lists in the Google Maps
   * Engine help center for more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getDraftAccessList() {
    return draftAccessList;
  }

  /**
   * The name of an access list of the Map Editor type. The user on whose behalf the request is
   * being sent must be an editor on that access list. Read About access lists in the Google Maps
   * Engine help center for more information.
   * @param draftAccessList draftAccessList or {@code null} for none
   */
  public Table setDraftAccessList(java.lang.String draftAccessList) {
    this.draftAccessList = draftAccessList;
    return this;
  }

  /**
   * The files associated with this table.
   * @return value or {@code null} for none
   */
  public java.util.List<File> getFiles() {
    return files;
  }

  /**
   * The files associated with this table.
   * @param files files or {@code null} for none
   */
  public Table setFiles(java.util.List<File> files) {
    this.files = files;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this table.
   * @param id id or {@code null} for none
   */
  public Table setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The last modified time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The last modified time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Table setLastModifiedTime(com.google.api.client.util.DateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The name of this table, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this table, supplied by the author.
   * @param name name or {@code null} for none
   */
  public Table setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The processing status of this table. The supported processing status values are:   - notReady:
   * The table is not ready to be processed - some files have not been uploaded.  - ready: The table
   * is queued for processing.  - processing: The table is currently processing.  - complete:
   * Processing has completed successfully.  - failed: Processing failed to complete.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingStatus() {
    return processingStatus;
  }

  /**
   * The processing status of this table. The supported processing status values are:   - notReady:
   * The table is not ready to be processed - some files have not been uploaded.  - ready: The table
   * is queued for processing.  - processing: The table is currently processing.  - complete:
   * Processing has completed successfully.  - failed: Processing failed to complete.
   * @param processingStatus processingStatus or {@code null} for none
   */
  public Table setProcessingStatus(java.lang.String processingStatus) {
    this.processingStatus = processingStatus;
    return this;
  }

  /**
   * The ID of the project to which the table belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project to which the table belongs.
   * @param projectId projectId or {@code null} for none
   */
  public Table setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The access list to whom view permissions are granted. The value must be the name of a Maps
   * Engine access list of the Map Viewer type, and the user must be a viewer on that list. Read
   * About access lists in the Google Maps Engine help center for more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublishedAccessList() {
    return publishedAccessList;
  }

  /**
   * The access list to whom view permissions are granted. The value must be the name of a Maps
   * Engine access list of the Map Viewer type, and the user must be a viewer on that list. Read
   * About access lists in the Google Maps Engine help center for more information.
   * @param publishedAccessList publishedAccessList or {@code null} for none
   */
  public Table setPublishedAccessList(java.lang.String publishedAccessList) {
    this.publishedAccessList = publishedAccessList;
    return this;
  }

  /**
   * The schema for this table.
   * @return value or {@code null} for none
   */
  public Schema getSchema() {
    return schema;
  }

  /**
   * The schema for this table.
   * @param schema schema or {@code null} for none
   */
  public Table setSchema(Schema schema) {
    this.schema = schema;
    return this;
  }

  /**
   * Encoding of the uploaded files. Valid values include UTF-8, CP1251, ISO 8859-1, and Shift_JIS.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceEncoding() {
    return sourceEncoding;
  }

  /**
   * Encoding of the uploaded files. Valid values include UTF-8, CP1251, ISO 8859-1, and Shift_JIS.
   * @param sourceEncoding sourceEncoding or {@code null} for none
   */
  public Table setSourceEncoding(java.lang.String sourceEncoding) {
    this.sourceEncoding = sourceEncoding;
    return this;
  }

  /**
   * An array of text strings, with each string representing a tag. More information about tags can
   * be found in the Tagging data article of the Maps Engine help center.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * An array of text strings, with each string representing a tag. More information about tags can
   * be found in the Tagging data article of the Maps Engine help center.
   * @param tags tags or {@code null} for none
   */
  public Table setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public Table set(String fieldName, Object value) {
    return (Table) super.set(fieldName, value);
  }

  @Override
  public Table clone() {
    return (Table) super.clone();
  }

}
