/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2015-01-22 at 22:30:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A collection of geographic features, and associated metadata.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Table extends com.google.api.client.json.GenericJson {

  /**
   * A rectangular bounding box which contains all of the data in this Table. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitude and longitude in decimal
   * degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> bbox;

  /**
   * The creation time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime creationTime;

  /**
   * The email address of the creator of this table. This is only returned on GET requests and not
   * LIST requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creatorEmail;

  /**
   * The description of this table, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String draftAccessList;

  /**
   * The ETag, used to refer to the current version of the asset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The files associated with this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<File> files;

  /**
   * A globally unique ID, used to refer to this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The last modified time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastModifiedTime;

  /**
   * The email address of the last modifier of this table. This is only returned on GET requests and
   * not LIST requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastModifierEmail;

  /**
   * The name of this table, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The processing status of this table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingStatus;

  /**
   * The ID of the project to which the table belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Note: Google Maps Engine no longer uses access lists. Instead, each asset has its own list of
   * permissions. For backward compatibility, the API still accepts access lists for projects that
   * are already using access lists. If you created a GME account/project after July 14th, 2014, you
   * will not be able to send API requests that include access lists. Note: This is an input field
   * only. It is not returned in response to a list or get request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publishedAccessList;

  /**
   * The schema for this table. Note: The schema is returned in response to a get request but not a
   * list request. After requesting a list of tables, you'll need to send a get request to retrieve
   * the schema for each table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Schema schema;

  /**
   * Encoding of the uploaded files. Valid values include UTF-8, CP1251, ISO 8859-1, and Shift_JIS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceEncoding;

  /**
   * An array of text strings, with each string representing a tag. More information about tags can
   * be found in the Tagging data article of the Maps Engine help center.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean writersCanEditPermissions;

  /**
   * A rectangular bounding box which contains all of the data in this Table. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitude and longitude in decimal
   * degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getBbox() {
    return bbox;
  }

  /**
   * A rectangular bounding box which contains all of the data in this Table. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitude and longitude in decimal
   * degrees.
   * @param bbox bbox or {@code null} for none
   */
  public Table setBbox(java.util.List<java.lang.Double> bbox) {
    this.bbox = bbox;
    return this;
  }

  /**
   * The creation time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreationTime() {
    return creationTime;
  }

  /**
   * The creation time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param creationTime creationTime or {@code null} for none
   */
  public Table setCreationTime(com.google.api.client.util.DateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The email address of the creator of this table. This is only returned on GET requests and not
   * LIST requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreatorEmail() {
    return creatorEmail;
  }

  /**
   * The email address of the creator of this table. This is only returned on GET requests and not
   * LIST requests.
   * @param creatorEmail creatorEmail or {@code null} for none
   */
  public Table setCreatorEmail(java.lang.String creatorEmail) {
    this.creatorEmail = creatorEmail;
    return this;
  }

  /**
   * The description of this table, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this table, supplied by the author.
   * @param description description or {@code null} for none
   */
  public Table setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * @return value or {@code null} for none
   */
  public java.lang.String getDraftAccessList() {
    return draftAccessList;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * @param draftAccessList draftAccessList or {@code null} for none
   */
  public Table setDraftAccessList(java.lang.String draftAccessList) {
    this.draftAccessList = draftAccessList;
    return this;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @param etag etag or {@code null} for none
   */
  public Table setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The files associated with this table.
   * @return value or {@code null} for none
   */
  public java.util.List<File> getFiles() {
    return files;
  }

  /**
   * The files associated with this table.
   * @param files files or {@code null} for none
   */
  public Table setFiles(java.util.List<File> files) {
    this.files = files;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this table.
   * @param id id or {@code null} for none
   */
  public Table setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The last modified time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The last modified time of this table. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Table setLastModifiedTime(com.google.api.client.util.DateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The email address of the last modifier of this table. This is only returned on GET requests and
   * not LIST requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastModifierEmail() {
    return lastModifierEmail;
  }

  /**
   * The email address of the last modifier of this table. This is only returned on GET requests and
   * not LIST requests.
   * @param lastModifierEmail lastModifierEmail or {@code null} for none
   */
  public Table setLastModifierEmail(java.lang.String lastModifierEmail) {
    this.lastModifierEmail = lastModifierEmail;
    return this;
  }

  /**
   * The name of this table, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this table, supplied by the author.
   * @param name name or {@code null} for none
   */
  public Table setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The processing status of this table.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingStatus() {
    return processingStatus;
  }

  /**
   * The processing status of this table.
   * @param processingStatus processingStatus or {@code null} for none
   */
  public Table setProcessingStatus(java.lang.String processingStatus) {
    this.processingStatus = processingStatus;
    return this;
  }

  /**
   * The ID of the project to which the table belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project to which the table belongs.
   * @param projectId projectId or {@code null} for none
   */
  public Table setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Note: Google Maps Engine no longer uses access lists. Instead, each asset has its own list of
   * permissions. For backward compatibility, the API still accepts access lists for projects that
   * are already using access lists. If you created a GME account/project after July 14th, 2014, you
   * will not be able to send API requests that include access lists. Note: This is an input field
   * only. It is not returned in response to a list or get request.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublishedAccessList() {
    return publishedAccessList;
  }

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Note: Google Maps Engine no longer uses access lists. Instead, each asset has its own list of
   * permissions. For backward compatibility, the API still accepts access lists for projects that
   * are already using access lists. If you created a GME account/project after July 14th, 2014, you
   * will not be able to send API requests that include access lists. Note: This is an input field
   * only. It is not returned in response to a list or get request.
   * @param publishedAccessList publishedAccessList or {@code null} for none
   */
  public Table setPublishedAccessList(java.lang.String publishedAccessList) {
    this.publishedAccessList = publishedAccessList;
    return this;
  }

  /**
   * The schema for this table. Note: The schema is returned in response to a get request but not a
   * list request. After requesting a list of tables, you'll need to send a get request to retrieve
   * the schema for each table.
   * @return value or {@code null} for none
   */
  public Schema getSchema() {
    return schema;
  }

  /**
   * The schema for this table. Note: The schema is returned in response to a get request but not a
   * list request. After requesting a list of tables, you'll need to send a get request to retrieve
   * the schema for each table.
   * @param schema schema or {@code null} for none
   */
  public Table setSchema(Schema schema) {
    this.schema = schema;
    return this;
  }

  /**
   * Encoding of the uploaded files. Valid values include UTF-8, CP1251, ISO 8859-1, and Shift_JIS.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceEncoding() {
    return sourceEncoding;
  }

  /**
   * Encoding of the uploaded files. Valid values include UTF-8, CP1251, ISO 8859-1, and Shift_JIS.
   * @param sourceEncoding sourceEncoding or {@code null} for none
   */
  public Table setSourceEncoding(java.lang.String sourceEncoding) {
    this.sourceEncoding = sourceEncoding;
    return this;
  }

  /**
   * An array of text strings, with each string representing a tag. More information about tags can
   * be found in the Tagging data article of the Maps Engine help center.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * An array of text strings, with each string representing a tag. More information about tags can
   * be found in the Tagging data article of the Maps Engine help center.
   * @param tags tags or {@code null} for none
   */
  public Table setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWritersCanEditPermissions() {
    return writersCanEditPermissions;
  }

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * @param writersCanEditPermissions writersCanEditPermissions or {@code null} for none
   */
  public Table setWritersCanEditPermissions(java.lang.Boolean writersCanEditPermissions) {
    this.writersCanEditPermissions = writersCanEditPermissions;
    return this;
  }

  @Override
  public Table set(String fieldName, Object value) {
    return (Table) super.set(fieldName, value);
  }

  @Override
  public Table clone() {
    return (Table) super.clone();
  }

}
