/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2014-11-18 at 18:39:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Model definition for MapFolder.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MapFolder extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MapItem> contents;

  static {
    // hack to force ProGuard to consider MapItem used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(MapItem.class);
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> defaultViewport;

  /**
   * The expandability setting of this MapFolder. If true, the folder can be expanded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean expandable;

  /**
   * A user defined alias for this MapFolder, specific to this Map.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * The name of this MapFolder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The visibility setting of this MapFolder. One of "defaultOn" or "defaultOff".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visibility;

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<MapItem> getContents() {
    return contents;
  }

  /**
   * @param contents contents or {@code null} for none
   */
  public MapFolder setContents(java.util.List<MapItem> contents) {
    this.contents = contents;
    return this;
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getDefaultViewport() {
    return defaultViewport;
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @param defaultViewport defaultViewport or {@code null} for none
   */
  public MapFolder setDefaultViewport(java.util.List<java.lang.Double> defaultViewport) {
    this.defaultViewport = defaultViewport;
    return this;
  }

  /**
   * The expandability setting of this MapFolder. If true, the folder can be expanded.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExpandable() {
    return expandable;
  }

  /**
   * The expandability setting of this MapFolder. If true, the folder can be expanded.
   * @param expandable expandable or {@code null} for none
   */
  public MapFolder setExpandable(java.lang.Boolean expandable) {
    this.expandable = expandable;
    return this;
  }

  /**
   * A user defined alias for this MapFolder, specific to this Map.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * A user defined alias for this MapFolder, specific to this Map.
   * @param key key or {@code null} for none
   */
  public MapFolder setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * The name of this MapFolder.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this MapFolder.
   * @param name name or {@code null} for none
   */
  public MapFolder setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The visibility setting of this MapFolder. One of "defaultOn" or "defaultOff".
   * @return value or {@code null} for none
   */
  public java.lang.String getVisibility() {
    return visibility;
  }

  /**
   * The visibility setting of this MapFolder. One of "defaultOn" or "defaultOff".
   * @param visibility visibility or {@code null} for none
   */
  public MapFolder setVisibility(java.lang.String visibility) {
    this.visibility = visibility;
    return this;
  }

  @Override
  public MapFolder set(String fieldName, Object value) {
    return (MapFolder) super.set(fieldName, value);
  }

  @Override
  public MapFolder clone() {
    return (MapFolder) super.clone();
  }

}
