/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-21 at 23:01:51 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A permission defines the user or group that has access to an asset, and the type of access they
 * have.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Permission extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether a public asset is listed and can be found via a web search (value true), or
   * is visible only to people who have a link to the asset (value false).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean discoverable;

  /**
   * The unique identifier of the permission. This could be the email address of the user or group
   * this permission refers to, or the string "anyone" for public permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The type of access granted to this user or group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * The account type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Indicates whether a public asset is listed and can be found via a web search (value true), or
   * is visible only to people who have a link to the asset (value false).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDiscoverable() {
    return discoverable;
  }

  /**
   * Indicates whether a public asset is listed and can be found via a web search (value true), or
   * is visible only to people who have a link to the asset (value false).
   * @param discoverable discoverable or {@code null} for none
   */
  public Permission setDiscoverable(java.lang.Boolean discoverable) {
    this.discoverable = discoverable;
    return this;
  }

  /**
   * The unique identifier of the permission. This could be the email address of the user or group
   * this permission refers to, or the string "anyone" for public permissions.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The unique identifier of the permission. This could be the email address of the user or group
   * this permission refers to, or the string "anyone" for public permissions.
   * @param id id or {@code null} for none
   */
  public Permission setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The type of access granted to this user or group.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The type of access granted to this user or group.
   * @param role role or {@code null} for none
   */
  public Permission setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * The account type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The account type.
   * @param type type or {@code null} for none
   */
  public Permission setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Permission set(String fieldName, Object value) {
    return (Permission) super.set(fieldName, value);
  }

  @Override
  public Permission clone() {
    return (Permission) super.clone();
  }

}
