/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-20 at 10:55:45 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Model definition for MapLayer.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MapLayer extends MapItem {

  /** Constructs MapLayer. **/
  public MapLayer() {
    super("layer");
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> defaultViewport;

  /**
   * The ID of this MapLayer. This ID can be used to request more details about the layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A user defined alias for this MapLayer, specific to this Map.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String key;

  /**
   * The name of this MapLayer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The visibility setting of this MapLayer. One of "defaultOn" or "defaultOff".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visibility;

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getDefaultViewport() {
    return defaultViewport;
  }

  /**
   * An array of four numbers (west, south, east, north) which defines the rectangular bounding box
   * of the default viewport. The numbers represent latitude and longitude in decimal degrees.
   * @param defaultViewport defaultViewport or {@code null} for none
   */
  public MapLayer setDefaultViewport(java.util.List<java.lang.Double> defaultViewport) {
    this.defaultViewport = defaultViewport;
    return this;
  }

  /**
   * The ID of this MapLayer. This ID can be used to request more details about the layer.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of this MapLayer. This ID can be used to request more details about the layer.
   * @param id id or {@code null} for none
   */
  public MapLayer setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A user defined alias for this MapLayer, specific to this Map.
   * @return value or {@code null} for none
   */
  public java.lang.String getKey() {
    return key;
  }

  /**
   * A user defined alias for this MapLayer, specific to this Map.
   * @param key key or {@code null} for none
   */
  public MapLayer setKey(java.lang.String key) {
    this.key = key;
    return this;
  }

  /**
   * The name of this MapLayer.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this MapLayer.
   * @param name name or {@code null} for none
   */
  public MapLayer setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The visibility setting of this MapLayer. One of "defaultOn" or "defaultOff".
   * @return value or {@code null} for none
   */
  public java.lang.String getVisibility() {
    return visibility;
  }

  /**
   * The visibility setting of this MapLayer. One of "defaultOn" or "defaultOff".
   * @param visibility visibility or {@code null} for none
   */
  public MapLayer setVisibility(java.lang.String visibility) {
    this.visibility = visibility;
    return this;
  }

  @Override
  public MapLayer set(String fieldName, Object value) {
    return (MapLayer) super.set(fieldName, value);
  }

  @Override
  public MapLayer clone() {
    return (MapLayer) super.clone();
  }

}
