/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-20 at 10:55:45 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A Layer combines multiple datasources, with styling information, for presentation on a map.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Layer extends com.google.api.client.json.GenericJson {

  /**
   * A rectangular bounding box which contains all of the data in this Layer. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitude and longitude in decimal
   * degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> bbox;

  /**
   * The creation time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime creationTime;

  /**
   * The email address of the creator of this layer. This is only returned on GET requests and not
   * LIST requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creatorEmail;

  /**
   * Deprecated: The type of the datasources used to build this Layer. Note: This has been replaced
   * by layerType, but is still available for now to maintain backward compatibility.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String datasourceType;

  /**
   * An array of datasources used to build this layer. If layerType is "image", or layerType is not
   * specified and datasourceType is "image", then each element in this array is a reference to an
   * Image or RasterCollection. If layerType is "vector", or layerType is not specified and
   * datasourceType is "table" then each element in this array is a reference to a Vector Table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Datasource> datasources;

  /**
   * The description of this Layer, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String draftAccessList;

  /**
   * The ETag, used to refer to the current version of the asset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * A globally unique ID, used to refer to this Layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The last modified time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastModifiedTime;

  /**
   * The email address of the last modifier of this layer. This is only returned on GET requests and
   * not LIST requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastModifierEmail;

  /**
   * The type of the datasources used to build this Layer. This should be used instead of
   * datasourceType. At least one of layerType and datasourceType and must be specified, but
   * layerType takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String layerType;

  /**
   * The name of this Layer, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The processing status of this layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingStatus;

  /**
   * The ID of the project that this Layer is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Note: Google Maps Engine no longer uses access lists. Instead, each asset has its own list of
   * permissions. For backward compatibility, the API still accepts access lists for projects that
   * are already using access lists. If you created a GME account/project after July 14th, 2014, you
   * will not be able to send API requests that include access lists. Note: This is an input field
   * only. It is not returned in response to a list or get request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publishedAccessList;

  /**
   * The publishing status of this layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publishingStatus;

  /**
   * The styling information for a vector layer. Note: Style information is returned in response to
   * a get request but not a list request. After requesting a list of layers, you'll need to send a
   * get request to retrieve the VectorStyles for each layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VectorStyle style;

  /**
   * Tags of this Layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean writersCanEditPermissions;

  /**
   * A rectangular bounding box which contains all of the data in this Layer. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitude and longitude in decimal
   * degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getBbox() {
    return bbox;
  }

  /**
   * A rectangular bounding box which contains all of the data in this Layer. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitude and longitude in decimal
   * degrees.
   * @param bbox bbox or {@code null} for none
   */
  public Layer setBbox(java.util.List<java.lang.Double> bbox) {
    this.bbox = bbox;
    return this;
  }

  /**
   * The creation time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreationTime() {
    return creationTime;
  }

  /**
   * The creation time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param creationTime creationTime or {@code null} for none
   */
  public Layer setCreationTime(com.google.api.client.util.DateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The email address of the creator of this layer. This is only returned on GET requests and not
   * LIST requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreatorEmail() {
    return creatorEmail;
  }

  /**
   * The email address of the creator of this layer. This is only returned on GET requests and not
   * LIST requests.
   * @param creatorEmail creatorEmail or {@code null} for none
   */
  public Layer setCreatorEmail(java.lang.String creatorEmail) {
    this.creatorEmail = creatorEmail;
    return this;
  }

  /**
   * Deprecated: The type of the datasources used to build this Layer. Note: This has been replaced
   * by layerType, but is still available for now to maintain backward compatibility.
   * @return value or {@code null} for none
   */
  public java.lang.String getDatasourceType() {
    return datasourceType;
  }

  /**
   * Deprecated: The type of the datasources used to build this Layer. Note: This has been replaced
   * by layerType, but is still available for now to maintain backward compatibility.
   * @param datasourceType datasourceType or {@code null} for none
   */
  public Layer setDatasourceType(java.lang.String datasourceType) {
    this.datasourceType = datasourceType;
    return this;
  }

  /**
   * An array of datasources used to build this layer. If layerType is "image", or layerType is not
   * specified and datasourceType is "image", then each element in this array is a reference to an
   * Image or RasterCollection. If layerType is "vector", or layerType is not specified and
   * datasourceType is "table" then each element in this array is a reference to a Vector Table.
   * @return value or {@code null} for none
   */
  public java.util.List<Datasource> getDatasources() {
    return datasources;
  }

  /**
   * An array of datasources used to build this layer. If layerType is "image", or layerType is not
   * specified and datasourceType is "image", then each element in this array is a reference to an
   * Image or RasterCollection. If layerType is "vector", or layerType is not specified and
   * datasourceType is "table" then each element in this array is a reference to a Vector Table.
   * @param datasources datasources or {@code null} for none
   */
  public Layer setDatasources(java.util.List<Datasource> datasources) {
    this.datasources = datasources;
    return this;
  }

  /**
   * The description of this Layer, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this Layer, supplied by the author.
   * @param description description or {@code null} for none
   */
  public Layer setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * @return value or {@code null} for none
   */
  public java.lang.String getDraftAccessList() {
    return draftAccessList;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. Instead, each asset has its own list of permissions. For backward
   * compatibility, the API still accepts access lists for projects that are already using access
   * lists. If you created a GME account/project after July 14th, 2014, you will not be able to send
   * API requests that include access lists. Note: This is an input field only. It is not returned
   * in response to a list or get request.
   * @param draftAccessList draftAccessList or {@code null} for none
   */
  public Layer setDraftAccessList(java.lang.String draftAccessList) {
    this.draftAccessList = draftAccessList;
    return this;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @param etag etag or {@code null} for none
   */
  public Layer setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this Layer.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this Layer.
   * @param id id or {@code null} for none
   */
  public Layer setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The last modified time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The last modified time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Layer setLastModifiedTime(com.google.api.client.util.DateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The email address of the last modifier of this layer. This is only returned on GET requests and
   * not LIST requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastModifierEmail() {
    return lastModifierEmail;
  }

  /**
   * The email address of the last modifier of this layer. This is only returned on GET requests and
   * not LIST requests.
   * @param lastModifierEmail lastModifierEmail or {@code null} for none
   */
  public Layer setLastModifierEmail(java.lang.String lastModifierEmail) {
    this.lastModifierEmail = lastModifierEmail;
    return this;
  }

  /**
   * The type of the datasources used to build this Layer. This should be used instead of
   * datasourceType. At least one of layerType and datasourceType and must be specified, but
   * layerType takes precedence.
   * @return value or {@code null} for none
   */
  public java.lang.String getLayerType() {
    return layerType;
  }

  /**
   * The type of the datasources used to build this Layer. This should be used instead of
   * datasourceType. At least one of layerType and datasourceType and must be specified, but
   * layerType takes precedence.
   * @param layerType layerType or {@code null} for none
   */
  public Layer setLayerType(java.lang.String layerType) {
    this.layerType = layerType;
    return this;
  }

  /**
   * The name of this Layer, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this Layer, supplied by the author.
   * @param name name or {@code null} for none
   */
  public Layer setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The processing status of this layer.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingStatus() {
    return processingStatus;
  }

  /**
   * The processing status of this layer.
   * @param processingStatus processingStatus or {@code null} for none
   */
  public Layer setProcessingStatus(java.lang.String processingStatus) {
    this.processingStatus = processingStatus;
    return this;
  }

  /**
   * The ID of the project that this Layer is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project that this Layer is in.
   * @param projectId projectId or {@code null} for none
   */
  public Layer setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Note: Google Maps Engine no longer uses access lists. Instead, each asset has its own list of
   * permissions. For backward compatibility, the API still accepts access lists for projects that
   * are already using access lists. If you created a GME account/project after July 14th, 2014, you
   * will not be able to send API requests that include access lists. Note: This is an input field
   * only. It is not returned in response to a list or get request.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublishedAccessList() {
    return publishedAccessList;
  }

  /**
   * Deprecated: The access list to whom view permissions are granted. The value must be the name of
   * a Maps Engine access list of the Map Viewer type, and the user must be a viewer on that list.
   * Note: Google Maps Engine no longer uses access lists. Instead, each asset has its own list of
   * permissions. For backward compatibility, the API still accepts access lists for projects that
   * are already using access lists. If you created a GME account/project after July 14th, 2014, you
   * will not be able to send API requests that include access lists. Note: This is an input field
   * only. It is not returned in response to a list or get request.
   * @param publishedAccessList publishedAccessList or {@code null} for none
   */
  public Layer setPublishedAccessList(java.lang.String publishedAccessList) {
    this.publishedAccessList = publishedAccessList;
    return this;
  }

  /**
   * The publishing status of this layer.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublishingStatus() {
    return publishingStatus;
  }

  /**
   * The publishing status of this layer.
   * @param publishingStatus publishingStatus or {@code null} for none
   */
  public Layer setPublishingStatus(java.lang.String publishingStatus) {
    this.publishingStatus = publishingStatus;
    return this;
  }

  /**
   * The styling information for a vector layer. Note: Style information is returned in response to
   * a get request but not a list request. After requesting a list of layers, you'll need to send a
   * get request to retrieve the VectorStyles for each layer.
   * @return value or {@code null} for none
   */
  public VectorStyle getStyle() {
    return style;
  }

  /**
   * The styling information for a vector layer. Note: Style information is returned in response to
   * a get request but not a list request. After requesting a list of layers, you'll need to send a
   * get request to retrieve the VectorStyles for each layer.
   * @param style style or {@code null} for none
   */
  public Layer setStyle(VectorStyle style) {
    this.style = style;
    return this;
  }

  /**
   * Tags of this Layer.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * Tags of this Layer.
   * @param tags tags or {@code null} for none
   */
  public Layer setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWritersCanEditPermissions() {
    return writersCanEditPermissions;
  }

  /**
   * If true, WRITERs of the asset are able to edit the asset permissions.
   * @param writersCanEditPermissions writersCanEditPermissions or {@code null} for none
   */
  public Layer setWritersCanEditPermissions(java.lang.Boolean writersCanEditPermissions) {
    this.writersCanEditPermissions = writersCanEditPermissions;
    return this;
  }

  @Override
  public Layer set(String fieldName, Object value) {
    return (Layer) super.set(fieldName, value);
  }

  @Override
  public Layer clone() {
    return (Layer) super.clone();
  }

}
