/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-18 at 04:25:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A geo-referenced raster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Raster extends com.google.api.client.json.GenericJson {

  /**
   * The acquisition time of this Raster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AcquisitionTime acquisitionTime;

  /**
   * The name of the attribution to be used for this Raster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attribution;

  /**
   * A rectangular bounding box which contains all of the data in this Raster. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitudes and longitudes in decimal
   * degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> bbox;

  /**
   * The creation time of this raster. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime creationTime;

  /**
   * The email address of the creator of this raster. This is only returned on GET requests and not
   * LIST requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creatorEmail;

  /**
   * The description of this Raster, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. For backward compatibility, the API still accepts access lists for projects
   * that are already using access lists. If you created a GME account/project after July 14th,
   * 2014, you will not be able to send API requests that include access lists. The API does not yet
   * support the new permissions model. When you create a map via the API without specifying
   * permissions, the account that created the map is the owner and has effective administrator
   * access. Users can then use the Maps Engine user interface to adjust the permissions. This is a
   * temporary workaround until the API supports the new permissions model. Read Add new users and
   * groups in the Google Maps Engine help center for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String draftAccessList;

  /**
   * The ETag, used to refer to the current version of the asset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The files associated with this Raster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<File> files;

  /**
   * A globally unique ID, used to refer to this Raster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The last modified time of this raster. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastModifiedTime;

  /**
   * The email address of the last modifier of this raster. This is only returned on GET requests
   * and not LIST requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastModifierEmail;

  /**
   * The mask processing type of this Raster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maskType;

  /**
   * The name of this Raster, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The processing status of this Raster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processingStatus;

  /**
   * The ID of the project that this Raster is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * The type of this Raster. Always "image" today.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rasterType;

  /**
   * Tags of this Raster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * The acquisition time of this Raster.
   * @return value or {@code null} for none
   */
  public AcquisitionTime getAcquisitionTime() {
    return acquisitionTime;
  }

  /**
   * The acquisition time of this Raster.
   * @param acquisitionTime acquisitionTime or {@code null} for none
   */
  public Raster setAcquisitionTime(AcquisitionTime acquisitionTime) {
    this.acquisitionTime = acquisitionTime;
    return this;
  }

  /**
   * The name of the attribution to be used for this Raster.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttribution() {
    return attribution;
  }

  /**
   * The name of the attribution to be used for this Raster.
   * @param attribution attribution or {@code null} for none
   */
  public Raster setAttribution(java.lang.String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * A rectangular bounding box which contains all of the data in this Raster. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitudes and longitudes in decimal
   * degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getBbox() {
    return bbox;
  }

  /**
   * A rectangular bounding box which contains all of the data in this Raster. The box is expressed
   * as \"west, south, east, north\". The numbers represent latitudes and longitudes in decimal
   * degrees.
   * @param bbox bbox or {@code null} for none
   */
  public Raster setBbox(java.util.List<java.lang.Double> bbox) {
    this.bbox = bbox;
    return this;
  }

  /**
   * The creation time of this raster. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreationTime() {
    return creationTime;
  }

  /**
   * The creation time of this raster. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param creationTime creationTime or {@code null} for none
   */
  public Raster setCreationTime(com.google.api.client.util.DateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The email address of the creator of this raster. This is only returned on GET requests and not
   * LIST requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreatorEmail() {
    return creatorEmail;
  }

  /**
   * The email address of the creator of this raster. This is only returned on GET requests and not
   * LIST requests.
   * @param creatorEmail creatorEmail or {@code null} for none
   */
  public Raster setCreatorEmail(java.lang.String creatorEmail) {
    this.creatorEmail = creatorEmail;
    return this;
  }

  /**
   * The description of this Raster, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this Raster, supplied by the author.
   * @param description description or {@code null} for none
   */
  public Raster setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. For backward compatibility, the API still accepts access lists for projects
   * that are already using access lists. If you created a GME account/project after July 14th,
   * 2014, you will not be able to send API requests that include access lists. The API does not yet
   * support the new permissions model. When you create a map via the API without specifying
   * permissions, the account that created the map is the owner and has effective administrator
   * access. Users can then use the Maps Engine user interface to adjust the permissions. This is a
   * temporary workaround until the API supports the new permissions model. Read Add new users and
   * groups in the Google Maps Engine help center for more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getDraftAccessList() {
    return draftAccessList;
  }

  /**
   * Deprecated: The name of an access list of the Map Editor type. The user on whose behalf the
   * request is being sent must be an editor on that access list. Note: Google Maps Engine no longer
   * uses access lists. For backward compatibility, the API still accepts access lists for projects
   * that are already using access lists. If you created a GME account/project after July 14th,
   * 2014, you will not be able to send API requests that include access lists. The API does not yet
   * support the new permissions model. When you create a map via the API without specifying
   * permissions, the account that created the map is the owner and has effective administrator
   * access. Users can then use the Maps Engine user interface to adjust the permissions. This is a
   * temporary workaround until the API supports the new permissions model. Read Add new users and
   * groups in the Google Maps Engine help center for more information.
   * @param draftAccessList draftAccessList or {@code null} for none
   */
  public Raster setDraftAccessList(java.lang.String draftAccessList) {
    this.draftAccessList = draftAccessList;
    return this;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag, used to refer to the current version of the asset.
   * @param etag etag or {@code null} for none
   */
  public Raster setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The files associated with this Raster.
   * @return value or {@code null} for none
   */
  public java.util.List<File> getFiles() {
    return files;
  }

  /**
   * The files associated with this Raster.
   * @param files files or {@code null} for none
   */
  public Raster setFiles(java.util.List<File> files) {
    this.files = files;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this Raster.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this Raster.
   * @param id id or {@code null} for none
   */
  public Raster setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The last modified time of this raster. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The last modified time of this raster. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Raster setLastModifiedTime(com.google.api.client.util.DateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The email address of the last modifier of this raster. This is only returned on GET requests
   * and not LIST requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastModifierEmail() {
    return lastModifierEmail;
  }

  /**
   * The email address of the last modifier of this raster. This is only returned on GET requests
   * and not LIST requests.
   * @param lastModifierEmail lastModifierEmail or {@code null} for none
   */
  public Raster setLastModifierEmail(java.lang.String lastModifierEmail) {
    this.lastModifierEmail = lastModifierEmail;
    return this;
  }

  /**
   * The mask processing type of this Raster.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaskType() {
    return maskType;
  }

  /**
   * The mask processing type of this Raster.
   * @param maskType maskType or {@code null} for none
   */
  public Raster setMaskType(java.lang.String maskType) {
    this.maskType = maskType;
    return this;
  }

  /**
   * The name of this Raster, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this Raster, supplied by the author.
   * @param name name or {@code null} for none
   */
  public Raster setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The processing status of this Raster.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessingStatus() {
    return processingStatus;
  }

  /**
   * The processing status of this Raster.
   * @param processingStatus processingStatus or {@code null} for none
   */
  public Raster setProcessingStatus(java.lang.String processingStatus) {
    this.processingStatus = processingStatus;
    return this;
  }

  /**
   * The ID of the project that this Raster is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project that this Raster is in.
   * @param projectId projectId or {@code null} for none
   */
  public Raster setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The type of this Raster. Always "image" today.
   * @return value or {@code null} for none
   */
  public java.lang.String getRasterType() {
    return rasterType;
  }

  /**
   * The type of this Raster. Always "image" today.
   * @param rasterType rasterType or {@code null} for none
   */
  public Raster setRasterType(java.lang.String rasterType) {
    this.rasterType = rasterType;
    return this;
  }

  /**
   * Tags of this Raster.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * Tags of this Raster.
   * @param tags tags or {@code null} for none
   */
  public Raster setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public Raster set(String fieldName, Object value) {
    return (Raster) super.set(fieldName, value);
  }

  @Override
  public Raster clone() {
    return (Raster) super.clone();
  }

}
