/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-02-14 18:40:25 UTC)
 * on 2014-03-21 at 22:57:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A Layer combines multiple datasources, with styling information, for presentation on a map.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Layer extends com.google.api.client.json.GenericJson {

  /**
   * An array of four numbers (west, south, east, north) which define the rectangular bounding box
   * which contains all of the data in this Layer. The numbers represent latitudes and longitudes in
   * decimal degrees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Double> bbox;

  /**
   * The creation time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime creationTime;

  /**
   * The type of the datasources used to build this Layer. One of either "table" or "image".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String datasourceType;

  /**
   * An array of datasources used to build this Layer. If datasourceType is "image", then each
   * element in this array is a reference to an Image or RasterCollection. If datasourceType is
   * "table" then each element in this array is a reference to a Vector Table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Datasource> datasources;

  static {
    // hack to force ProGuard to consider Datasource used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Datasource.class);
  }

  /**
   * The description of this Layer, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A globally unique ID, used to refer to this Layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The last modified time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastModifiedTime;

  /**
   * The name of this Layer, supplied by the author.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ID of the project that this Layer is in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Tags of this Layer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * An array of four numbers (west, south, east, north) which define the rectangular bounding box
   * which contains all of the data in this Layer. The numbers represent latitudes and longitudes in
   * decimal degrees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Double> getBbox() {
    return bbox;
  }

  /**
   * An array of four numbers (west, south, east, north) which define the rectangular bounding box
   * which contains all of the data in this Layer. The numbers represent latitudes and longitudes in
   * decimal degrees.
   * @param bbox bbox or {@code null} for none
   */
  public Layer setBbox(java.util.List<java.lang.Double> bbox) {
    this.bbox = bbox;
    return this;
  }

  /**
   * The creation time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreationTime() {
    return creationTime;
  }

  /**
   * The creation time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param creationTime creationTime or {@code null} for none
   */
  public Layer setCreationTime(com.google.api.client.util.DateTime creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * The type of the datasources used to build this Layer. One of either "table" or "image".
   * @return value or {@code null} for none
   */
  public java.lang.String getDatasourceType() {
    return datasourceType;
  }

  /**
   * The type of the datasources used to build this Layer. One of either "table" or "image".
   * @param datasourceType datasourceType or {@code null} for none
   */
  public Layer setDatasourceType(java.lang.String datasourceType) {
    this.datasourceType = datasourceType;
    return this;
  }

  /**
   * An array of datasources used to build this Layer. If datasourceType is "image", then each
   * element in this array is a reference to an Image or RasterCollection. If datasourceType is
   * "table" then each element in this array is a reference to a Vector Table.
   * @return value or {@code null} for none
   */
  public java.util.List<Datasource> getDatasources() {
    return datasources;
  }

  /**
   * An array of datasources used to build this Layer. If datasourceType is "image", then each
   * element in this array is a reference to an Image or RasterCollection. If datasourceType is
   * "table" then each element in this array is a reference to a Vector Table.
   * @param datasources datasources or {@code null} for none
   */
  public Layer setDatasources(java.util.List<Datasource> datasources) {
    this.datasources = datasources;
    return this;
  }

  /**
   * The description of this Layer, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this Layer, supplied by the author.
   * @param description description or {@code null} for none
   */
  public Layer setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A globally unique ID, used to refer to this Layer.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A globally unique ID, used to refer to this Layer.
   * @param id id or {@code null} for none
   */
  public Layer setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The last modified time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * The last modified time of this layer. The value is an RFC 3339 formatted date-time value (e.g.
   * 1970-01-01T00:00:00Z).
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Layer setLastModifiedTime(com.google.api.client.util.DateTime lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The name of this Layer, supplied by the author.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this Layer, supplied by the author.
   * @param name name or {@code null} for none
   */
  public Layer setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ID of the project that this Layer is in.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * The ID of the project that this Layer is in.
   * @param projectId projectId or {@code null} for none
   */
  public Layer setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Tags of this Layer.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * Tags of this Layer.
   * @param tags tags or {@code null} for none
   */
  public Layer setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public Layer set(String fieldName, Object value) {
    return (Layer) super.set(fieldName, value);
  }

  @Override
  public Layer clone() {
    return (Layer) super.clone();
  }

}
