/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-02 at 07:19:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * A schema indicating the properties which may be associated with features within a Table, and the
 * types of those properties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Schema extends com.google.api.client.json.GenericJson {

  /**
   * An array of TableColumn objects. The first object in the array must be named geometry and be of
   * type points, lineStrings, polygons, or mixedGeometry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TableColumn> columns;

  static {
    // hack to force ProGuard to consider TableColumn used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(TableColumn.class);
  }

  /**
   * The name of the column that contains a feature's geometry. This field can be omitted during
   * table create; Google Maps Engine supports only a single geometry column, which must be named
   * geometry and be the first object in the columns array.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String primaryGeometry;

  /**
   * The name of the column that contains the unique identifier of a Feature.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String primaryKey;

  /**
   * An array of TableColumn objects. The first object in the array must be named geometry and be of
   * type points, lineStrings, polygons, or mixedGeometry.
   * @return value or {@code null} for none
   */
  public java.util.List<TableColumn> getColumns() {
    return columns;
  }

  /**
   * An array of TableColumn objects. The first object in the array must be named geometry and be of
   * type points, lineStrings, polygons, or mixedGeometry.
   * @param columns columns or {@code null} for none
   */
  public Schema setColumns(java.util.List<TableColumn> columns) {
    this.columns = columns;
    return this;
  }

  /**
   * The name of the column that contains a feature's geometry. This field can be omitted during
   * table create; Google Maps Engine supports only a single geometry column, which must be named
   * geometry and be the first object in the columns array.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrimaryGeometry() {
    return primaryGeometry;
  }

  /**
   * The name of the column that contains a feature's geometry. This field can be omitted during
   * table create; Google Maps Engine supports only a single geometry column, which must be named
   * geometry and be the first object in the columns array.
   * @param primaryGeometry primaryGeometry or {@code null} for none
   */
  public Schema setPrimaryGeometry(java.lang.String primaryGeometry) {
    this.primaryGeometry = primaryGeometry;
    return this;
  }

  /**
   * The name of the column that contains the unique identifier of a Feature.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrimaryKey() {
    return primaryKey;
  }

  /**
   * The name of the column that contains the unique identifier of a Feature.
   * @param primaryKey primaryKey or {@code null} for none
   */
  public Schema setPrimaryKey(java.lang.String primaryKey) {
    this.primaryKey = primaryKey;
    return this;
  }

  @Override
  public Schema set(String fieldName, Object value) {
    return (Schema) super.set(fieldName, value);
  }

  @Override
  public Schema clone() {
    return (Schema) super.clone();
  }

}
