/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-10 at 05:15:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mapsengine.model;

/**
 * Style for polygons.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Maps Engine API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PolygonStyle extends com.google.api.client.json.GenericJson {

  /**
   * Fill color of the polygon. If not provided, the polygon will be transparent and not visible if
   * there is no border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color fill;

  /**
   * Border of the polygon. 0 < border.width <= 10.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border stroke;

  /**
   * Fill color of the polygon. If not provided, the polygon will be transparent and not visible if
   * there is no border.
   * @return value or {@code null} for none
   */
  public Color getFill() {
    return fill;
  }

  /**
   * Fill color of the polygon. If not provided, the polygon will be transparent and not visible if
   * there is no border.
   * @param fill fill or {@code null} for none
   */
  public PolygonStyle setFill(Color fill) {
    this.fill = fill;
    return this;
  }

  /**
   * Border of the polygon. 0 < border.width <= 10.
   * @return value or {@code null} for none
   */
  public Border getStroke() {
    return stroke;
  }

  /**
   * Border of the polygon. 0 < border.width <= 10.
   * @param stroke stroke or {@code null} for none
   */
  public PolygonStyle setStroke(Border stroke) {
    this.stroke = stroke;
    return this;
  }

  @Override
  public PolygonStyle set(String fieldName, Object value) {
    return (PolygonStyle) super.set(fieldName, value);
  }

  @Override
  public PolygonStyle clone() {
    return (PolygonStyle) super.clone();
  }

}
