/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * A Template represents a complete configuration for a Deployment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Template extends com.google.api.client.json.GenericJson {

  /**
   * Action definitions for use in Module intents in this Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, Action> actions;

  static {
    // hack to force ProGuard to consider Action used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Action.class);
  }

  /**
   * A user-supplied description of this Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A list of modules for this Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, Module> modules;

  static {
    // hack to force ProGuard to consider Module used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Module.class);
  }

  /**
   * Name of this Template. The name must conform to the expression: [a-zA-Z0-9-_]{1,64}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Action definitions for use in Module intents in this Template.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, Action> getActions() {
    return actions;
  }

  /**
   * Action definitions for use in Module intents in this Template.
   * @param actions actions or {@code null} for none
   */
  public Template setActions(java.util.Map<String, Action> actions) {
    this.actions = actions;
    return this;
  }

  /**
   * A user-supplied description of this Template.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A user-supplied description of this Template.
   * @param description description or {@code null} for none
   */
  public Template setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A list of modules for this Template.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, Module> getModules() {
    return modules;
  }

  /**
   * A list of modules for this Template.
   * @param modules modules or {@code null} for none
   */
  public Template setModules(java.util.Map<String, Module> modules) {
    this.modules = modules;
    return this;
  }

  /**
   * Name of this Template. The name must conform to the expression: [a-zA-Z0-9-_]{1,64}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this Template. The name must conform to the expression: [a-zA-Z0-9-_]{1,64}
   * @param name name or {@code null} for none
   */
  public Template setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public Template set(String fieldName, Object value) {
    return (Template) super.set(fieldName, value);
  }

  @Override
  public Template clone() {
    return (Template) super.clone();
  }

}
