/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * Configuration information for a ReplicaPools v1beta1 API resource. Directly maps to ReplicaPool
 * InitTemplate.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplicaPoolParamsV1Beta1 extends com.google.api.client.json.GenericJson {

  /**
   * Whether these replicas should be restarted if they experience a failure. The default value is
   * true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoRestart;

  /**
   * The base name for instances within this ReplicaPool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String baseInstanceName;

  /**
   * Enables IP Forwarding
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canIpForward;

  /**
   * An optional textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A list of existing Persistent Disk resources to attach to each replica in the pool. Each disk
   * will be attached in read-only mode to every replica.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ExistingDisk> disksToAttach;

  static {
    // hack to force ProGuard to consider ExistingDisk used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ExistingDisk.class);
  }

  /**
   * A list of Disk resources to create and attach to each Replica in the Pool. Currently, you can
   * only define one disk and it must be a root persistent disk. Note that Replica Pool will create
   * a root persistent disk for each replica.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NewDisk> disksToCreate;

  static {
    // hack to force ProGuard to consider NewDisk used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(NewDisk.class);
  }

  /**
   * Name of the Action to be run during initialization of a ReplicaPoolModule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String initAction;

  /**
   * The machine type for this instance. Either a complete URL, or the resource name (e.g.
   * n1-standard-1).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * The metadata key/value pairs assigned to this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * A list of network interfaces for the instance. Currently only one interface is supported by
   * Google Compute Engine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkInterface> networkInterfaces;

  static {
    // hack to force ProGuard to consider NetworkInterface used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(NetworkInterface.class);
  }

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String onHostMaintenance;

  /**
   * A list of Service Accounts to enable for this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceAccount> serviceAccounts;

  /**
   * A list of tags to apply to the Google Compute Engine instance to identify resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Tag tags;

  /**
   * The zone for this ReplicaPool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Whether these replicas should be restarted if they experience a failure. The default value is
   * true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoRestart() {
    return autoRestart;
  }

  /**
   * Whether these replicas should be restarted if they experience a failure. The default value is
   * true.
   * @param autoRestart autoRestart or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setAutoRestart(java.lang.Boolean autoRestart) {
    this.autoRestart = autoRestart;
    return this;
  }

  /**
   * The base name for instances within this ReplicaPool.
   * @return value or {@code null} for none
   */
  public java.lang.String getBaseInstanceName() {
    return baseInstanceName;
  }

  /**
   * The base name for instances within this ReplicaPool.
   * @param baseInstanceName baseInstanceName or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setBaseInstanceName(java.lang.String baseInstanceName) {
    this.baseInstanceName = baseInstanceName;
    return this;
  }

  /**
   * Enables IP Forwarding
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanIpForward() {
    return canIpForward;
  }

  /**
   * Enables IP Forwarding
   * @param canIpForward canIpForward or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setCanIpForward(java.lang.Boolean canIpForward) {
    this.canIpForward = canIpForward;
    return this;
  }

  /**
   * An optional textual description of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource.
   * @param description description or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A list of existing Persistent Disk resources to attach to each replica in the pool. Each disk
   * will be attached in read-only mode to every replica.
   * @return value or {@code null} for none
   */
  public java.util.List<ExistingDisk> getDisksToAttach() {
    return disksToAttach;
  }

  /**
   * A list of existing Persistent Disk resources to attach to each replica in the pool. Each disk
   * will be attached in read-only mode to every replica.
   * @param disksToAttach disksToAttach or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setDisksToAttach(java.util.List<ExistingDisk> disksToAttach) {
    this.disksToAttach = disksToAttach;
    return this;
  }

  /**
   * A list of Disk resources to create and attach to each Replica in the Pool. Currently, you can
   * only define one disk and it must be a root persistent disk. Note that Replica Pool will create
   * a root persistent disk for each replica.
   * @return value or {@code null} for none
   */
  public java.util.List<NewDisk> getDisksToCreate() {
    return disksToCreate;
  }

  /**
   * A list of Disk resources to create and attach to each Replica in the Pool. Currently, you can
   * only define one disk and it must be a root persistent disk. Note that Replica Pool will create
   * a root persistent disk for each replica.
   * @param disksToCreate disksToCreate or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setDisksToCreate(java.util.List<NewDisk> disksToCreate) {
    this.disksToCreate = disksToCreate;
    return this;
  }

  /**
   * Name of the Action to be run during initialization of a ReplicaPoolModule.
   * @return value or {@code null} for none
   */
  public java.lang.String getInitAction() {
    return initAction;
  }

  /**
   * Name of the Action to be run during initialization of a ReplicaPoolModule.
   * @param initAction initAction or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setInitAction(java.lang.String initAction) {
    this.initAction = initAction;
    return this;
  }

  /**
   * The machine type for this instance. Either a complete URL, or the resource name (e.g.
   * n1-standard-1).
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * The machine type for this instance. Either a complete URL, or the resource name (e.g.
   * n1-standard-1).
   * @param machineType machineType or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * The metadata key/value pairs assigned to this instance.
   * @return value or {@code null} for none
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The metadata key/value pairs assigned to this instance.
   * @param metadata metadata or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * A list of network interfaces for the instance. Currently only one interface is supported by
   * Google Compute Engine.
   * @return value or {@code null} for none
   */
  public java.util.List<NetworkInterface> getNetworkInterfaces() {
    return networkInterfaces;
  }

  /**
   * A list of network interfaces for the instance. Currently only one interface is supported by
   * Google Compute Engine.
   * @param networkInterfaces networkInterfaces or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setNetworkInterfaces(java.util.List<NetworkInterface> networkInterfaces) {
    this.networkInterfaces = networkInterfaces;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getOnHostMaintenance() {
    return onHostMaintenance;
  }

  /**
   * @param onHostMaintenance onHostMaintenance or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setOnHostMaintenance(java.lang.String onHostMaintenance) {
    this.onHostMaintenance = onHostMaintenance;
    return this;
  }

  /**
   * A list of Service Accounts to enable for this instance.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceAccount> getServiceAccounts() {
    return serviceAccounts;
  }

  /**
   * A list of Service Accounts to enable for this instance.
   * @param serviceAccounts serviceAccounts or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setServiceAccounts(java.util.List<ServiceAccount> serviceAccounts) {
    this.serviceAccounts = serviceAccounts;
    return this;
  }

  /**
   * A list of tags to apply to the Google Compute Engine instance to identify resources.
   * @return value or {@code null} for none
   */
  public Tag getTags() {
    return tags;
  }

  /**
   * A list of tags to apply to the Google Compute Engine instance to identify resources.
   * @param tags tags or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setTags(Tag tags) {
    this.tags = tags;
    return this;
  }

  /**
   * The zone for this ReplicaPool.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * The zone for this ReplicaPool.
   * @param zone zone or {@code null} for none
   */
  public ReplicaPoolParamsV1Beta1 setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public ReplicaPoolParamsV1Beta1 set(String fieldName, Object value) {
    return (ReplicaPoolParamsV1Beta1) super.set(fieldName, value);
  }

  @Override
  public ReplicaPoolParamsV1Beta1 clone() {
    return (ReplicaPoolParamsV1Beta1) super.clone();
  }

}
