/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * A Firewall resource
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FirewallModule extends com.google.api.client.json.GenericJson {

  /**
   * The allowed ports or port ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AllowedRule> allowed;

  static {
    // hack to force ProGuard to consider AllowedRule used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AllowedRule.class);
  }

  /**
   * The description of the firewall (optional)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The NetworkModule to which this firewall should apply. If not specified, or if specified as
   * 'default', this firewall will be applied to the 'default' network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Source IP ranges to apply this firewall to, see the GCE Spec for details on syntax
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sourceRanges;

  /**
   * Source Tags to apply this firewall to, see the GCE Spec for details on syntax
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sourceTags;

  /**
   * Target Tags to apply this firewall to, see the GCE Spec for details on syntax
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetTags;

  /**
   * The allowed ports or port ranges.
   * @return value or {@code null} for none
   */
  public java.util.List<AllowedRule> getAllowed() {
    return allowed;
  }

  /**
   * The allowed ports or port ranges.
   * @param allowed allowed or {@code null} for none
   */
  public FirewallModule setAllowed(java.util.List<AllowedRule> allowed) {
    this.allowed = allowed;
    return this;
  }

  /**
   * The description of the firewall (optional)
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of the firewall (optional)
   * @param description description or {@code null} for none
   */
  public FirewallModule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The NetworkModule to which this firewall should apply. If not specified, or if specified as
   * 'default', this firewall will be applied to the 'default' network.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * The NetworkModule to which this firewall should apply. If not specified, or if specified as
   * 'default', this firewall will be applied to the 'default' network.
   * @param network network or {@code null} for none
   */
  public FirewallModule setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * Source IP ranges to apply this firewall to, see the GCE Spec for details on syntax
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSourceRanges() {
    return sourceRanges;
  }

  /**
   * Source IP ranges to apply this firewall to, see the GCE Spec for details on syntax
   * @param sourceRanges sourceRanges or {@code null} for none
   */
  public FirewallModule setSourceRanges(java.util.List<java.lang.String> sourceRanges) {
    this.sourceRanges = sourceRanges;
    return this;
  }

  /**
   * Source Tags to apply this firewall to, see the GCE Spec for details on syntax
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSourceTags() {
    return sourceTags;
  }

  /**
   * Source Tags to apply this firewall to, see the GCE Spec for details on syntax
   * @param sourceTags sourceTags or {@code null} for none
   */
  public FirewallModule setSourceTags(java.util.List<java.lang.String> sourceTags) {
    this.sourceTags = sourceTags;
    return this;
  }

  /**
   * Target Tags to apply this firewall to, see the GCE Spec for details on syntax
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetTags() {
    return targetTags;
  }

  /**
   * Target Tags to apply this firewall to, see the GCE Spec for details on syntax
   * @param targetTags targetTags or {@code null} for none
   */
  public FirewallModule setTargetTags(java.util.List<java.lang.String> targetTags) {
    this.targetTags = targetTags;
    return this;
  }

  @Override
  public FirewallModule set(String fieldName, Object value) {
    return (FirewallModule) super.set(fieldName, value);
  }

  @Override
  public FirewallModule clone() {
    return (FirewallModule) super.clone();
  }

}
