/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:59:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.manager.model;

/**
 * A deployment represents a physical instantiation of a Template.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Deployment Manager API. For a detailed explanation
 * see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Deployment extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The time when this deployment was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationDate;

  /**
   * A user-supplied description of this Deployment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] List of status for the modules in this deployment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ModuleStatus> modules;

  /**
   * Name of this deployment. The name must conform to the following regular expression:
   * [a-zA-Z0-9-_]{1,64}
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The set of parameter overrides to apply to the corresponding Template before deploying.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParamOverride> overrides;

  /**
   * [Output Only] Current status of this deployment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeployState state;

  /**
   * The name of the Template on which this deployment is based.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String templateName;

  /**
   * [Output Only] The time when this deployment was created.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationDate() {
    return creationDate;
  }

  /**
   * [Output Only] The time when this deployment was created.
   * @param creationDate creationDate or {@code null} for none
   */
  public Deployment setCreationDate(java.lang.String creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * A user-supplied description of this Deployment.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A user-supplied description of this Deployment.
   * @param description description or {@code null} for none
   */
  public Deployment setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] List of status for the modules in this deployment.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ModuleStatus> getModules() {
    return modules;
  }

  /**
   * [Output Only] List of status for the modules in this deployment.
   * @param modules modules or {@code null} for none
   */
  public Deployment setModules(java.util.Map<String, ModuleStatus> modules) {
    this.modules = modules;
    return this;
  }

  /**
   * Name of this deployment. The name must conform to the following regular expression:
   * [a-zA-Z0-9-_]{1,64}
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this deployment. The name must conform to the following regular expression:
   * [a-zA-Z0-9-_]{1,64}
   * @param name name or {@code null} for none
   */
  public Deployment setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The set of parameter overrides to apply to the corresponding Template before deploying.
   * @return value or {@code null} for none
   */
  public java.util.List<ParamOverride> getOverrides() {
    return overrides;
  }

  /**
   * The set of parameter overrides to apply to the corresponding Template before deploying.
   * @param overrides overrides or {@code null} for none
   */
  public Deployment setOverrides(java.util.List<ParamOverride> overrides) {
    this.overrides = overrides;
    return this;
  }

  /**
   * [Output Only] Current status of this deployment.
   * @return value or {@code null} for none
   */
  public DeployState getState() {
    return state;
  }

  /**
   * [Output Only] Current status of this deployment.
   * @param state state or {@code null} for none
   */
  public Deployment setState(DeployState state) {
    this.state = state;
    return this;
  }

  /**
   * The name of the Template on which this deployment is based.
   * @return value or {@code null} for none
   */
  public java.lang.String getTemplateName() {
    return templateName;
  }

  /**
   * The name of the Template on which this deployment is based.
   * @param templateName templateName or {@code null} for none
   */
  public Deployment setTemplateName(java.lang.String templateName) {
    this.templateName = templateName;
    return this;
  }

  @Override
  public Deployment set(String fieldName, Object value) {
    return (Deployment) super.set(fieldName, value);
  }

  @Override
  public Deployment clone() {
    return (Deployment) super.clone();
  }

}
