/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Respone of uploading accounts in batch.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UploadAccountResponse extends com.google.api.client.json.GenericJson {

  /**
   * The error encountered while processing the account info.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Error> error;

  static {
    // hack to force ProGuard to consider Error used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Error.class);
  }

  /**
   * The fixed string "identitytoolkit#UploadAccountResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The error encountered while processing the account info.
   * @return value or {@code null} for none
   */
  public java.util.List<Error> getError() {
    return error;
  }

  /**
   * The error encountered while processing the account info.
   * @param error error or {@code null} for none
   */
  public UploadAccountResponse setError(java.util.List<Error> error) {
    this.error = error;
    return this;
  }

  /**
   * The fixed string "identitytoolkit#UploadAccountResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string "identitytoolkit#UploadAccountResponse".
   * @param kind kind or {@code null} for none
   */
  public UploadAccountResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public UploadAccountResponse set(String fieldName, Object value) {
    return (UploadAccountResponse) super.set(fieldName, value);
  }

  @Override
  public UploadAccountResponse clone() {
    return (UploadAccountResponse) super.clone();
  }

  /**
   * Model definition for UploadAccountResponseError.
   */
  public static final class Error extends com.google.api.client.json.GenericJson {

    /**
     * The index of the malformed account, starting from 0.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer index;

    /**
     * Detailed error message for the account info.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String message;

    /**
     * The index of the malformed account, starting from 0.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getIndex() {
      return index;
    }

    /**
     * The index of the malformed account, starting from 0.
     * @param index index or {@code null} for none
     */
    public Error setIndex(java.lang.Integer index) {
      this.index = index;
      return this;
    }

    /**
     * Detailed error message for the account info.
     * @return value or {@code null} for none
     */
    public java.lang.String getMessage() {
      return message;
    }

    /**
     * Detailed error message for the account info.
     * @param message message or {@code null} for none
     */
    public Error setMessage(java.lang.String message) {
      this.message = message;
      return this;
    }

    @Override
    public Error set(String fieldName, Object value) {
      return (Error) super.set(fieldName, value);
    }

    @Override
    public Error clone() {
      return (Error) super.clone();
    }

  }

}
