/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Respone of setting the account information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SetAccountInfoResponse extends com.google.api.client.json.GenericJson {

  /**
   * The name of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The email of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * If email has been verified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean emailVerified;

  /**
   * If idToken is STS id token, then this field will be expiration time of STS id token in seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expiresIn;

  /**
   * The Gitkit id token to login the newly sign up user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idToken;

  /**
   * The fixed string "identitytoolkit#SetAccountInfoResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The local ID of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localId;

  /**
   * The new email the user attempts to change to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String newEmail;

  /**
   * The user's hashed password.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String passwordHash;

  /**
   * The photo url of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String photoUrl;

  /**
   * The user's profiles at the associated IdPs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProviderUserInfo> providerUserInfo;

  static {
    // hack to force ProGuard to consider ProviderUserInfo used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ProviderUserInfo.class);
  }

  /**
   * If idToken is STS id token, then this field will be refresh token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String refreshToken;

  /**
   * The name of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The name of the user.
   * @param displayName displayName or {@code null} for none
   */
  public SetAccountInfoResponse setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The email of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email of the user.
   * @param email email or {@code null} for none
   */
  public SetAccountInfoResponse setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * If email has been verified.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmailVerified() {
    return emailVerified;
  }

  /**
   * If email has been verified.
   * @param emailVerified emailVerified or {@code null} for none
   */
  public SetAccountInfoResponse setEmailVerified(java.lang.Boolean emailVerified) {
    this.emailVerified = emailVerified;
    return this;
  }

  /**
   * If idToken is STS id token, then this field will be expiration time of STS id token in seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpiresIn() {
    return expiresIn;
  }

  /**
   * If idToken is STS id token, then this field will be expiration time of STS id token in seconds.
   * @param expiresIn expiresIn or {@code null} for none
   */
  public SetAccountInfoResponse setExpiresIn(java.lang.Long expiresIn) {
    this.expiresIn = expiresIn;
    return this;
  }

  /**
   * The Gitkit id token to login the newly sign up user.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdToken() {
    return idToken;
  }

  /**
   * The Gitkit id token to login the newly sign up user.
   * @param idToken idToken or {@code null} for none
   */
  public SetAccountInfoResponse setIdToken(java.lang.String idToken) {
    this.idToken = idToken;
    return this;
  }

  /**
   * The fixed string "identitytoolkit#SetAccountInfoResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string "identitytoolkit#SetAccountInfoResponse".
   * @param kind kind or {@code null} for none
   */
  public SetAccountInfoResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The local ID of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalId() {
    return localId;
  }

  /**
   * The local ID of the user.
   * @param localId localId or {@code null} for none
   */
  public SetAccountInfoResponse setLocalId(java.lang.String localId) {
    this.localId = localId;
    return this;
  }

  /**
   * The new email the user attempts to change to.
   * @return value or {@code null} for none
   */
  public java.lang.String getNewEmail() {
    return newEmail;
  }

  /**
   * The new email the user attempts to change to.
   * @param newEmail newEmail or {@code null} for none
   */
  public SetAccountInfoResponse setNewEmail(java.lang.String newEmail) {
    this.newEmail = newEmail;
    return this;
  }

  /**
   * The user's hashed password.
   * @see #decodePasswordHash()
   * @return value or {@code null} for none
   */
  public java.lang.String getPasswordHash() {
    return passwordHash;
  }

  /**
   * The user's hashed password.
   * @see #getPasswordHash()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodePasswordHash() {
    return com.google.api.client.util.Base64.decodeBase64(passwordHash);
  }

  /**
   * The user's hashed password.
   * @see #encodePasswordHash()
   * @param passwordHash passwordHash or {@code null} for none
   */
  public SetAccountInfoResponse setPasswordHash(java.lang.String passwordHash) {
    this.passwordHash = passwordHash;
    return this;
  }

  /**
   * The user's hashed password.
   * @see #setPasswordHash()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public SetAccountInfoResponse encodePasswordHash(byte[] passwordHash) {
    this.passwordHash = com.google.api.client.util.Base64.encodeBase64URLSafeString(passwordHash);
    return this;
  }

  /**
   * The photo url of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhotoUrl() {
    return photoUrl;
  }

  /**
   * The photo url of the user.
   * @param photoUrl photoUrl or {@code null} for none
   */
  public SetAccountInfoResponse setPhotoUrl(java.lang.String photoUrl) {
    this.photoUrl = photoUrl;
    return this;
  }

  /**
   * The user's profiles at the associated IdPs.
   * @return value or {@code null} for none
   */
  public java.util.List<ProviderUserInfo> getProviderUserInfo() {
    return providerUserInfo;
  }

  /**
   * The user's profiles at the associated IdPs.
   * @param providerUserInfo providerUserInfo or {@code null} for none
   */
  public SetAccountInfoResponse setProviderUserInfo(java.util.List<ProviderUserInfo> providerUserInfo) {
    this.providerUserInfo = providerUserInfo;
    return this;
  }

  /**
   * If idToken is STS id token, then this field will be refresh token.
   * @return value or {@code null} for none
   */
  public java.lang.String getRefreshToken() {
    return refreshToken;
  }

  /**
   * If idToken is STS id token, then this field will be refresh token.
   * @param refreshToken refreshToken or {@code null} for none
   */
  public SetAccountInfoResponse setRefreshToken(java.lang.String refreshToken) {
    this.refreshToken = refreshToken;
    return this;
  }

  @Override
  public SetAccountInfoResponse set(String fieldName, Object value) {
    return (SetAccountInfoResponse) super.set(fieldName, value);
  }

  @Override
  public SetAccountInfoResponse clone() {
    return (SetAccountInfoResponse) super.clone();
  }

  /**
   * Model definition for SetAccountInfoResponseProviderUserInfo.
   */
  public static final class ProviderUserInfo extends com.google.api.client.json.GenericJson {

    /**
     * The user's display name at the IDP.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String displayName;

    /**
     * User's identifier at IDP.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String federatedId;

    /**
     * The user's photo url at the IDP.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String photoUrl;

    /**
     * The IdP ID. For whitelisted IdPs it's a short domain name, e.g., google.com, aol.com, live.net
     * and yahoo.com. For other OpenID IdPs it's the OP identifier.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String providerId;

    /**
     * The user's display name at the IDP.
     * @return value or {@code null} for none
     */
    public java.lang.String getDisplayName() {
      return displayName;
    }

    /**
     * The user's display name at the IDP.
     * @param displayName displayName or {@code null} for none
     */
    public ProviderUserInfo setDisplayName(java.lang.String displayName) {
      this.displayName = displayName;
      return this;
    }

    /**
     * User's identifier at IDP.
     * @return value or {@code null} for none
     */
    public java.lang.String getFederatedId() {
      return federatedId;
    }

    /**
     * User's identifier at IDP.
     * @param federatedId federatedId or {@code null} for none
     */
    public ProviderUserInfo setFederatedId(java.lang.String federatedId) {
      this.federatedId = federatedId;
      return this;
    }

    /**
     * The user's photo url at the IDP.
     * @return value or {@code null} for none
     */
    public java.lang.String getPhotoUrl() {
      return photoUrl;
    }

    /**
     * The user's photo url at the IDP.
     * @param photoUrl photoUrl or {@code null} for none
     */
    public ProviderUserInfo setPhotoUrl(java.lang.String photoUrl) {
      this.photoUrl = photoUrl;
      return this;
    }

    /**
     * The IdP ID. For whitelisted IdPs it's a short domain name, e.g., google.com, aol.com, live.net
     * and yahoo.com. For other OpenID IdPs it's the OP identifier.
     * @return value or {@code null} for none
     */
    public java.lang.String getProviderId() {
      return providerId;
    }

    /**
     * The IdP ID. For whitelisted IdPs it's a short domain name, e.g., google.com, aol.com, live.net
     * and yahoo.com. For other OpenID IdPs it's the OP identifier.
     * @param providerId providerId or {@code null} for none
     */
    public ProviderUserInfo setProviderId(java.lang.String providerId) {
      this.providerId = providerId;
      return this;
    }

    @Override
    public ProviderUserInfo set(String fieldName, Object value) {
      return (ProviderUserInfo) super.set(fieldName, value);
    }

    @Override
    public ProviderUserInfo clone() {
      return (ProviderUserInfo) super.clone();
    }

  }

}
