/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Request of getting a code for user confirmation (reset password, change email etc.)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Relyingparty extends com.google.api.client.json.GenericJson {

  /**
   * whether or not to install the android app on the device where the link is opened
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean androidInstallApp;

  /**
   * minimum version of the app. if the version on the device is lower than this version then the
   * user is taken to the play store to upgrade the app
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String androidMinimumVersion;

  /**
   * android package name of the android app to handle the action code
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String androidPackageName;

  /**
   * whether or not the app can handle the oob code without first going to web
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canHandleCodeInApp;

  /**
   * The recaptcha response from the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String captchaResp;

  /**
   * The recaptcha challenge presented to the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String challenge;

  /**
   * The url to continue to the Gitkit app
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String continueUrl;

  /**
   * The email of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * iOS app store id to download the app if it's not already installed
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iOSAppStoreId;

  /**
   * the iOS bundle id of iOS app to handle the action code
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iOSBundleId;

  /**
   * The user's Gitkit login token for email change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idToken;

  /**
   * The fixed string "identitytoolkit#relyingparty".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The new email if the code is for email change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String newEmail;

  /**
   * The request type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestType;

  /**
   * The IP address of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userIp;

  /**
   * whether or not to install the android app on the device where the link is opened
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAndroidInstallApp() {
    return androidInstallApp;
  }

  /**
   * whether or not to install the android app on the device where the link is opened
   * @param androidInstallApp androidInstallApp or {@code null} for none
   */
  public Relyingparty setAndroidInstallApp(java.lang.Boolean androidInstallApp) {
    this.androidInstallApp = androidInstallApp;
    return this;
  }

  /**
   * minimum version of the app. if the version on the device is lower than this version then the
   * user is taken to the play store to upgrade the app
   * @return value or {@code null} for none
   */
  public java.lang.String getAndroidMinimumVersion() {
    return androidMinimumVersion;
  }

  /**
   * minimum version of the app. if the version on the device is lower than this version then the
   * user is taken to the play store to upgrade the app
   * @param androidMinimumVersion androidMinimumVersion or {@code null} for none
   */
  public Relyingparty setAndroidMinimumVersion(java.lang.String androidMinimumVersion) {
    this.androidMinimumVersion = androidMinimumVersion;
    return this;
  }

  /**
   * android package name of the android app to handle the action code
   * @return value or {@code null} for none
   */
  public java.lang.String getAndroidPackageName() {
    return androidPackageName;
  }

  /**
   * android package name of the android app to handle the action code
   * @param androidPackageName androidPackageName or {@code null} for none
   */
  public Relyingparty setAndroidPackageName(java.lang.String androidPackageName) {
    this.androidPackageName = androidPackageName;
    return this;
  }

  /**
   * whether or not the app can handle the oob code without first going to web
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanHandleCodeInApp() {
    return canHandleCodeInApp;
  }

  /**
   * whether or not the app can handle the oob code without first going to web
   * @param canHandleCodeInApp canHandleCodeInApp or {@code null} for none
   */
  public Relyingparty setCanHandleCodeInApp(java.lang.Boolean canHandleCodeInApp) {
    this.canHandleCodeInApp = canHandleCodeInApp;
    return this;
  }

  /**
   * The recaptcha response from the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaptchaResp() {
    return captchaResp;
  }

  /**
   * The recaptcha response from the user.
   * @param captchaResp captchaResp or {@code null} for none
   */
  public Relyingparty setCaptchaResp(java.lang.String captchaResp) {
    this.captchaResp = captchaResp;
    return this;
  }

  /**
   * The recaptcha challenge presented to the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getChallenge() {
    return challenge;
  }

  /**
   * The recaptcha challenge presented to the user.
   * @param challenge challenge or {@code null} for none
   */
  public Relyingparty setChallenge(java.lang.String challenge) {
    this.challenge = challenge;
    return this;
  }

  /**
   * The url to continue to the Gitkit app
   * @return value or {@code null} for none
   */
  public java.lang.String getContinueUrl() {
    return continueUrl;
  }

  /**
   * The url to continue to the Gitkit app
   * @param continueUrl continueUrl or {@code null} for none
   */
  public Relyingparty setContinueUrl(java.lang.String continueUrl) {
    this.continueUrl = continueUrl;
    return this;
  }

  /**
   * The email of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email of the user.
   * @param email email or {@code null} for none
   */
  public Relyingparty setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * iOS app store id to download the app if it's not already installed
   * @return value or {@code null} for none
   */
  public java.lang.String getIOSAppStoreId() {
    return iOSAppStoreId;
  }

  /**
   * iOS app store id to download the app if it's not already installed
   * @param iOSAppStoreId iOSAppStoreId or {@code null} for none
   */
  public Relyingparty setIOSAppStoreId(java.lang.String iOSAppStoreId) {
    this.iOSAppStoreId = iOSAppStoreId;
    return this;
  }

  /**
   * the iOS bundle id of iOS app to handle the action code
   * @return value or {@code null} for none
   */
  public java.lang.String getIOSBundleId() {
    return iOSBundleId;
  }

  /**
   * the iOS bundle id of iOS app to handle the action code
   * @param iOSBundleId iOSBundleId or {@code null} for none
   */
  public Relyingparty setIOSBundleId(java.lang.String iOSBundleId) {
    this.iOSBundleId = iOSBundleId;
    return this;
  }

  /**
   * The user's Gitkit login token for email change.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdToken() {
    return idToken;
  }

  /**
   * The user's Gitkit login token for email change.
   * @param idToken idToken or {@code null} for none
   */
  public Relyingparty setIdToken(java.lang.String idToken) {
    this.idToken = idToken;
    return this;
  }

  /**
   * The fixed string "identitytoolkit#relyingparty".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string "identitytoolkit#relyingparty".
   * @param kind kind or {@code null} for none
   */
  public Relyingparty setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The new email if the code is for email change.
   * @return value or {@code null} for none
   */
  public java.lang.String getNewEmail() {
    return newEmail;
  }

  /**
   * The new email if the code is for email change.
   * @param newEmail newEmail or {@code null} for none
   */
  public Relyingparty setNewEmail(java.lang.String newEmail) {
    this.newEmail = newEmail;
    return this;
  }

  /**
   * The request type.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestType() {
    return requestType;
  }

  /**
   * The request type.
   * @param requestType requestType or {@code null} for none
   */
  public Relyingparty setRequestType(java.lang.String requestType) {
    this.requestType = requestType;
    return this;
  }

  /**
   * The IP address of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserIp() {
    return userIp;
  }

  /**
   * The IP address of the user.
   * @param userIp userIp or {@code null} for none
   */
  public Relyingparty setUserIp(java.lang.String userIp) {
    this.userIp = userIp;
    return this;
  }

  @Override
  public Relyingparty set(String fieldName, Object value) {
    return (Relyingparty) super.set(fieldName, value);
  }

  @Override
  public Relyingparty clone() {
    return (Relyingparty) super.clone();
  }

}
