/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Template for a single idp configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdpConfig extends com.google.api.client.json.GenericJson {

  /**
   * OAuth2 client ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientId;

  /**
   * Whether this IDP is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enabled;

  /**
   * Percent of users who will be prompted/redirected federated login for this IDP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer experimentPercent;

  /**
   * OAuth2 provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String provider;

  /**
   * OAuth2 client secret.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String secret;

  /**
   * Whitelisted client IDs for audience check.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> whitelistedAudiences;

  /**
   * OAuth2 client ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getClientId() {
    return clientId;
  }

  /**
   * OAuth2 client ID.
   * @param clientId clientId or {@code null} for none
   */
  public IdpConfig setClientId(java.lang.String clientId) {
    this.clientId = clientId;
    return this;
  }

  /**
   * Whether this IDP is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnabled() {
    return enabled;
  }

  /**
   * Whether this IDP is enabled.
   * @param enabled enabled or {@code null} for none
   */
  public IdpConfig setEnabled(java.lang.Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

  /**
   * Percent of users who will be prompted/redirected federated login for this IDP.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getExperimentPercent() {
    return experimentPercent;
  }

  /**
   * Percent of users who will be prompted/redirected federated login for this IDP.
   * @param experimentPercent experimentPercent or {@code null} for none
   */
  public IdpConfig setExperimentPercent(java.lang.Integer experimentPercent) {
    this.experimentPercent = experimentPercent;
    return this;
  }

  /**
   * OAuth2 provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getProvider() {
    return provider;
  }

  /**
   * OAuth2 provider.
   * @param provider provider or {@code null} for none
   */
  public IdpConfig setProvider(java.lang.String provider) {
    this.provider = provider;
    return this;
  }

  /**
   * OAuth2 client secret.
   * @return value or {@code null} for none
   */
  public java.lang.String getSecret() {
    return secret;
  }

  /**
   * OAuth2 client secret.
   * @param secret secret or {@code null} for none
   */
  public IdpConfig setSecret(java.lang.String secret) {
    this.secret = secret;
    return this;
  }

  /**
   * Whitelisted client IDs for audience check.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getWhitelistedAudiences() {
    return whitelistedAudiences;
  }

  /**
   * Whitelisted client IDs for audience check.
   * @param whitelistedAudiences whitelistedAudiences or {@code null} for none
   */
  public IdpConfig setWhitelistedAudiences(java.util.List<java.lang.String> whitelistedAudiences) {
    this.whitelistedAudiences = whitelistedAudiences;
    return this;
  }

  @Override
  public IdpConfig set(String fieldName, Object value) {
    return (IdpConfig) super.set(fieldName, value);
  }

  @Override
  public IdpConfig clone() {
    return (IdpConfig) super.clone();
  }

}
