/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Request to upload user account in batch.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentitytoolkitRelyingpartyUploadAccountRequest extends com.google.api.client.json.GenericJson {

  /**
   * Whether allow overwrite existing account when user local_id exists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowOverwrite;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer blockSize;

  /**
   * The following 4 fields are for standard scrypt algorithm.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer cpuMemCost;

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long delegatedProjectNumber;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer dkLen;

  /**
   * The password hash algorithm.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hashAlgorithm;

  /**
   * Memory cost for hash calculation. Used by scrypt similar algorithms.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer memoryCost;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer parallelization;

  /**
   * Rounds for hash calculation. Used by scrypt and similar algorithms.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rounds;

  /**
   * The salt separator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String saltSeparator;

  /**
   * If true, backend will do sanity check(including duplicate email and federated id) when
   * uploading account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sanityCheck;

  /**
   * The key for to hash the password.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String signerKey;

  /**
   * Specify which project (field value is actually project id) to operate. Only used when provided
   * credential.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetProjectId;

  /**
   * The account info to be stored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserInfo> users;

  /**
   * Whether allow overwrite existing account when user local_id exists.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowOverwrite() {
    return allowOverwrite;
  }

  /**
   * Whether allow overwrite existing account when user local_id exists.
   * @param allowOverwrite allowOverwrite or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setAllowOverwrite(java.lang.Boolean allowOverwrite) {
    this.allowOverwrite = allowOverwrite;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBlockSize() {
    return blockSize;
  }

  /**
   * @param blockSize blockSize or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setBlockSize(java.lang.Integer blockSize) {
    this.blockSize = blockSize;
    return this;
  }

  /**
   * The following 4 fields are for standard scrypt algorithm.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCpuMemCost() {
    return cpuMemCost;
  }

  /**
   * The following 4 fields are for standard scrypt algorithm.
   * @param cpuMemCost cpuMemCost or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setCpuMemCost(java.lang.Integer cpuMemCost) {
    this.cpuMemCost = cpuMemCost;
    return this;
  }

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDelegatedProjectNumber() {
    return delegatedProjectNumber;
  }

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * @param delegatedProjectNumber delegatedProjectNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setDelegatedProjectNumber(java.lang.Long delegatedProjectNumber) {
    this.delegatedProjectNumber = delegatedProjectNumber;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDkLen() {
    return dkLen;
  }

  /**
   * @param dkLen dkLen or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setDkLen(java.lang.Integer dkLen) {
    this.dkLen = dkLen;
    return this;
  }

  /**
   * The password hash algorithm.
   * @return value or {@code null} for none
   */
  public java.lang.String getHashAlgorithm() {
    return hashAlgorithm;
  }

  /**
   * The password hash algorithm.
   * @param hashAlgorithm hashAlgorithm or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setHashAlgorithm(java.lang.String hashAlgorithm) {
    this.hashAlgorithm = hashAlgorithm;
    return this;
  }

  /**
   * Memory cost for hash calculation. Used by scrypt similar algorithms.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMemoryCost() {
    return memoryCost;
  }

  /**
   * Memory cost for hash calculation. Used by scrypt similar algorithms.
   * @param memoryCost memoryCost or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setMemoryCost(java.lang.Integer memoryCost) {
    this.memoryCost = memoryCost;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Integer getParallelization() {
    return parallelization;
  }

  /**
   * @param parallelization parallelization or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setParallelization(java.lang.Integer parallelization) {
    this.parallelization = parallelization;
    return this;
  }

  /**
   * Rounds for hash calculation. Used by scrypt and similar algorithms.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRounds() {
    return rounds;
  }

  /**
   * Rounds for hash calculation. Used by scrypt and similar algorithms.
   * @param rounds rounds or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setRounds(java.lang.Integer rounds) {
    this.rounds = rounds;
    return this;
  }

  /**
   * The salt separator.
   * @see #decodeSaltSeparator()
   * @return value or {@code null} for none
   */
  public java.lang.String getSaltSeparator() {
    return saltSeparator;
  }

  /**
   * The salt separator.
   * @see #getSaltSeparator()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeSaltSeparator() {
    return com.google.api.client.util.Base64.decodeBase64(saltSeparator);
  }

  /**
   * The salt separator.
   * @see #encodeSaltSeparator()
   * @param saltSeparator saltSeparator or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setSaltSeparator(java.lang.String saltSeparator) {
    this.saltSeparator = saltSeparator;
    return this;
  }

  /**
   * The salt separator.
   * @see #setSaltSeparator()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest encodeSaltSeparator(byte[] saltSeparator) {
    this.saltSeparator = com.google.api.client.util.Base64.encodeBase64URLSafeString(saltSeparator);
    return this;
  }

  /**
   * If true, backend will do sanity check(including duplicate email and federated id) when
   * uploading account.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSanityCheck() {
    return sanityCheck;
  }

  /**
   * If true, backend will do sanity check(including duplicate email and federated id) when
   * uploading account.
   * @param sanityCheck sanityCheck or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setSanityCheck(java.lang.Boolean sanityCheck) {
    this.sanityCheck = sanityCheck;
    return this;
  }

  /**
   * The key for to hash the password.
   * @see #decodeSignerKey()
   * @return value or {@code null} for none
   */
  public java.lang.String getSignerKey() {
    return signerKey;
  }

  /**
   * The key for to hash the password.
   * @see #getSignerKey()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeSignerKey() {
    return com.google.api.client.util.Base64.decodeBase64(signerKey);
  }

  /**
   * The key for to hash the password.
   * @see #encodeSignerKey()
   * @param signerKey signerKey or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setSignerKey(java.lang.String signerKey) {
    this.signerKey = signerKey;
    return this;
  }

  /**
   * The key for to hash the password.
   * @see #setSignerKey()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest encodeSignerKey(byte[] signerKey) {
    this.signerKey = com.google.api.client.util.Base64.encodeBase64URLSafeString(signerKey);
    return this;
  }

  /**
   * Specify which project (field value is actually project id) to operate. Only used when provided
   * credential.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetProjectId() {
    return targetProjectId;
  }

  /**
   * Specify which project (field value is actually project id) to operate. Only used when provided
   * credential.
   * @param targetProjectId targetProjectId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setTargetProjectId(java.lang.String targetProjectId) {
    this.targetProjectId = targetProjectId;
    return this;
  }

  /**
   * The account info to be stored.
   * @return value or {@code null} for none
   */
  public java.util.List<UserInfo> getUsers() {
    return users;
  }

  /**
   * The account info to be stored.
   * @param users users or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyUploadAccountRequest setUsers(java.util.List<UserInfo> users) {
    this.users = users;
    return this;
  }

  @Override
  public IdentitytoolkitRelyingpartyUploadAccountRequest set(String fieldName, Object value) {
    return (IdentitytoolkitRelyingpartyUploadAccountRequest) super.set(fieldName, value);
  }

  @Override
  public IdentitytoolkitRelyingpartyUploadAccountRequest clone() {
    return (IdentitytoolkitRelyingpartyUploadAccountRequest) super.clone();
  }

}
