/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Request to signup new user, create anonymous user or anonymous user reauth.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentitytoolkitRelyingpartySignupNewUserRequest extends com.google.api.client.json.GenericJson {

  /**
   * The captcha challenge.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String captchaChallenge;

  /**
   * Response to the captcha.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String captchaResponse;

  /**
   * Whether to disable the user. Only can be used by service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disabled;

  /**
   * The name of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The email of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * Mark the email as verified or not. Only can be used by service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean emailVerified;

  /**
   * The GITKit token of the authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idToken;

  /**
   * Instance id token of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceId;

  /**
   * Privileged caller can create user with specified user id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localId;

  /**
   * The new password of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String password;

  /**
   * Privileged caller can create user with specified phone number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneNumber;

  /**
   * The photo url of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String photoUrl;

  /**
   * For multi-tenant use cases, in order to construct sign-in URL with the correct IDP parameters,
   * Firebear needs to know which Tenant to retrieve IDP configs from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tenantId;

  /**
   * Tenant project number to be used for idp discovery.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger tenantProjectNumber;

  /**
   * The captcha challenge.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaptchaChallenge() {
    return captchaChallenge;
  }

  /**
   * The captcha challenge.
   * @param captchaChallenge captchaChallenge or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setCaptchaChallenge(java.lang.String captchaChallenge) {
    this.captchaChallenge = captchaChallenge;
    return this;
  }

  /**
   * Response to the captcha.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaptchaResponse() {
    return captchaResponse;
  }

  /**
   * Response to the captcha.
   * @param captchaResponse captchaResponse or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setCaptchaResponse(java.lang.String captchaResponse) {
    this.captchaResponse = captchaResponse;
    return this;
  }

  /**
   * Whether to disable the user. Only can be used by service account.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisabled() {
    return disabled;
  }

  /**
   * Whether to disable the user. Only can be used by service account.
   * @param disabled disabled or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setDisabled(java.lang.Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * The name of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The name of the user.
   * @param displayName displayName or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The email of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email of the user.
   * @param email email or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * Mark the email as verified or not. Only can be used by service account.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmailVerified() {
    return emailVerified;
  }

  /**
   * Mark the email as verified or not. Only can be used by service account.
   * @param emailVerified emailVerified or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setEmailVerified(java.lang.Boolean emailVerified) {
    this.emailVerified = emailVerified;
    return this;
  }

  /**
   * The GITKit token of the authenticated user.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdToken() {
    return idToken;
  }

  /**
   * The GITKit token of the authenticated user.
   * @param idToken idToken or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setIdToken(java.lang.String idToken) {
    this.idToken = idToken;
    return this;
  }

  /**
   * Instance id token of the app.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceId() {
    return instanceId;
  }

  /**
   * Instance id token of the app.
   * @param instanceId instanceId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setInstanceId(java.lang.String instanceId) {
    this.instanceId = instanceId;
    return this;
  }

  /**
   * Privileged caller can create user with specified user id.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalId() {
    return localId;
  }

  /**
   * Privileged caller can create user with specified user id.
   * @param localId localId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setLocalId(java.lang.String localId) {
    this.localId = localId;
    return this;
  }

  /**
   * The new password of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getPassword() {
    return password;
  }

  /**
   * The new password of the user.
   * @param password password or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setPassword(java.lang.String password) {
    this.password = password;
    return this;
  }

  /**
   * Privileged caller can create user with specified phone number.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * Privileged caller can create user with specified phone number.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setPhoneNumber(java.lang.String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * The photo url of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhotoUrl() {
    return photoUrl;
  }

  /**
   * The photo url of the user.
   * @param photoUrl photoUrl or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setPhotoUrl(java.lang.String photoUrl) {
    this.photoUrl = photoUrl;
    return this;
  }

  /**
   * For multi-tenant use cases, in order to construct sign-in URL with the correct IDP parameters,
   * Firebear needs to know which Tenant to retrieve IDP configs from.
   * @return value or {@code null} for none
   */
  public java.lang.String getTenantId() {
    return tenantId;
  }

  /**
   * For multi-tenant use cases, in order to construct sign-in URL with the correct IDP parameters,
   * Firebear needs to know which Tenant to retrieve IDP configs from.
   * @param tenantId tenantId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setTenantId(java.lang.String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Tenant project number to be used for idp discovery.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getTenantProjectNumber() {
    return tenantProjectNumber;
  }

  /**
   * Tenant project number to be used for idp discovery.
   * @param tenantProjectNumber tenantProjectNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySignupNewUserRequest setTenantProjectNumber(java.math.BigInteger tenantProjectNumber) {
    this.tenantProjectNumber = tenantProjectNumber;
    return this;
  }

  @Override
  public IdentitytoolkitRelyingpartySignupNewUserRequest set(String fieldName, Object value) {
    return (IdentitytoolkitRelyingpartySignupNewUserRequest) super.set(fieldName, value);
  }

  @Override
  public IdentitytoolkitRelyingpartySignupNewUserRequest clone() {
    return (IdentitytoolkitRelyingpartySignupNewUserRequest) super.clone();
  }

}
