/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Request to set the account information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentitytoolkitRelyingpartySetAccountInfoRequest extends com.google.api.client.json.GenericJson {

  /**
   * The captcha challenge.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String captchaChallenge;

  /**
   * Response to the captcha.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String captchaResponse;

  /**
   * The timestamp when the account is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long createdAt;

  /**
   * The custom attributes to be set in the user's id token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customAttributes;

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long delegatedProjectNumber;

  /**
   * The attributes users request to delete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> deleteAttribute;

  /**
   * The IDPs the user request to delete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> deleteProvider;

  /**
   * Whether to disable the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disableUser;

  /**
   * The name of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The email of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * Mark the email as verified or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean emailVerified;

  /**
   * The GITKit token of the authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idToken;

  /**
   * Instance id token of the app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceId;

  /**
   * Last login timestamp.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lastLoginAt;

  /**
   * The local ID of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localId;

  /**
   * The out-of-band code of the change email request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String oobCode;

  /**
   * The new password of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String password;

  /**
   * Privileged caller can update user with specified phone number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneNumber;

  /**
   * The photo url of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String photoUrl;

  /**
   * The associated IDPs of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> provider;

  /**
   * Whether return sts id token and refresh token instead of gitkit token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean returnSecureToken;

  /**
   * Mark the user to upgrade to federated login.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean upgradeToFederatedLogin;

  /**
   * Timestamp in seconds for valid login token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long validSince;

  /**
   * The captcha challenge.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaptchaChallenge() {
    return captchaChallenge;
  }

  /**
   * The captcha challenge.
   * @param captchaChallenge captchaChallenge or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setCaptchaChallenge(java.lang.String captchaChallenge) {
    this.captchaChallenge = captchaChallenge;
    return this;
  }

  /**
   * Response to the captcha.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaptchaResponse() {
    return captchaResponse;
  }

  /**
   * Response to the captcha.
   * @param captchaResponse captchaResponse or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setCaptchaResponse(java.lang.String captchaResponse) {
    this.captchaResponse = captchaResponse;
    return this;
  }

  /**
   * The timestamp when the account is created.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreatedAt() {
    return createdAt;
  }

  /**
   * The timestamp when the account is created.
   * @param createdAt createdAt or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setCreatedAt(java.lang.Long createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * The custom attributes to be set in the user's id token.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomAttributes() {
    return customAttributes;
  }

  /**
   * The custom attributes to be set in the user's id token.
   * @param customAttributes customAttributes or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setCustomAttributes(java.lang.String customAttributes) {
    this.customAttributes = customAttributes;
    return this;
  }

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDelegatedProjectNumber() {
    return delegatedProjectNumber;
  }

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * @param delegatedProjectNumber delegatedProjectNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setDelegatedProjectNumber(java.lang.Long delegatedProjectNumber) {
    this.delegatedProjectNumber = delegatedProjectNumber;
    return this;
  }

  /**
   * The attributes users request to delete.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDeleteAttribute() {
    return deleteAttribute;
  }

  /**
   * The attributes users request to delete.
   * @param deleteAttribute deleteAttribute or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setDeleteAttribute(java.util.List<java.lang.String> deleteAttribute) {
    this.deleteAttribute = deleteAttribute;
    return this;
  }

  /**
   * The IDPs the user request to delete.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDeleteProvider() {
    return deleteProvider;
  }

  /**
   * The IDPs the user request to delete.
   * @param deleteProvider deleteProvider or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setDeleteProvider(java.util.List<java.lang.String> deleteProvider) {
    this.deleteProvider = deleteProvider;
    return this;
  }

  /**
   * Whether to disable the user.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisableUser() {
    return disableUser;
  }

  /**
   * Whether to disable the user.
   * @param disableUser disableUser or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setDisableUser(java.lang.Boolean disableUser) {
    this.disableUser = disableUser;
    return this;
  }

  /**
   * The name of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The name of the user.
   * @param displayName displayName or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The email of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email of the user.
   * @param email email or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * Mark the email as verified or not.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmailVerified() {
    return emailVerified;
  }

  /**
   * Mark the email as verified or not.
   * @param emailVerified emailVerified or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setEmailVerified(java.lang.Boolean emailVerified) {
    this.emailVerified = emailVerified;
    return this;
  }

  /**
   * The GITKit token of the authenticated user.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdToken() {
    return idToken;
  }

  /**
   * The GITKit token of the authenticated user.
   * @param idToken idToken or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setIdToken(java.lang.String idToken) {
    this.idToken = idToken;
    return this;
  }

  /**
   * Instance id token of the app.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceId() {
    return instanceId;
  }

  /**
   * Instance id token of the app.
   * @param instanceId instanceId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setInstanceId(java.lang.String instanceId) {
    this.instanceId = instanceId;
    return this;
  }

  /**
   * Last login timestamp.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLastLoginAt() {
    return lastLoginAt;
  }

  /**
   * Last login timestamp.
   * @param lastLoginAt lastLoginAt or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setLastLoginAt(java.lang.Long lastLoginAt) {
    this.lastLoginAt = lastLoginAt;
    return this;
  }

  /**
   * The local ID of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalId() {
    return localId;
  }

  /**
   * The local ID of the user.
   * @param localId localId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setLocalId(java.lang.String localId) {
    this.localId = localId;
    return this;
  }

  /**
   * The out-of-band code of the change email request.
   * @return value or {@code null} for none
   */
  public java.lang.String getOobCode() {
    return oobCode;
  }

  /**
   * The out-of-band code of the change email request.
   * @param oobCode oobCode or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setOobCode(java.lang.String oobCode) {
    this.oobCode = oobCode;
    return this;
  }

  /**
   * The new password of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getPassword() {
    return password;
  }

  /**
   * The new password of the user.
   * @param password password or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setPassword(java.lang.String password) {
    this.password = password;
    return this;
  }

  /**
   * Privileged caller can update user with specified phone number.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * Privileged caller can update user with specified phone number.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setPhoneNumber(java.lang.String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * The photo url of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhotoUrl() {
    return photoUrl;
  }

  /**
   * The photo url of the user.
   * @param photoUrl photoUrl or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setPhotoUrl(java.lang.String photoUrl) {
    this.photoUrl = photoUrl;
    return this;
  }

  /**
   * The associated IDPs of the user.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getProvider() {
    return provider;
  }

  /**
   * The associated IDPs of the user.
   * @param provider provider or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setProvider(java.util.List<java.lang.String> provider) {
    this.provider = provider;
    return this;
  }

  /**
   * Whether return sts id token and refresh token instead of gitkit token.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getReturnSecureToken() {
    return returnSecureToken;
  }

  /**
   * Whether return sts id token and refresh token instead of gitkit token.
   * @param returnSecureToken returnSecureToken or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setReturnSecureToken(java.lang.Boolean returnSecureToken) {
    this.returnSecureToken = returnSecureToken;
    return this;
  }

  /**
   * Mark the user to upgrade to federated login.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUpgradeToFederatedLogin() {
    return upgradeToFederatedLogin;
  }

  /**
   * Mark the user to upgrade to federated login.
   * @param upgradeToFederatedLogin upgradeToFederatedLogin or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setUpgradeToFederatedLogin(java.lang.Boolean upgradeToFederatedLogin) {
    this.upgradeToFederatedLogin = upgradeToFederatedLogin;
    return this;
  }

  /**
   * Timestamp in seconds for valid login token.
   * @return value or {@code null} for none
   */
  public java.lang.Long getValidSince() {
    return validSince;
  }

  /**
   * Timestamp in seconds for valid login token.
   * @param validSince validSince or {@code null} for none
   */
  public IdentitytoolkitRelyingpartySetAccountInfoRequest setValidSince(java.lang.Long validSince) {
    this.validSince = validSince;
    return this;
  }

  @Override
  public IdentitytoolkitRelyingpartySetAccountInfoRequest set(String fieldName, Object value) {
    return (IdentitytoolkitRelyingpartySetAccountInfoRequest) super.set(fieldName, value);
  }

  @Override
  public IdentitytoolkitRelyingpartySetAccountInfoRequest clone() {
    return (IdentitytoolkitRelyingpartySetAccountInfoRequest) super.clone();
  }

}
