/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Response of getting the project configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentitytoolkitRelyingpartyGetProjectConfigResponse extends com.google.api.client.json.GenericJson {

  /**
   * Whether to allow password user sign in or sign up.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowPasswordUser;

  /**
   * Browser API key, needed when making http request to Apiary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String apiKey;

  /**
   * Authorized domains.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> authorizedDomains;

  /**
   * Change email template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmailTemplate changeEmailTemplate;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dynamicLinksDomain;

  /**
   * Whether anonymous user is enabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableAnonymousUser;

  /**
   * OAuth2 provider configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IdpConfig> idpConfig;

  /**
   * Legacy reset password email template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmailTemplate legacyResetPasswordTemplate;

  /**
   * Project ID of the relying party.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Reset password email template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmailTemplate resetPasswordTemplate;

  /**
   * Whether to use email sending provided by Firebear.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useEmailSending;

  /**
   * Verify email template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmailTemplate verifyEmailTemplate;

  /**
   * Whether to allow password user sign in or sign up.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowPasswordUser() {
    return allowPasswordUser;
  }

  /**
   * Whether to allow password user sign in or sign up.
   * @param allowPasswordUser allowPasswordUser or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setAllowPasswordUser(java.lang.Boolean allowPasswordUser) {
    this.allowPasswordUser = allowPasswordUser;
    return this;
  }

  /**
   * Browser API key, needed when making http request to Apiary.
   * @return value or {@code null} for none
   */
  public java.lang.String getApiKey() {
    return apiKey;
  }

  /**
   * Browser API key, needed when making http request to Apiary.
   * @param apiKey apiKey or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setApiKey(java.lang.String apiKey) {
    this.apiKey = apiKey;
    return this;
  }

  /**
   * Authorized domains.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAuthorizedDomains() {
    return authorizedDomains;
  }

  /**
   * Authorized domains.
   * @param authorizedDomains authorizedDomains or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setAuthorizedDomains(java.util.List<java.lang.String> authorizedDomains) {
    this.authorizedDomains = authorizedDomains;
    return this;
  }

  /**
   * Change email template.
   * @return value or {@code null} for none
   */
  public EmailTemplate getChangeEmailTemplate() {
    return changeEmailTemplate;
  }

  /**
   * Change email template.
   * @param changeEmailTemplate changeEmailTemplate or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setChangeEmailTemplate(EmailTemplate changeEmailTemplate) {
    this.changeEmailTemplate = changeEmailTemplate;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getDynamicLinksDomain() {
    return dynamicLinksDomain;
  }

  /**
   * @param dynamicLinksDomain dynamicLinksDomain or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setDynamicLinksDomain(java.lang.String dynamicLinksDomain) {
    this.dynamicLinksDomain = dynamicLinksDomain;
    return this;
  }

  /**
   * Whether anonymous user is enabled.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableAnonymousUser() {
    return enableAnonymousUser;
  }

  /**
   * Whether anonymous user is enabled.
   * @param enableAnonymousUser enableAnonymousUser or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setEnableAnonymousUser(java.lang.Boolean enableAnonymousUser) {
    this.enableAnonymousUser = enableAnonymousUser;
    return this;
  }

  /**
   * OAuth2 provider configuration.
   * @return value or {@code null} for none
   */
  public java.util.List<IdpConfig> getIdpConfig() {
    return idpConfig;
  }

  /**
   * OAuth2 provider configuration.
   * @param idpConfig idpConfig or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setIdpConfig(java.util.List<IdpConfig> idpConfig) {
    this.idpConfig = idpConfig;
    return this;
  }

  /**
   * Legacy reset password email template.
   * @return value or {@code null} for none
   */
  public EmailTemplate getLegacyResetPasswordTemplate() {
    return legacyResetPasswordTemplate;
  }

  /**
   * Legacy reset password email template.
   * @param legacyResetPasswordTemplate legacyResetPasswordTemplate or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setLegacyResetPasswordTemplate(EmailTemplate legacyResetPasswordTemplate) {
    this.legacyResetPasswordTemplate = legacyResetPasswordTemplate;
    return this;
  }

  /**
   * Project ID of the relying party.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * Project ID of the relying party.
   * @param projectId projectId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Reset password email template.
   * @return value or {@code null} for none
   */
  public EmailTemplate getResetPasswordTemplate() {
    return resetPasswordTemplate;
  }

  /**
   * Reset password email template.
   * @param resetPasswordTemplate resetPasswordTemplate or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setResetPasswordTemplate(EmailTemplate resetPasswordTemplate) {
    this.resetPasswordTemplate = resetPasswordTemplate;
    return this;
  }

  /**
   * Whether to use email sending provided by Firebear.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseEmailSending() {
    return useEmailSending;
  }

  /**
   * Whether to use email sending provided by Firebear.
   * @param useEmailSending useEmailSending or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setUseEmailSending(java.lang.Boolean useEmailSending) {
    this.useEmailSending = useEmailSending;
    return this;
  }

  /**
   * Verify email template.
   * @return value or {@code null} for none
   */
  public EmailTemplate getVerifyEmailTemplate() {
    return verifyEmailTemplate;
  }

  /**
   * Verify email template.
   * @param verifyEmailTemplate verifyEmailTemplate or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse setVerifyEmailTemplate(EmailTemplate verifyEmailTemplate) {
    this.verifyEmailTemplate = verifyEmailTemplate;
    return this;
  }

  @Override
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse set(String fieldName, Object value) {
    return (IdentitytoolkitRelyingpartyGetProjectConfigResponse) super.set(fieldName, value);
  }

  @Override
  public IdentitytoolkitRelyingpartyGetProjectConfigResponse clone() {
    return (IdentitytoolkitRelyingpartyGetProjectConfigResponse) super.clone();
  }

}
