/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Request to get the account information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IdentitytoolkitRelyingpartyGetAccountInfoRequest extends com.google.api.client.json.GenericJson {

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long delegatedProjectNumber;

  /**
   * The list of emails of the users to inquiry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> email;

  /**
   * The GITKit token of the authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idToken;

  /**
   * The list of local ID's of the users to inquiry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> localId;

  /**
   * Privileged caller can query users by specified phone number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> phoneNumber;

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDelegatedProjectNumber() {
    return delegatedProjectNumber;
  }

  /**
   * GCP project number of the requesting delegated app. Currently only intended for Firebase V1
   * migration.
   * @param delegatedProjectNumber delegatedProjectNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetAccountInfoRequest setDelegatedProjectNumber(java.lang.Long delegatedProjectNumber) {
    this.delegatedProjectNumber = delegatedProjectNumber;
    return this;
  }

  /**
   * The list of emails of the users to inquiry.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getEmail() {
    return email;
  }

  /**
   * The list of emails of the users to inquiry.
   * @param email email or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetAccountInfoRequest setEmail(java.util.List<java.lang.String> email) {
    this.email = email;
    return this;
  }

  /**
   * The GITKit token of the authenticated user.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdToken() {
    return idToken;
  }

  /**
   * The GITKit token of the authenticated user.
   * @param idToken idToken or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetAccountInfoRequest setIdToken(java.lang.String idToken) {
    this.idToken = idToken;
    return this;
  }

  /**
   * The list of local ID's of the users to inquiry.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLocalId() {
    return localId;
  }

  /**
   * The list of local ID's of the users to inquiry.
   * @param localId localId or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetAccountInfoRequest setLocalId(java.util.List<java.lang.String> localId) {
    this.localId = localId;
    return this;
  }

  /**
   * Privileged caller can query users by specified phone number.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * Privileged caller can query users by specified phone number.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public IdentitytoolkitRelyingpartyGetAccountInfoRequest setPhoneNumber(java.util.List<java.lang.String> phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  @Override
  public IdentitytoolkitRelyingpartyGetAccountInfoRequest set(String fieldName, Object value) {
    return (IdentitytoolkitRelyingpartyGetAccountInfoRequest) super.set(fieldName, value);
  }

  @Override
  public IdentitytoolkitRelyingpartyGetAccountInfoRequest clone() {
    return (IdentitytoolkitRelyingpartyGetAccountInfoRequest) super.clone();
  }

}
