/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Template for an email template.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EmailTemplate extends com.google.api.client.json.GenericJson {

  /**
   * Email body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String body;

  /**
   * Email body format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String format;

  /**
   * From address of the email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String from;

  /**
   * From display name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fromDisplayName;

  /**
   * Reply-to address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replyTo;

  /**
   * Subject of the email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subject;

  /**
   * Email body.
   * @return value or {@code null} for none
   */
  public java.lang.String getBody() {
    return body;
  }

  /**
   * Email body.
   * @param body body or {@code null} for none
   */
  public EmailTemplate setBody(java.lang.String body) {
    this.body = body;
    return this;
  }

  /**
   * Email body format.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormat() {
    return format;
  }

  /**
   * Email body format.
   * @param format format or {@code null} for none
   */
  public EmailTemplate setFormat(java.lang.String format) {
    this.format = format;
    return this;
  }

  /**
   * From address of the email.
   * @return value or {@code null} for none
   */
  public java.lang.String getFrom() {
    return from;
  }

  /**
   * From address of the email.
   * @param from from or {@code null} for none
   */
  public EmailTemplate setFrom(java.lang.String from) {
    this.from = from;
    return this;
  }

  /**
   * From display name.
   * @return value or {@code null} for none
   */
  public java.lang.String getFromDisplayName() {
    return fromDisplayName;
  }

  /**
   * From display name.
   * @param fromDisplayName fromDisplayName or {@code null} for none
   */
  public EmailTemplate setFromDisplayName(java.lang.String fromDisplayName) {
    this.fromDisplayName = fromDisplayName;
    return this;
  }

  /**
   * Reply-to address.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplyTo() {
    return replyTo;
  }

  /**
   * Reply-to address.
   * @param replyTo replyTo or {@code null} for none
   */
  public EmailTemplate setReplyTo(java.lang.String replyTo) {
    this.replyTo = replyTo;
    return this;
  }

  /**
   * Subject of the email.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubject() {
    return subject;
  }

  /**
   * Subject of the email.
   * @param subject subject or {@code null} for none
   */
  public EmailTemplate setSubject(java.lang.String subject) {
    this.subject = subject;
    return this;
  }

  @Override
  public EmailTemplate set(String fieldName, Object value) {
    return (EmailTemplate) super.set(fieldName, value);
  }

  @Override
  public EmailTemplate clone() {
    return (EmailTemplate) super.clone();
  }

}
