/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Response of email signIn.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EmailLinkSigninResponse extends com.google.api.client.json.GenericJson {

  /**
   * The user's email.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * Expiration time of STS id token in seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expiresIn;

  /**
   * The STS id token to login the newly signed in user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String idToken;

  /**
   * Whether the user is new.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isNewUser;

  /**
   * The fixed string "identitytoolkit#EmailLinkSigninResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The RP local ID of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localId;

  /**
   * The refresh token for the signed in user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String refreshToken;

  /**
   * The user's email.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The user's email.
   * @param email email or {@code null} for none
   */
  public EmailLinkSigninResponse setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * Expiration time of STS id token in seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpiresIn() {
    return expiresIn;
  }

  /**
   * Expiration time of STS id token in seconds.
   * @param expiresIn expiresIn or {@code null} for none
   */
  public EmailLinkSigninResponse setExpiresIn(java.lang.Long expiresIn) {
    this.expiresIn = expiresIn;
    return this;
  }

  /**
   * The STS id token to login the newly signed in user.
   * @return value or {@code null} for none
   */
  public java.lang.String getIdToken() {
    return idToken;
  }

  /**
   * The STS id token to login the newly signed in user.
   * @param idToken idToken or {@code null} for none
   */
  public EmailLinkSigninResponse setIdToken(java.lang.String idToken) {
    this.idToken = idToken;
    return this;
  }

  /**
   * Whether the user is new.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsNewUser() {
    return isNewUser;
  }

  /**
   * Whether the user is new.
   * @param isNewUser isNewUser or {@code null} for none
   */
  public EmailLinkSigninResponse setIsNewUser(java.lang.Boolean isNewUser) {
    this.isNewUser = isNewUser;
    return this;
  }

  /**
   * The fixed string "identitytoolkit#EmailLinkSigninResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string "identitytoolkit#EmailLinkSigninResponse".
   * @param kind kind or {@code null} for none
   */
  public EmailLinkSigninResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The RP local ID of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalId() {
    return localId;
  }

  /**
   * The RP local ID of the user.
   * @param localId localId or {@code null} for none
   */
  public EmailLinkSigninResponse setLocalId(java.lang.String localId) {
    this.localId = localId;
    return this;
  }

  /**
   * The refresh token for the signed in user.
   * @return value or {@code null} for none
   */
  public java.lang.String getRefreshToken() {
    return refreshToken;
  }

  /**
   * The refresh token for the signed in user.
   * @param refreshToken refreshToken or {@code null} for none
   */
  public EmailLinkSigninResponse setRefreshToken(java.lang.String refreshToken) {
    this.refreshToken = refreshToken;
    return this;
  }

  @Override
  public EmailLinkSigninResponse set(String fieldName, Object value) {
    return (EmailLinkSigninResponse) super.set(fieldName, value);
  }

  @Override
  public EmailLinkSigninResponse clone() {
    return (EmailLinkSigninResponse) super.clone();
  }

}
