/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit.model;

/**
 * Response of downloading accounts in batch.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Identity Toolkit API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DownloadAccountResponse extends com.google.api.client.json.GenericJson {

  /**
   * The fixed string "identitytoolkit#DownloadAccountResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The next page token. To be used in a subsequent request to return the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The user accounts data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UserInfo> users;

  /**
   * The fixed string "identitytoolkit#DownloadAccountResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The fixed string "identitytoolkit#DownloadAccountResponse".
   * @param kind kind or {@code null} for none
   */
  public DownloadAccountResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The next page token. To be used in a subsequent request to return the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The next page token. To be used in a subsequent request to return the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public DownloadAccountResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The user accounts data.
   * @return value or {@code null} for none
   */
  public java.util.List<UserInfo> getUsers() {
    return users;
  }

  /**
   * The user accounts data.
   * @param users users or {@code null} for none
   */
  public DownloadAccountResponse setUsers(java.util.List<UserInfo> users) {
    this.users = users;
    return this;
  }

  @Override
  public DownloadAccountResponse set(String fieldName, Object value) {
    return (DownloadAccountResponse) super.set(fieldName, value);
  }

  @Override
  public DownloadAccountResponse clone() {
    return (DownloadAccountResponse) super.clone();
  }

}
