/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.identitytoolkit;

/**
 * Service definition for IdentityToolkit (v3).
 *
 * <p>
 * Help the third party sites to implement federated login.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/identity-toolkit/v3/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link IdentityToolkitRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class IdentityToolkit extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Google Identity Toolkit API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://www.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "identitytoolkit/v3/relyingparty/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/identitytoolkit/v3";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public IdentityToolkit(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  IdentityToolkit(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Relyingparty collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code IdentityToolkit identitytoolkit = new IdentityToolkit(...);}
   *   {@code IdentityToolkit.Relyingparty.List request = identitytoolkit.relyingparty().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Relyingparty relyingparty() {
    return new Relyingparty();
  }

  /**
   * The "relyingparty" collection of methods.
   */
  public class Relyingparty {

    /**
     * Creates the URI used by the IdP to authenticate the user.
     *
     * Create a request for the method "relyingparty.createAuthUri".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link CreateAuthUri#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyCreateAuthUriRequest}
     * @return the request
     */
    public CreateAuthUri createAuthUri(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyCreateAuthUriRequest content) throws java.io.IOException {
      CreateAuthUri result = new CreateAuthUri(content);
      initialize(result);
      return result;
    }

    public class CreateAuthUri extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.CreateAuthUriResponse> {

      private static final String REST_PATH = "createAuthUri";

      /**
       * Creates the URI used by the IdP to authenticate the user.
       *
       * Create a request for the method "relyingparty.createAuthUri".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link CreateAuthUri#execute()} method to invoke the remote
       * operation. <p> {@link CreateAuthUri#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyCreateAuthUriRequest}
       * @since 1.13
       */
      protected CreateAuthUri(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyCreateAuthUriRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.CreateAuthUriResponse.class);
      }

      @Override
      public CreateAuthUri setAlt(java.lang.String alt) {
        return (CreateAuthUri) super.setAlt(alt);
      }

      @Override
      public CreateAuthUri setFields(java.lang.String fields) {
        return (CreateAuthUri) super.setFields(fields);
      }

      @Override
      public CreateAuthUri setKey(java.lang.String key) {
        return (CreateAuthUri) super.setKey(key);
      }

      @Override
      public CreateAuthUri setOauthToken(java.lang.String oauthToken) {
        return (CreateAuthUri) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateAuthUri setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateAuthUri) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateAuthUri setQuotaUser(java.lang.String quotaUser) {
        return (CreateAuthUri) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateAuthUri setUserIp(java.lang.String userIp) {
        return (CreateAuthUri) super.setUserIp(userIp);
      }

      @Override
      public CreateAuthUri set(String parameterName, Object value) {
        return (CreateAuthUri) super.set(parameterName, value);
      }
    }
    /**
     * Delete user account.
     *
     * Create a request for the method "relyingparty.deleteAccount".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link DeleteAccount#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyDeleteAccountRequest}
     * @return the request
     */
    public DeleteAccount deleteAccount(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyDeleteAccountRequest content) throws java.io.IOException {
      DeleteAccount result = new DeleteAccount(content);
      initialize(result);
      return result;
    }

    public class DeleteAccount extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.DeleteAccountResponse> {

      private static final String REST_PATH = "deleteAccount";

      /**
       * Delete user account.
       *
       * Create a request for the method "relyingparty.deleteAccount".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link DeleteAccount#execute()} method to invoke the remote
       * operation. <p> {@link DeleteAccount#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyDeleteAccountRequest}
       * @since 1.13
       */
      protected DeleteAccount(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyDeleteAccountRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.DeleteAccountResponse.class);
      }

      @Override
      public DeleteAccount setAlt(java.lang.String alt) {
        return (DeleteAccount) super.setAlt(alt);
      }

      @Override
      public DeleteAccount setFields(java.lang.String fields) {
        return (DeleteAccount) super.setFields(fields);
      }

      @Override
      public DeleteAccount setKey(java.lang.String key) {
        return (DeleteAccount) super.setKey(key);
      }

      @Override
      public DeleteAccount setOauthToken(java.lang.String oauthToken) {
        return (DeleteAccount) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteAccount setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteAccount) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteAccount setQuotaUser(java.lang.String quotaUser) {
        return (DeleteAccount) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteAccount setUserIp(java.lang.String userIp) {
        return (DeleteAccount) super.setUserIp(userIp);
      }

      @Override
      public DeleteAccount set(String parameterName, Object value) {
        return (DeleteAccount) super.set(parameterName, value);
      }
    }
    /**
     * Batch download user accounts.
     *
     * Create a request for the method "relyingparty.downloadAccount".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link DownloadAccount#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyDownloadAccountRequest}
     * @return the request
     */
    public DownloadAccount downloadAccount(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyDownloadAccountRequest content) throws java.io.IOException {
      DownloadAccount result = new DownloadAccount(content);
      initialize(result);
      return result;
    }

    public class DownloadAccount extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.DownloadAccountResponse> {

      private static final String REST_PATH = "downloadAccount";

      /**
       * Batch download user accounts.
       *
       * Create a request for the method "relyingparty.downloadAccount".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link DownloadAccount#execute()} method to invoke the remote
       * operation. <p> {@link DownloadAccount#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyDownloadAccountRequest}
       * @since 1.13
       */
      protected DownloadAccount(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyDownloadAccountRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.DownloadAccountResponse.class);
      }

      @Override
      public DownloadAccount setAlt(java.lang.String alt) {
        return (DownloadAccount) super.setAlt(alt);
      }

      @Override
      public DownloadAccount setFields(java.lang.String fields) {
        return (DownloadAccount) super.setFields(fields);
      }

      @Override
      public DownloadAccount setKey(java.lang.String key) {
        return (DownloadAccount) super.setKey(key);
      }

      @Override
      public DownloadAccount setOauthToken(java.lang.String oauthToken) {
        return (DownloadAccount) super.setOauthToken(oauthToken);
      }

      @Override
      public DownloadAccount setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DownloadAccount) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DownloadAccount setQuotaUser(java.lang.String quotaUser) {
        return (DownloadAccount) super.setQuotaUser(quotaUser);
      }

      @Override
      public DownloadAccount setUserIp(java.lang.String userIp) {
        return (DownloadAccount) super.setUserIp(userIp);
      }

      @Override
      public DownloadAccount set(String parameterName, Object value) {
        return (DownloadAccount) super.set(parameterName, value);
      }
    }
    /**
     * Reset password for a user.
     *
     * Create a request for the method "relyingparty.emailLinkSignin".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link EmailLinkSignin#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyEmailLinkSigninRequest}
     * @return the request
     */
    public EmailLinkSignin emailLinkSignin(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyEmailLinkSigninRequest content) throws java.io.IOException {
      EmailLinkSignin result = new EmailLinkSignin(content);
      initialize(result);
      return result;
    }

    public class EmailLinkSignin extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.EmailLinkSigninResponse> {

      private static final String REST_PATH = "emailLinkSignin";

      /**
       * Reset password for a user.
       *
       * Create a request for the method "relyingparty.emailLinkSignin".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link EmailLinkSignin#execute()} method to invoke the remote
       * operation. <p> {@link EmailLinkSignin#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyEmailLinkSigninRequest}
       * @since 1.13
       */
      protected EmailLinkSignin(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyEmailLinkSigninRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.EmailLinkSigninResponse.class);
      }

      @Override
      public EmailLinkSignin setAlt(java.lang.String alt) {
        return (EmailLinkSignin) super.setAlt(alt);
      }

      @Override
      public EmailLinkSignin setFields(java.lang.String fields) {
        return (EmailLinkSignin) super.setFields(fields);
      }

      @Override
      public EmailLinkSignin setKey(java.lang.String key) {
        return (EmailLinkSignin) super.setKey(key);
      }

      @Override
      public EmailLinkSignin setOauthToken(java.lang.String oauthToken) {
        return (EmailLinkSignin) super.setOauthToken(oauthToken);
      }

      @Override
      public EmailLinkSignin setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (EmailLinkSignin) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public EmailLinkSignin setQuotaUser(java.lang.String quotaUser) {
        return (EmailLinkSignin) super.setQuotaUser(quotaUser);
      }

      @Override
      public EmailLinkSignin setUserIp(java.lang.String userIp) {
        return (EmailLinkSignin) super.setUserIp(userIp);
      }

      @Override
      public EmailLinkSignin set(String parameterName, Object value) {
        return (EmailLinkSignin) super.set(parameterName, value);
      }
    }
    /**
     * Returns the account info.
     *
     * Create a request for the method "relyingparty.getAccountInfo".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link GetAccountInfo#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyGetAccountInfoRequest}
     * @return the request
     */
    public GetAccountInfo getAccountInfo(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyGetAccountInfoRequest content) throws java.io.IOException {
      GetAccountInfo result = new GetAccountInfo(content);
      initialize(result);
      return result;
    }

    public class GetAccountInfo extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.GetAccountInfoResponse> {

      private static final String REST_PATH = "getAccountInfo";

      /**
       * Returns the account info.
       *
       * Create a request for the method "relyingparty.getAccountInfo".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link GetAccountInfo#execute()} method to invoke the remote
       * operation. <p> {@link GetAccountInfo#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyGetAccountInfoRequest}
       * @since 1.13
       */
      protected GetAccountInfo(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyGetAccountInfoRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.GetAccountInfoResponse.class);
      }

      @Override
      public GetAccountInfo setAlt(java.lang.String alt) {
        return (GetAccountInfo) super.setAlt(alt);
      }

      @Override
      public GetAccountInfo setFields(java.lang.String fields) {
        return (GetAccountInfo) super.setFields(fields);
      }

      @Override
      public GetAccountInfo setKey(java.lang.String key) {
        return (GetAccountInfo) super.setKey(key);
      }

      @Override
      public GetAccountInfo setOauthToken(java.lang.String oauthToken) {
        return (GetAccountInfo) super.setOauthToken(oauthToken);
      }

      @Override
      public GetAccountInfo setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetAccountInfo) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetAccountInfo setQuotaUser(java.lang.String quotaUser) {
        return (GetAccountInfo) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetAccountInfo setUserIp(java.lang.String userIp) {
        return (GetAccountInfo) super.setUserIp(userIp);
      }

      @Override
      public GetAccountInfo set(String parameterName, Object value) {
        return (GetAccountInfo) super.set(parameterName, value);
      }
    }
    /**
     * Get a code for user action confirmation.
     *
     * Create a request for the method "relyingparty.getOobConfirmationCode".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link GetOobConfirmationCode#execute()} method to invoke the
     * remote operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.Relyingparty}
     * @return the request
     */
    public GetOobConfirmationCode getOobConfirmationCode(com.google.api.services.identitytoolkit.model.Relyingparty content) throws java.io.IOException {
      GetOobConfirmationCode result = new GetOobConfirmationCode(content);
      initialize(result);
      return result;
    }

    public class GetOobConfirmationCode extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.GetOobConfirmationCodeResponse> {

      private static final String REST_PATH = "getOobConfirmationCode";

      /**
       * Get a code for user action confirmation.
       *
       * Create a request for the method "relyingparty.getOobConfirmationCode".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link GetOobConfirmationCode#execute()} method to invoke the
       * remote operation. <p> {@link GetOobConfirmationCode#initialize(com.google.api.client.googleapis
       * .services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.Relyingparty}
       * @since 1.13
       */
      protected GetOobConfirmationCode(com.google.api.services.identitytoolkit.model.Relyingparty content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.GetOobConfirmationCodeResponse.class);
      }

      @Override
      public GetOobConfirmationCode setAlt(java.lang.String alt) {
        return (GetOobConfirmationCode) super.setAlt(alt);
      }

      @Override
      public GetOobConfirmationCode setFields(java.lang.String fields) {
        return (GetOobConfirmationCode) super.setFields(fields);
      }

      @Override
      public GetOobConfirmationCode setKey(java.lang.String key) {
        return (GetOobConfirmationCode) super.setKey(key);
      }

      @Override
      public GetOobConfirmationCode setOauthToken(java.lang.String oauthToken) {
        return (GetOobConfirmationCode) super.setOauthToken(oauthToken);
      }

      @Override
      public GetOobConfirmationCode setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetOobConfirmationCode) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetOobConfirmationCode setQuotaUser(java.lang.String quotaUser) {
        return (GetOobConfirmationCode) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetOobConfirmationCode setUserIp(java.lang.String userIp) {
        return (GetOobConfirmationCode) super.setUserIp(userIp);
      }

      @Override
      public GetOobConfirmationCode set(String parameterName, Object value) {
        return (GetOobConfirmationCode) super.set(parameterName, value);
      }
    }
    /**
     * Get project configuration.
     *
     * Create a request for the method "relyingparty.getProjectConfig".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link GetProjectConfig#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public GetProjectConfig getProjectConfig() throws java.io.IOException {
      GetProjectConfig result = new GetProjectConfig();
      initialize(result);
      return result;
    }

    public class GetProjectConfig extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyGetProjectConfigResponse> {

      private static final String REST_PATH = "getProjectConfig";

      /**
       * Get project configuration.
       *
       * Create a request for the method "relyingparty.getProjectConfig".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link GetProjectConfig#execute()} method to invoke the remote
       * operation. <p> {@link GetProjectConfig#initialize(com.google.api.client.googleapis.services.Abs
       * tractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected GetProjectConfig() {
        super(IdentityToolkit.this, "GET", REST_PATH, null, com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyGetProjectConfigResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetProjectConfig setAlt(java.lang.String alt) {
        return (GetProjectConfig) super.setAlt(alt);
      }

      @Override
      public GetProjectConfig setFields(java.lang.String fields) {
        return (GetProjectConfig) super.setFields(fields);
      }

      @Override
      public GetProjectConfig setKey(java.lang.String key) {
        return (GetProjectConfig) super.setKey(key);
      }

      @Override
      public GetProjectConfig setOauthToken(java.lang.String oauthToken) {
        return (GetProjectConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public GetProjectConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetProjectConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetProjectConfig setQuotaUser(java.lang.String quotaUser) {
        return (GetProjectConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetProjectConfig setUserIp(java.lang.String userIp) {
        return (GetProjectConfig) super.setUserIp(userIp);
      }

      /** Delegated GCP project number of the request. */
      @com.google.api.client.util.Key
      private java.lang.String delegatedProjectNumber;

      /** Delegated GCP project number of the request.
       */
      public java.lang.String getDelegatedProjectNumber() {
        return delegatedProjectNumber;
      }

      /** Delegated GCP project number of the request. */
      public GetProjectConfig setDelegatedProjectNumber(java.lang.String delegatedProjectNumber) {
        this.delegatedProjectNumber = delegatedProjectNumber;
        return this;
      }

      /** GCP project number of the request. */
      @com.google.api.client.util.Key
      private java.lang.String projectNumber;

      /** GCP project number of the request.
       */
      public java.lang.String getProjectNumber() {
        return projectNumber;
      }

      /** GCP project number of the request. */
      public GetProjectConfig setProjectNumber(java.lang.String projectNumber) {
        this.projectNumber = projectNumber;
        return this;
      }

      @Override
      public GetProjectConfig set(String parameterName, Object value) {
        return (GetProjectConfig) super.set(parameterName, value);
      }
    }
    /**
     * Get token signing public key.
     *
     * Create a request for the method "relyingparty.getPublicKeys".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link GetPublicKeys#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public GetPublicKeys getPublicKeys() throws java.io.IOException {
      GetPublicKeys result = new GetPublicKeys();
      initialize(result);
      return result;
    }

    public class GetPublicKeys extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyGetPublicKeysResponse> {

      private static final String REST_PATH = "publicKeys";

      /**
       * Get token signing public key.
       *
       * Create a request for the method "relyingparty.getPublicKeys".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link GetPublicKeys#execute()} method to invoke the remote
       * operation. <p> {@link GetPublicKeys#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @since 1.13
       */
      protected GetPublicKeys() {
        super(IdentityToolkit.this, "GET", REST_PATH, null, com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyGetPublicKeysResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetPublicKeys setAlt(java.lang.String alt) {
        return (GetPublicKeys) super.setAlt(alt);
      }

      @Override
      public GetPublicKeys setFields(java.lang.String fields) {
        return (GetPublicKeys) super.setFields(fields);
      }

      @Override
      public GetPublicKeys setKey(java.lang.String key) {
        return (GetPublicKeys) super.setKey(key);
      }

      @Override
      public GetPublicKeys setOauthToken(java.lang.String oauthToken) {
        return (GetPublicKeys) super.setOauthToken(oauthToken);
      }

      @Override
      public GetPublicKeys setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetPublicKeys) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetPublicKeys setQuotaUser(java.lang.String quotaUser) {
        return (GetPublicKeys) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetPublicKeys setUserIp(java.lang.String userIp) {
        return (GetPublicKeys) super.setUserIp(userIp);
      }

      @Override
      public GetPublicKeys set(String parameterName, Object value) {
        return (GetPublicKeys) super.set(parameterName, value);
      }
    }
    /**
     * Get recaptcha secure param.
     *
     * Create a request for the method "relyingparty.getRecaptchaParam".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link GetRecaptchaParam#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public GetRecaptchaParam getRecaptchaParam() throws java.io.IOException {
      GetRecaptchaParam result = new GetRecaptchaParam();
      initialize(result);
      return result;
    }

    public class GetRecaptchaParam extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.GetRecaptchaParamResponse> {

      private static final String REST_PATH = "getRecaptchaParam";

      /**
       * Get recaptcha secure param.
       *
       * Create a request for the method "relyingparty.getRecaptchaParam".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link GetRecaptchaParam#execute()} method to invoke the remote
       * operation. <p> {@link GetRecaptchaParam#initialize(com.google.api.client.googleapis.services.Ab
       * stractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected GetRecaptchaParam() {
        super(IdentityToolkit.this, "GET", REST_PATH, null, com.google.api.services.identitytoolkit.model.GetRecaptchaParamResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetRecaptchaParam setAlt(java.lang.String alt) {
        return (GetRecaptchaParam) super.setAlt(alt);
      }

      @Override
      public GetRecaptchaParam setFields(java.lang.String fields) {
        return (GetRecaptchaParam) super.setFields(fields);
      }

      @Override
      public GetRecaptchaParam setKey(java.lang.String key) {
        return (GetRecaptchaParam) super.setKey(key);
      }

      @Override
      public GetRecaptchaParam setOauthToken(java.lang.String oauthToken) {
        return (GetRecaptchaParam) super.setOauthToken(oauthToken);
      }

      @Override
      public GetRecaptchaParam setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetRecaptchaParam) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetRecaptchaParam setQuotaUser(java.lang.String quotaUser) {
        return (GetRecaptchaParam) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetRecaptchaParam setUserIp(java.lang.String userIp) {
        return (GetRecaptchaParam) super.setUserIp(userIp);
      }

      @Override
      public GetRecaptchaParam set(String parameterName, Object value) {
        return (GetRecaptchaParam) super.set(parameterName, value);
      }
    }
    /**
     * Reset password for a user.
     *
     * Create a request for the method "relyingparty.resetPassword".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link ResetPassword#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyResetPasswordRequest}
     * @return the request
     */
    public ResetPassword resetPassword(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyResetPasswordRequest content) throws java.io.IOException {
      ResetPassword result = new ResetPassword(content);
      initialize(result);
      return result;
    }

    public class ResetPassword extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.ResetPasswordResponse> {

      private static final String REST_PATH = "resetPassword";

      /**
       * Reset password for a user.
       *
       * Create a request for the method "relyingparty.resetPassword".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link ResetPassword#execute()} method to invoke the remote
       * operation. <p> {@link ResetPassword#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyResetPasswordRequest}
       * @since 1.13
       */
      protected ResetPassword(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyResetPasswordRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.ResetPasswordResponse.class);
      }

      @Override
      public ResetPassword setAlt(java.lang.String alt) {
        return (ResetPassword) super.setAlt(alt);
      }

      @Override
      public ResetPassword setFields(java.lang.String fields) {
        return (ResetPassword) super.setFields(fields);
      }

      @Override
      public ResetPassword setKey(java.lang.String key) {
        return (ResetPassword) super.setKey(key);
      }

      @Override
      public ResetPassword setOauthToken(java.lang.String oauthToken) {
        return (ResetPassword) super.setOauthToken(oauthToken);
      }

      @Override
      public ResetPassword setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ResetPassword) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ResetPassword setQuotaUser(java.lang.String quotaUser) {
        return (ResetPassword) super.setQuotaUser(quotaUser);
      }

      @Override
      public ResetPassword setUserIp(java.lang.String userIp) {
        return (ResetPassword) super.setUserIp(userIp);
      }

      @Override
      public ResetPassword set(String parameterName, Object value) {
        return (ResetPassword) super.set(parameterName, value);
      }
    }
    /**
     * Send SMS verification code.
     *
     * Create a request for the method "relyingparty.sendVerificationCode".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link SendVerificationCode#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySendVerificationCodeRequest}
     * @return the request
     */
    public SendVerificationCode sendVerificationCode(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySendVerificationCodeRequest content) throws java.io.IOException {
      SendVerificationCode result = new SendVerificationCode(content);
      initialize(result);
      return result;
    }

    public class SendVerificationCode extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySendVerificationCodeResponse> {

      private static final String REST_PATH = "sendVerificationCode";

      /**
       * Send SMS verification code.
       *
       * Create a request for the method "relyingparty.sendVerificationCode".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link SendVerificationCode#execute()} method to invoke the
       * remote operation. <p> {@link SendVerificationCode#initialize(com.google.api.client.googleapis.s
       * ervices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySendVerificationCodeRequest}
       * @since 1.13
       */
      protected SendVerificationCode(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySendVerificationCodeRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySendVerificationCodeResponse.class);
      }

      @Override
      public SendVerificationCode setAlt(java.lang.String alt) {
        return (SendVerificationCode) super.setAlt(alt);
      }

      @Override
      public SendVerificationCode setFields(java.lang.String fields) {
        return (SendVerificationCode) super.setFields(fields);
      }

      @Override
      public SendVerificationCode setKey(java.lang.String key) {
        return (SendVerificationCode) super.setKey(key);
      }

      @Override
      public SendVerificationCode setOauthToken(java.lang.String oauthToken) {
        return (SendVerificationCode) super.setOauthToken(oauthToken);
      }

      @Override
      public SendVerificationCode setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SendVerificationCode) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SendVerificationCode setQuotaUser(java.lang.String quotaUser) {
        return (SendVerificationCode) super.setQuotaUser(quotaUser);
      }

      @Override
      public SendVerificationCode setUserIp(java.lang.String userIp) {
        return (SendVerificationCode) super.setUserIp(userIp);
      }

      @Override
      public SendVerificationCode set(String parameterName, Object value) {
        return (SendVerificationCode) super.set(parameterName, value);
      }
    }
    /**
     * Set account info for a user.
     *
     * Create a request for the method "relyingparty.setAccountInfo".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link SetAccountInfo#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetAccountInfoRequest}
     * @return the request
     */
    public SetAccountInfo setAccountInfo(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetAccountInfoRequest content) throws java.io.IOException {
      SetAccountInfo result = new SetAccountInfo(content);
      initialize(result);
      return result;
    }

    public class SetAccountInfo extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.SetAccountInfoResponse> {

      private static final String REST_PATH = "setAccountInfo";

      /**
       * Set account info for a user.
       *
       * Create a request for the method "relyingparty.setAccountInfo".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link SetAccountInfo#execute()} method to invoke the remote
       * operation. <p> {@link SetAccountInfo#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetAccountInfoRequest}
       * @since 1.13
       */
      protected SetAccountInfo(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetAccountInfoRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.SetAccountInfoResponse.class);
      }

      @Override
      public SetAccountInfo setAlt(java.lang.String alt) {
        return (SetAccountInfo) super.setAlt(alt);
      }

      @Override
      public SetAccountInfo setFields(java.lang.String fields) {
        return (SetAccountInfo) super.setFields(fields);
      }

      @Override
      public SetAccountInfo setKey(java.lang.String key) {
        return (SetAccountInfo) super.setKey(key);
      }

      @Override
      public SetAccountInfo setOauthToken(java.lang.String oauthToken) {
        return (SetAccountInfo) super.setOauthToken(oauthToken);
      }

      @Override
      public SetAccountInfo setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetAccountInfo) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetAccountInfo setQuotaUser(java.lang.String quotaUser) {
        return (SetAccountInfo) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetAccountInfo setUserIp(java.lang.String userIp) {
        return (SetAccountInfo) super.setUserIp(userIp);
      }

      @Override
      public SetAccountInfo set(String parameterName, Object value) {
        return (SetAccountInfo) super.set(parameterName, value);
      }
    }
    /**
     * Set project configuration.
     *
     * Create a request for the method "relyingparty.setProjectConfig".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link SetProjectConfig#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetProjectConfigRequest}
     * @return the request
     */
    public SetProjectConfig setProjectConfig(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetProjectConfigRequest content) throws java.io.IOException {
      SetProjectConfig result = new SetProjectConfig(content);
      initialize(result);
      return result;
    }

    public class SetProjectConfig extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetProjectConfigResponse> {

      private static final String REST_PATH = "setProjectConfig";

      /**
       * Set project configuration.
       *
       * Create a request for the method "relyingparty.setProjectConfig".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link SetProjectConfig#execute()} method to invoke the remote
       * operation. <p> {@link SetProjectConfig#initialize(com.google.api.client.googleapis.services.Abs
       * tractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetProjectConfigRequest}
       * @since 1.13
       */
      protected SetProjectConfig(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetProjectConfigRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySetProjectConfigResponse.class);
      }

      @Override
      public SetProjectConfig setAlt(java.lang.String alt) {
        return (SetProjectConfig) super.setAlt(alt);
      }

      @Override
      public SetProjectConfig setFields(java.lang.String fields) {
        return (SetProjectConfig) super.setFields(fields);
      }

      @Override
      public SetProjectConfig setKey(java.lang.String key) {
        return (SetProjectConfig) super.setKey(key);
      }

      @Override
      public SetProjectConfig setOauthToken(java.lang.String oauthToken) {
        return (SetProjectConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public SetProjectConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetProjectConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetProjectConfig setQuotaUser(java.lang.String quotaUser) {
        return (SetProjectConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetProjectConfig setUserIp(java.lang.String userIp) {
        return (SetProjectConfig) super.setUserIp(userIp);
      }

      @Override
      public SetProjectConfig set(String parameterName, Object value) {
        return (SetProjectConfig) super.set(parameterName, value);
      }
    }
    /**
     * Sign out user.
     *
     * Create a request for the method "relyingparty.signOutUser".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link SignOutUser#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignOutUserRequest}
     * @return the request
     */
    public SignOutUser signOutUser(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignOutUserRequest content) throws java.io.IOException {
      SignOutUser result = new SignOutUser(content);
      initialize(result);
      return result;
    }

    public class SignOutUser extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignOutUserResponse> {

      private static final String REST_PATH = "signOutUser";

      /**
       * Sign out user.
       *
       * Create a request for the method "relyingparty.signOutUser".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link SignOutUser#execute()} method to invoke the remote
       * operation. <p> {@link
       * SignOutUser#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignOutUserRequest}
       * @since 1.13
       */
      protected SignOutUser(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignOutUserRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignOutUserResponse.class);
      }

      @Override
      public SignOutUser setAlt(java.lang.String alt) {
        return (SignOutUser) super.setAlt(alt);
      }

      @Override
      public SignOutUser setFields(java.lang.String fields) {
        return (SignOutUser) super.setFields(fields);
      }

      @Override
      public SignOutUser setKey(java.lang.String key) {
        return (SignOutUser) super.setKey(key);
      }

      @Override
      public SignOutUser setOauthToken(java.lang.String oauthToken) {
        return (SignOutUser) super.setOauthToken(oauthToken);
      }

      @Override
      public SignOutUser setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SignOutUser) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SignOutUser setQuotaUser(java.lang.String quotaUser) {
        return (SignOutUser) super.setQuotaUser(quotaUser);
      }

      @Override
      public SignOutUser setUserIp(java.lang.String userIp) {
        return (SignOutUser) super.setUserIp(userIp);
      }

      @Override
      public SignOutUser set(String parameterName, Object value) {
        return (SignOutUser) super.set(parameterName, value);
      }
    }
    /**
     * Signup new user.
     *
     * Create a request for the method "relyingparty.signupNewUser".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link SignupNewUser#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignupNewUserRequest}
     * @return the request
     */
    public SignupNewUser signupNewUser(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignupNewUserRequest content) throws java.io.IOException {
      SignupNewUser result = new SignupNewUser(content);
      initialize(result);
      return result;
    }

    public class SignupNewUser extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.SignupNewUserResponse> {

      private static final String REST_PATH = "signupNewUser";

      /**
       * Signup new user.
       *
       * Create a request for the method "relyingparty.signupNewUser".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link SignupNewUser#execute()} method to invoke the remote
       * operation. <p> {@link SignupNewUser#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignupNewUserRequest}
       * @since 1.13
       */
      protected SignupNewUser(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartySignupNewUserRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.SignupNewUserResponse.class);
      }

      @Override
      public SignupNewUser setAlt(java.lang.String alt) {
        return (SignupNewUser) super.setAlt(alt);
      }

      @Override
      public SignupNewUser setFields(java.lang.String fields) {
        return (SignupNewUser) super.setFields(fields);
      }

      @Override
      public SignupNewUser setKey(java.lang.String key) {
        return (SignupNewUser) super.setKey(key);
      }

      @Override
      public SignupNewUser setOauthToken(java.lang.String oauthToken) {
        return (SignupNewUser) super.setOauthToken(oauthToken);
      }

      @Override
      public SignupNewUser setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SignupNewUser) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SignupNewUser setQuotaUser(java.lang.String quotaUser) {
        return (SignupNewUser) super.setQuotaUser(quotaUser);
      }

      @Override
      public SignupNewUser setUserIp(java.lang.String userIp) {
        return (SignupNewUser) super.setUserIp(userIp);
      }

      @Override
      public SignupNewUser set(String parameterName, Object value) {
        return (SignupNewUser) super.set(parameterName, value);
      }
    }
    /**
     * Batch upload existing user accounts.
     *
     * Create a request for the method "relyingparty.uploadAccount".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link UploadAccount#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyUploadAccountRequest}
     * @return the request
     */
    public UploadAccount uploadAccount(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyUploadAccountRequest content) throws java.io.IOException {
      UploadAccount result = new UploadAccount(content);
      initialize(result);
      return result;
    }

    public class UploadAccount extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.UploadAccountResponse> {

      private static final String REST_PATH = "uploadAccount";

      /**
       * Batch upload existing user accounts.
       *
       * Create a request for the method "relyingparty.uploadAccount".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link UploadAccount#execute()} method to invoke the remote
       * operation. <p> {@link UploadAccount#initialize(com.google.api.client.googleapis.services.Abstra
       * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyUploadAccountRequest}
       * @since 1.13
       */
      protected UploadAccount(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyUploadAccountRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.UploadAccountResponse.class);
      }

      @Override
      public UploadAccount setAlt(java.lang.String alt) {
        return (UploadAccount) super.setAlt(alt);
      }

      @Override
      public UploadAccount setFields(java.lang.String fields) {
        return (UploadAccount) super.setFields(fields);
      }

      @Override
      public UploadAccount setKey(java.lang.String key) {
        return (UploadAccount) super.setKey(key);
      }

      @Override
      public UploadAccount setOauthToken(java.lang.String oauthToken) {
        return (UploadAccount) super.setOauthToken(oauthToken);
      }

      @Override
      public UploadAccount setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (UploadAccount) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public UploadAccount setQuotaUser(java.lang.String quotaUser) {
        return (UploadAccount) super.setQuotaUser(quotaUser);
      }

      @Override
      public UploadAccount setUserIp(java.lang.String userIp) {
        return (UploadAccount) super.setUserIp(userIp);
      }

      @Override
      public UploadAccount set(String parameterName, Object value) {
        return (UploadAccount) super.set(parameterName, value);
      }
    }
    /**
     * Verifies the assertion returned by the IdP.
     *
     * Create a request for the method "relyingparty.verifyAssertion".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link VerifyAssertion#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyAssertionRequest}
     * @return the request
     */
    public VerifyAssertion verifyAssertion(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyAssertionRequest content) throws java.io.IOException {
      VerifyAssertion result = new VerifyAssertion(content);
      initialize(result);
      return result;
    }

    public class VerifyAssertion extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.VerifyAssertionResponse> {

      private static final String REST_PATH = "verifyAssertion";

      /**
       * Verifies the assertion returned by the IdP.
       *
       * Create a request for the method "relyingparty.verifyAssertion".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link VerifyAssertion#execute()} method to invoke the remote
       * operation. <p> {@link VerifyAssertion#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyAssertionRequest}
       * @since 1.13
       */
      protected VerifyAssertion(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyAssertionRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.VerifyAssertionResponse.class);
      }

      @Override
      public VerifyAssertion setAlt(java.lang.String alt) {
        return (VerifyAssertion) super.setAlt(alt);
      }

      @Override
      public VerifyAssertion setFields(java.lang.String fields) {
        return (VerifyAssertion) super.setFields(fields);
      }

      @Override
      public VerifyAssertion setKey(java.lang.String key) {
        return (VerifyAssertion) super.setKey(key);
      }

      @Override
      public VerifyAssertion setOauthToken(java.lang.String oauthToken) {
        return (VerifyAssertion) super.setOauthToken(oauthToken);
      }

      @Override
      public VerifyAssertion setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (VerifyAssertion) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public VerifyAssertion setQuotaUser(java.lang.String quotaUser) {
        return (VerifyAssertion) super.setQuotaUser(quotaUser);
      }

      @Override
      public VerifyAssertion setUserIp(java.lang.String userIp) {
        return (VerifyAssertion) super.setUserIp(userIp);
      }

      @Override
      public VerifyAssertion set(String parameterName, Object value) {
        return (VerifyAssertion) super.set(parameterName, value);
      }
    }
    /**
     * Verifies the developer asserted ID token.
     *
     * Create a request for the method "relyingparty.verifyCustomToken".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link VerifyCustomToken#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyCustomTokenRequest}
     * @return the request
     */
    public VerifyCustomToken verifyCustomToken(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyCustomTokenRequest content) throws java.io.IOException {
      VerifyCustomToken result = new VerifyCustomToken(content);
      initialize(result);
      return result;
    }

    public class VerifyCustomToken extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.VerifyCustomTokenResponse> {

      private static final String REST_PATH = "verifyCustomToken";

      /**
       * Verifies the developer asserted ID token.
       *
       * Create a request for the method "relyingparty.verifyCustomToken".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link VerifyCustomToken#execute()} method to invoke the remote
       * operation. <p> {@link VerifyCustomToken#initialize(com.google.api.client.googleapis.services.Ab
       * stractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyCustomTokenRequest}
       * @since 1.13
       */
      protected VerifyCustomToken(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyCustomTokenRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.VerifyCustomTokenResponse.class);
      }

      @Override
      public VerifyCustomToken setAlt(java.lang.String alt) {
        return (VerifyCustomToken) super.setAlt(alt);
      }

      @Override
      public VerifyCustomToken setFields(java.lang.String fields) {
        return (VerifyCustomToken) super.setFields(fields);
      }

      @Override
      public VerifyCustomToken setKey(java.lang.String key) {
        return (VerifyCustomToken) super.setKey(key);
      }

      @Override
      public VerifyCustomToken setOauthToken(java.lang.String oauthToken) {
        return (VerifyCustomToken) super.setOauthToken(oauthToken);
      }

      @Override
      public VerifyCustomToken setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (VerifyCustomToken) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public VerifyCustomToken setQuotaUser(java.lang.String quotaUser) {
        return (VerifyCustomToken) super.setQuotaUser(quotaUser);
      }

      @Override
      public VerifyCustomToken setUserIp(java.lang.String userIp) {
        return (VerifyCustomToken) super.setUserIp(userIp);
      }

      @Override
      public VerifyCustomToken set(String parameterName, Object value) {
        return (VerifyCustomToken) super.set(parameterName, value);
      }
    }
    /**
     * Verifies the user entered password.
     *
     * Create a request for the method "relyingparty.verifyPassword".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link VerifyPassword#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPasswordRequest}
     * @return the request
     */
    public VerifyPassword verifyPassword(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPasswordRequest content) throws java.io.IOException {
      VerifyPassword result = new VerifyPassword(content);
      initialize(result);
      return result;
    }

    public class VerifyPassword extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.VerifyPasswordResponse> {

      private static final String REST_PATH = "verifyPassword";

      /**
       * Verifies the user entered password.
       *
       * Create a request for the method "relyingparty.verifyPassword".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link VerifyPassword#execute()} method to invoke the remote
       * operation. <p> {@link VerifyPassword#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPasswordRequest}
       * @since 1.13
       */
      protected VerifyPassword(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPasswordRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.VerifyPasswordResponse.class);
      }

      @Override
      public VerifyPassword setAlt(java.lang.String alt) {
        return (VerifyPassword) super.setAlt(alt);
      }

      @Override
      public VerifyPassword setFields(java.lang.String fields) {
        return (VerifyPassword) super.setFields(fields);
      }

      @Override
      public VerifyPassword setKey(java.lang.String key) {
        return (VerifyPassword) super.setKey(key);
      }

      @Override
      public VerifyPassword setOauthToken(java.lang.String oauthToken) {
        return (VerifyPassword) super.setOauthToken(oauthToken);
      }

      @Override
      public VerifyPassword setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (VerifyPassword) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public VerifyPassword setQuotaUser(java.lang.String quotaUser) {
        return (VerifyPassword) super.setQuotaUser(quotaUser);
      }

      @Override
      public VerifyPassword setUserIp(java.lang.String userIp) {
        return (VerifyPassword) super.setUserIp(userIp);
      }

      @Override
      public VerifyPassword set(String parameterName, Object value) {
        return (VerifyPassword) super.set(parameterName, value);
      }
    }
    /**
     * Verifies ownership of a phone number and creates/updates the user account accordingly.
     *
     * Create a request for the method "relyingparty.verifyPhoneNumber".
     *
     * This request holds the parameters needed by the identitytoolkit server.  After setting any
     * optional parameters, call the {@link VerifyPhoneNumber#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPhoneNumberRequest}
     * @return the request
     */
    public VerifyPhoneNumber verifyPhoneNumber(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPhoneNumberRequest content) throws java.io.IOException {
      VerifyPhoneNumber result = new VerifyPhoneNumber(content);
      initialize(result);
      return result;
    }

    public class VerifyPhoneNumber extends IdentityToolkitRequest<com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPhoneNumberResponse> {

      private static final String REST_PATH = "verifyPhoneNumber";

      /**
       * Verifies ownership of a phone number and creates/updates the user account accordingly.
       *
       * Create a request for the method "relyingparty.verifyPhoneNumber".
       *
       * This request holds the parameters needed by the the identitytoolkit server.  After setting any
       * optional parameters, call the {@link VerifyPhoneNumber#execute()} method to invoke the remote
       * operation. <p> {@link VerifyPhoneNumber#initialize(com.google.api.client.googleapis.services.Ab
       * stractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPhoneNumberRequest}
       * @since 1.13
       */
      protected VerifyPhoneNumber(com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPhoneNumberRequest content) {
        super(IdentityToolkit.this, "POST", REST_PATH, content, com.google.api.services.identitytoolkit.model.IdentitytoolkitRelyingpartyVerifyPhoneNumberResponse.class);
      }

      @Override
      public VerifyPhoneNumber setAlt(java.lang.String alt) {
        return (VerifyPhoneNumber) super.setAlt(alt);
      }

      @Override
      public VerifyPhoneNumber setFields(java.lang.String fields) {
        return (VerifyPhoneNumber) super.setFields(fields);
      }

      @Override
      public VerifyPhoneNumber setKey(java.lang.String key) {
        return (VerifyPhoneNumber) super.setKey(key);
      }

      @Override
      public VerifyPhoneNumber setOauthToken(java.lang.String oauthToken) {
        return (VerifyPhoneNumber) super.setOauthToken(oauthToken);
      }

      @Override
      public VerifyPhoneNumber setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (VerifyPhoneNumber) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public VerifyPhoneNumber setQuotaUser(java.lang.String quotaUser) {
        return (VerifyPhoneNumber) super.setQuotaUser(quotaUser);
      }

      @Override
      public VerifyPhoneNumber setUserIp(java.lang.String userIp) {
        return (VerifyPhoneNumber) super.setUserIp(userIp);
      }

      @Override
      public VerifyPhoneNumber set(String parameterName, Object value) {
        return (VerifyPhoneNumber) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link IdentityToolkit}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link IdentityToolkit}. */
    @Override
    public IdentityToolkit build() {
      return new IdentityToolkit(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link IdentityToolkitRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setIdentityToolkitRequestInitializer(
        IdentityToolkitRequestInitializer identitytoolkitRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(identitytoolkitRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
