/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * List of tags to be filtered.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TagFilterList extends com.google.api.client.json.GenericJson {

  /**
   * Tags to be filtered. Tags must be DICOM Data Elements, File Meta Elements, or Directory
   * Structuring Elements, as defined at:
   * http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,. They may be
   * provided by "Keyword" or "Tag". For example "PatientID", "00100010".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> tags;

  /**
   * Tags to be filtered. Tags must be DICOM Data Elements, File Meta Elements, or Directory
   * Structuring Elements, as defined at:
   * http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,. They may be
   * provided by "Keyword" or "Tag". For example "PatientID", "00100010".
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTags() {
    return tags;
  }

  /**
   * Tags to be filtered. Tags must be DICOM Data Elements, File Meta Elements, or Directory
   * Structuring Elements, as defined at:
   * http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,. They may be
   * provided by "Keyword" or "Tag". For example "PatientID", "00100010".
   * @param tags tags or {@code null} for none
   */
  public TagFilterList setTags(java.util.List<java.lang.String> tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public TagFilterList set(String fieldName, Object value) {
    return (TagFilterList) super.set(fieldName, value);
  }

  @Override
  public TagFilterList clone() {
    return (TagFilterList) super.clone();
  }

}
