/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * An HL7v2 logical group construct.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SchemaGroup extends com.google.api.client.json.GenericJson {

  /**
   * True indicates that this is a choice group, meaning that only one of its segments can exist in
   * a given message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean choice;

  /**
   * The maximum number of times this group can be repeated. 0 or -1 means unbounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxOccurs;

  /**
   * Nested groups and/or segments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GroupOrSegment> members;

  static {
    // hack to force ProGuard to consider GroupOrSegment used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GroupOrSegment.class);
  }

  /**
   * The minimum number of times this group must be present/repeated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minOccurs;

  /**
   * The name of this group. For example, "ORDER_DETAIL".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * True indicates that this is a choice group, meaning that only one of its segments can exist in
   * a given message.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getChoice() {
    return choice;
  }

  /**
   * True indicates that this is a choice group, meaning that only one of its segments can exist in
   * a given message.
   * @param choice choice or {@code null} for none
   */
  public SchemaGroup setChoice(java.lang.Boolean choice) {
    this.choice = choice;
    return this;
  }

  /**
   * The maximum number of times this group can be repeated. 0 or -1 means unbounded.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxOccurs() {
    return maxOccurs;
  }

  /**
   * The maximum number of times this group can be repeated. 0 or -1 means unbounded.
   * @param maxOccurs maxOccurs or {@code null} for none
   */
  public SchemaGroup setMaxOccurs(java.lang.Integer maxOccurs) {
    this.maxOccurs = maxOccurs;
    return this;
  }

  /**
   * Nested groups and/or segments.
   * @return value or {@code null} for none
   */
  public java.util.List<GroupOrSegment> getMembers() {
    return members;
  }

  /**
   * Nested groups and/or segments.
   * @param members members or {@code null} for none
   */
  public SchemaGroup setMembers(java.util.List<GroupOrSegment> members) {
    this.members = members;
    return this;
  }

  /**
   * The minimum number of times this group must be present/repeated.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinOccurs() {
    return minOccurs;
  }

  /**
   * The minimum number of times this group must be present/repeated.
   * @param minOccurs minOccurs or {@code null} for none
   */
  public SchemaGroup setMinOccurs(java.lang.Integer minOccurs) {
    this.minOccurs = minOccurs;
    return this;
  }

  /**
   * The name of this group. For example, "ORDER_DETAIL".
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this group. For example, "ORDER_DETAIL".
   * @param name name or {@code null} for none
   */
  public SchemaGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public SchemaGroup set(String fieldName, Object value) {
    return (SchemaGroup) super.set(fieldName, value);
  }

  @Override
  public SchemaGroup clone() {
    return (SchemaGroup) super.clone();
  }

}
