/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * OperationMetadata provides information about the operation execution. Returned in the long-
 * running operation's metadata field.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OperationMetadata extends com.google.api.client.json.GenericJson {

  /**
   * The name of the API method that initiated the operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String apiMethodName;

  /**
   * Specifies if cancellation was requested for the operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean cancelRequested;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProgressCounter counter;

  /**
   * The time at which the operation was created by the API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The time at which execution was completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * A link to audit and error logs in the log viewer. Error logs are generated only by some
   * operations, listed at [Viewing error logs in Cloud
   * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String logsUrl;

  /**
   * The name of the API method that initiated the operation.
   * @return value or {@code null} for none
   */
  public java.lang.String getApiMethodName() {
    return apiMethodName;
  }

  /**
   * The name of the API method that initiated the operation.
   * @param apiMethodName apiMethodName or {@code null} for none
   */
  public OperationMetadata setApiMethodName(java.lang.String apiMethodName) {
    this.apiMethodName = apiMethodName;
    return this;
  }

  /**
   * Specifies if cancellation was requested for the operation.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCancelRequested() {
    return cancelRequested;
  }

  /**
   * Specifies if cancellation was requested for the operation.
   * @param cancelRequested cancelRequested or {@code null} for none
   */
  public OperationMetadata setCancelRequested(java.lang.Boolean cancelRequested) {
    this.cancelRequested = cancelRequested;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public ProgressCounter getCounter() {
    return counter;
  }

  /**
   * @param counter counter or {@code null} for none
   */
  public OperationMetadata setCounter(ProgressCounter counter) {
    this.counter = counter;
    return this;
  }

  /**
   * The time at which the operation was created by the API.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * The time at which the operation was created by the API.
   * @param createTime createTime or {@code null} for none
   */
  public OperationMetadata setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The time at which execution was completed.
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * The time at which execution was completed.
   * @param endTime endTime or {@code null} for none
   */
  public OperationMetadata setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * A link to audit and error logs in the log viewer. Error logs are generated only by some
   * operations, listed at [Viewing error logs in Cloud
   * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
   * @return value or {@code null} for none
   */
  public java.lang.String getLogsUrl() {
    return logsUrl;
  }

  /**
   * A link to audit and error logs in the log viewer. Error logs are generated only by some
   * operations, listed at [Viewing error logs in Cloud
   * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
   * @param logsUrl logsUrl or {@code null} for none
   */
  public OperationMetadata setLogsUrl(java.lang.String logsUrl) {
    this.logsUrl = logsUrl;
    return this;
  }

  @Override
  public OperationMetadata set(String fieldName, Object value) {
    return (OperationMetadata) super.set(fieldName, value);
  }

  @Override
  public OperationMetadata clone() {
    return (OperationMetadata) super.clone();
  }

}
