/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Raw bytes representing consent artifact content.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Image extends com.google.api.client.json.GenericJson {

  /**
   * Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must
   * be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service
   * account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage
   * location. The consent artifact content at this URI is copied to a Cloud Storage location
   * managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact
   * content in raw_bytes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gcsUri;

  /**
   * Consent artifact content represented as a stream of bytes. This field is populated when
   * returned in GetConsentArtifact response, but not included in CreateConsentArtifact and
   * ListConsentArtifact response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rawBytes;

  /**
   * Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must
   * be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service
   * account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage
   * location. The consent artifact content at this URI is copied to a Cloud Storage location
   * managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact
   * content in raw_bytes.
   * @return value or {@code null} for none
   */
  public java.lang.String getGcsUri() {
    return gcsUri;
  }

  /**
   * Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must
   * be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service
   * account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage
   * location. The consent artifact content at this URI is copied to a Cloud Storage location
   * managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact
   * content in raw_bytes.
   * @param gcsUri gcsUri or {@code null} for none
   */
  public Image setGcsUri(java.lang.String gcsUri) {
    this.gcsUri = gcsUri;
    return this;
  }

  /**
   * Consent artifact content represented as a stream of bytes. This field is populated when
   * returned in GetConsentArtifact response, but not included in CreateConsentArtifact and
   * ListConsentArtifact response.
   * @see #decodeRawBytes()
   * @return value or {@code null} for none
   */
  public java.lang.String getRawBytes() {
    return rawBytes;
  }

  /**
   * Consent artifact content represented as a stream of bytes. This field is populated when
   * returned in GetConsentArtifact response, but not included in CreateConsentArtifact and
   * ListConsentArtifact response.
   * @see #getRawBytes()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeRawBytes() {
    return com.google.api.client.util.Base64.decodeBase64(rawBytes);
  }

  /**
   * Consent artifact content represented as a stream of bytes. This field is populated when
   * returned in GetConsentArtifact response, but not included in CreateConsentArtifact and
   * ListConsentArtifact response.
   * @see #encodeRawBytes()
   * @param rawBytes rawBytes or {@code null} for none
   */
  public Image setRawBytes(java.lang.String rawBytes) {
    this.rawBytes = rawBytes;
    return this;
  }

  /**
   * Consent artifact content represented as a stream of bytes. This field is populated when
   * returned in GetConsentArtifact response, but not included in CreateConsentArtifact and
   * ListConsentArtifact response.
   * @see #setRawBytes()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Image encodeRawBytes(byte[] rawBytes) {
    this.rawBytes = com.google.api.client.util.Base64.encodeBase64URLSafeString(rawBytes);
    return this;
  }

  @Override
  public Image set(String fieldName, Object value) {
    return (Image) super.set(fieldName, value);
  }

  @Override
  public Image clone() {
    return (Image) super.clone();
  }

}
