/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Root config for HL7v2 datatype definitions for a specific HL7v2 version.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Hl7TypesConfig extends com.google.api.client.json.GenericJson {

  /**
   * The HL7v2 type definitions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Type> type;

  /**
   * The version selectors that this config applies to. A message must match ALL version sources to
   * apply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<VersionSource> version;

  /**
   * The HL7v2 type definitions.
   * @return value or {@code null} for none
   */
  public java.util.List<Type> getType() {
    return type;
  }

  /**
   * The HL7v2 type definitions.
   * @param type type or {@code null} for none
   */
  public Hl7TypesConfig setType(java.util.List<Type> type) {
    this.type = type;
    return this;
  }

  /**
   * The version selectors that this config applies to. A message must match ALL version sources to
   * apply.
   * @return value or {@code null} for none
   */
  public java.util.List<VersionSource> getVersion() {
    return version;
  }

  /**
   * The version selectors that this config applies to. A message must match ALL version sources to
   * apply.
   * @param version version or {@code null} for none
   */
  public Hl7TypesConfig setVersion(java.util.List<VersionSource> version) {
    this.version = version;
    return this;
  }

  @Override
  public Hl7TypesConfig set(String fieldName, Object value) {
    return (Hl7TypesConfig) super.set(fieldName, value);
  }

  @Override
  public Hl7TypesConfig clone() {
    return (Hl7TypesConfig) super.clone();
  }

}
